/*
 * Decompiled with CFR 0.152.
 */
package oz.main;

public class VelocityDecelerator {
    public static final float FRICTIONAL_DECELERATION = 0.01f;
    private int mDirectionX = 1;
    private int mDirectionY = 1;
    private float mVelocityX = 0.0f;
    private float mVelocityY = 0.0f;
    private float mPreviousVelocityX = 0.0f;
    private float mPreviousVelocityY = 0.0f;
    private long mStartTimeX = 0L;
    private long mStartTimeY = 0L;
    private long mPreviousTimeX = 0L;
    private long mPreviousTimeY = 0L;
    private long mCurrentTimeX = 0L;
    private long mCurrentTimeY = 0L;
    private float mTotalTimeX = 0.0f;
    private float mTotalTimeY = 0.0f;
    private long mCurrentTime;
    private float mDeltaTimeX;
    private float mDeltaTimeY;
    private float mTempDistance;

    public VelocityDecelerator(float f2, float f3) {
        this.start(f2, f3);
    }

    public void stop() {
        this.mPreviousVelocityX = 0.0f;
        this.mVelocityX = 0.0f;
        this.mPreviousVelocityY = 0.0f;
        this.mVelocityY = 0.0f;
        this.mTotalTimeX = 0.0f;
        this.mTotalTimeY = 0.0f;
        this.mStartTimeX = 0L;
        this.mStartTimeY = 0L;
    }

    public void start(float f2, float f3) {
        this.mDirectionX = f2 > 0.0f ? 1 : -1;
        this.mDirectionY = f3 > 0.0f ? 1 : -1;
        this.mVelocityX = this.mPreviousVelocityX = Math.abs(f2);
        this.mVelocityY = this.mPreviousVelocityY = Math.abs(f3);
        this.mStartTimeX = this.mCurrentTime = System.currentTimeMillis();
        this.mCurrentTimeX = this.mCurrentTime;
        this.mPreviousTimeX = this.mCurrentTime;
        this.mStartTimeY = this.mCurrentTime;
        this.mCurrentTimeY = this.mCurrentTime;
        this.mPreviousTimeY = this.mCurrentTime;
        this.mTotalTimeX = Math.abs(f2 / 0.01f);
        this.mTotalTimeY = Math.abs(f3 / 0.01f);
    }

    public int getDirectionX() {
        return this.mDirectionX;
    }

    public int getDirectionY() {
        return this.mDirectionY;
    }

    public boolean isMoving() {
        return this.getSpeedX() > 0.0f || this.getSpeedY() > 0.0f;
    }

    private void updateTimeX() {
        this.mCurrentTimeX = System.currentTimeMillis();
    }

    private void updateTimeY() {
        this.mCurrentTimeY = System.currentTimeMillis();
    }

    public void calculateFreezeFrameData() {
        this.mPreviousTimeX = this.mCurrentTimeX;
        this.mPreviousTimeY = this.mCurrentTimeY;
        this.mPreviousVelocityX = this.getSpeedX();
        this.mPreviousVelocityY = this.getSpeedY();
        this.updateTimeX();
        this.updateTimeY();
    }

    private float getSpeedX() {
        this.mDeltaTimeX = this.mCurrentTimeX - this.mStartTimeX;
        if (this.mDeltaTimeX >= this.mTotalTimeX) {
            return 0.0f;
        }
        return this.mVelocityX - 0.01f * this.mDeltaTimeX;
    }

    private float getSpeedY() {
        this.mDeltaTimeY = this.mCurrentTimeY - this.mStartTimeY;
        if (this.mDeltaTimeY >= this.mTotalTimeY) {
            return 0.0f;
        }
        return this.mVelocityY - 0.01f * this.mDeltaTimeY;
    }

    public float getDeltaDistanceX() {
        this.mDeltaTimeX = this.mCurrentTimeX - this.mPreviousTimeX;
        this.mTempDistance = this.mPreviousVelocityX * this.mDeltaTimeX - 0.01f * this.mDeltaTimeX * this.mDeltaTimeX / 2.0f;
        return this.mTempDistance < 0.0f ? 0.0f : this.mTempDistance;
    }

    public float getDeltaDistanceY() {
        this.mDeltaTimeY = this.mCurrentTimeY - this.mPreviousTimeY;
        this.mTempDistance = this.mPreviousVelocityY * this.mDeltaTimeY - 0.01f * this.mDeltaTimeY * this.mDeltaTimeY / 2.0f;
        return this.mTempDistance < 0.0f ? 0.0f : this.mTempDistance;
    }

    public float getCurrentDistanceX() {
        this.mDeltaTimeX = this.mCurrentTimeX - this.mStartTimeX;
        this.mTempDistance = this.mVelocityX * this.mDeltaTimeX - 0.01f * this.mDeltaTimeX * this.mDeltaTimeX / 2.0f;
        return this.mTempDistance < 0.0f ? 0.0f : this.mTempDistance;
    }

    public float getCurrentDistanceY() {
        this.mDeltaTimeY = this.mCurrentTimeY - this.mStartTimeY;
        this.mTempDistance = this.mVelocityY * this.mDeltaTimeY - 0.01f * this.mDeltaTimeY * this.mDeltaTimeY / 2.0f;
        return this.mTempDistance < 0.0f ? 0.0f : this.mTempDistance;
    }

    public float getTotalDistanceX() {
        return this.mVelocityX * this.mTotalTimeX - 0.01f * this.mTotalTimeX * this.mTotalTimeX / 2.0f;
    }

    public float getTotalDistanceY() {
        return this.mVelocityY * this.mTotalTimeY - 0.01f * this.mTotalTimeY * this.mTotalTimeY / 2.0f;
    }
}

