/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Looper;
import android.util.Log;
import oz.util.OZLocationManager$OZLocationListener;
import oz.util.OZLocationManager$OZLocationOnUpdateListener;

public class OZLocationManager {
    private static final int UPDATE_TYPE_ONCE = 0;
    private static final int UPDATE_TYPE_TRACKING = 1;
    private static OZLocationManager mInstance;
    private Context mContext;
    private boolean mTryLoad;
    private boolean mHasGPS;
    private LocationManager mManager;
    private OZLocationManager$OZLocationListener mListener;

    public static OZLocationManager getInstance(Context context) {
        if (mInstance == null && context != null) {
            mInstance = new OZLocationManager(context);
        }
        if (mInstance != null && mInstance.needReset(context)) {
            mInstance.newContext(context);
            mInstance.tryLoad();
        }
        return mInstance;
    }

    private OZLocationManager(Context context) {
        this.mContext = context;
        this.mTryLoad = false;
        this.tryLoad();
    }

    private boolean needReset(Context context) {
        return this.mContext != context && context != null;
    }

    public void reset() {
        this.cancelUpdate();
        this.mContext = null;
        this.mTryLoad = false;
        this.mHasGPS = false;
        this.mManager = null;
    }

    public void newContext(Context context) {
        this.reset();
        this.mContext = context;
    }

    public boolean tryLoad() {
        if (this.mContext != null && !this.mTryLoad) {
            this.mTryLoad = true;
            try {
                this.mManager = (LocationManager)this.mContext.getSystemService("location");
            }
            catch (Exception exception) {
                Log.e((String)"OZViewer", (String)("Get LocationManager failed : " + exception.getMessage()));
            }
            try {
                PackageManager packageManager = this.mContext.getPackageManager();
                this.mHasGPS = packageManager.hasSystemFeature("android.hardware.location");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.isLoaded();
    }

    public boolean isLoaded() {
        return this.mManager != null;
    }

    public boolean requestUpdate(boolean bl, int n, OZLocationManager$OZLocationOnUpdateListener oZLocationManager$OZLocationOnUpdateListener) {
        boolean bl2 = false;
        boolean bl3 = this.tryLoad();
        this.cancelUpdate();
        try {
            if (bl3) {
                boolean bl4 = this.mHasGPS && this.mManager.isProviderEnabled("gps");
                boolean bl5 = this.mManager.isProviderEnabled("network");
                String string = "network";
                if (!bl4 && !bl5) {
                    throw new Exception("gps & network provider disabled");
                }
                if (bl4 && !bl5) {
                    string = "gps";
                } else if (bl4 && bl5 && n == 1) {
                    string = "gps";
                }
                this.mListener = new OZLocationManager$OZLocationListener(this, this.mContext, string, bl, n, oZLocationManager$OZLocationOnUpdateListener);
                if (n == 0) {
                    this.mManager.requestSingleUpdate(string, (LocationListener)this.mListener, Looper.getMainLooper());
                } else {
                    Location location = this.mManager.getLastKnownLocation(string);
                    if (location == null) {
                        location = this.mManager.getLastKnownLocation(string == "gps" ? "network" : "gps");
                    }
                    if (location != null) {
                        this.mListener.onLocationChanged(location);
                    }
                    this.mManager.requestLocationUpdates(string, 3000L, 1.0f, (LocationListener)this.mListener, Looper.getMainLooper());
                }
            } else {
                throw new Exception("location manager is not loaded");
            }
            bl2 = true;
        }
        catch (Exception exception) {
            Log.e((String)"OZViewer", (String)("requestLocationUpdates failed : " + exception.getMessage()));
        }
        return bl2;
    }

    public void cancelUpdate() {
        if (this.mListener != null) {
            this.mListener.stop();
            this.mManager.removeUpdates((LocationListener)this.mListener);
            this.mListener = null;
        }
    }
}

