/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.encoder;

import java.nio.charset.Charset;
import oz.util.barcode.Dimension;
import oz.util.barcode.datamatrix.encoder.SymbolInfo;
import oz.util.barcode.datamatrix.encoder.SymbolShapeHint;

final class EncoderContext {
    private final String msg;
    private SymbolShapeHint shape;
    private Dimension minSize;
    private Dimension maxSize;
    private final StringBuilder codewords;
    int pos;
    private int newEncoding;
    private SymbolInfo symbolInfo;
    private int skipAtEnd;

    EncoderContext(String string) {
        byte[] byArray = string.getBytes(Charset.forName("ISO-8859-1"));
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            char c2 = (char)(byArray[n] & 0xFF);
            if (c2 == '?' && string.charAt(n) != '?') {
                throw new IllegalArgumentException("Message contains characters outside ISO-8859-1 encoding.");
            }
            stringBuilder.append(c2);
            ++n;
        }
        this.msg = stringBuilder.toString();
        this.shape = SymbolShapeHint.FORCE_NONE;
        this.codewords = new StringBuilder(string.length());
        this.newEncoding = -1;
    }

    public void setSymbolShape(SymbolShapeHint symbolShapeHint) {
        this.shape = symbolShapeHint;
    }

    public void setSizeConstraints(Dimension dimension, Dimension dimension2) {
        this.minSize = dimension;
        this.maxSize = dimension2;
    }

    public String getMessage() {
        return this.msg;
    }

    public void setSkipAtEnd(int n) {
        this.skipAtEnd = n;
    }

    public char getCurrentChar() {
        return this.msg.charAt(this.pos);
    }

    public char getCurrent() {
        return this.msg.charAt(this.pos);
    }

    public StringBuilder getCodewords() {
        return this.codewords;
    }

    public void writeCodewords(String string) {
        this.codewords.append(string);
    }

    public void writeCodeword(char c2) {
        this.codewords.append(c2);
    }

    public int getCodewordCount() {
        return this.codewords.length();
    }

    public int getNewEncoding() {
        return this.newEncoding;
    }

    public void signalEncoderChange(int n) {
        this.newEncoding = n;
    }

    public void resetEncoderSignal() {
        this.newEncoding = -1;
    }

    public boolean hasMoreCharacters() {
        return this.pos < this.getTotalMessageCharCount();
    }

    private int getTotalMessageCharCount() {
        return this.msg.length() - this.skipAtEnd;
    }

    public int getRemainingCharacters() {
        return this.getTotalMessageCharCount() - this.pos;
    }

    public SymbolInfo getSymbolInfo() {
        return this.symbolInfo;
    }

    public void updateSymbolInfo() {
        this.updateSymbolInfo(this.getCodewordCount());
    }

    public void updateSymbolInfo(int n) {
        if (this.symbolInfo == null || n > this.symbolInfo.getDataCapacity()) {
            this.symbolInfo = SymbolInfo.lookup(n, this.shape, this.minSize, this.maxSize, true);
        }
    }

    public void resetSymbolInfo() {
        this.symbolInfo = null;
    }
}

