/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.datamatrix.encoder;

import java.util.Arrays;
import oz.util.barcode.Dimension;
import oz.util.barcode.datamatrix.encoder.ASCIIEncoder;
import oz.util.barcode.datamatrix.encoder.Base256Encoder;
import oz.util.barcode.datamatrix.encoder.C40Encoder;
import oz.util.barcode.datamatrix.encoder.EdifactEncoder;
import oz.util.barcode.datamatrix.encoder.Encoder;
import oz.util.barcode.datamatrix.encoder.EncoderContext;
import oz.util.barcode.datamatrix.encoder.SymbolShapeHint;
import oz.util.barcode.datamatrix.encoder.TextEncoder;
import oz.util.barcode.datamatrix.encoder.X12Encoder;

public final class HighLevelEncoder {
    private static final char PAD = '\u0081';
    static final char LATCH_TO_C40 = '\u00e6';
    static final char LATCH_TO_BASE256 = '\u00e7';
    static final char UPPER_SHIFT = '\u00eb';
    private static final char MACRO_05 = '\u00ec';
    private static final char MACRO_06 = '\u00ed';
    static final char LATCH_TO_ANSIX12 = '\u00ee';
    static final char LATCH_TO_TEXT = '\u00ef';
    static final char LATCH_TO_EDIFACT = '\u00f0';
    static final char C40_UNLATCH = '\u00fe';
    static final char X12_UNLATCH = '\u00fe';
    private static final String MACRO_05_HEADER = "[)>\u001e05\u001d";
    private static final String MACRO_06_HEADER = "[)>\u001e06\u001d";
    private static final String MACRO_TRAILER = "\u001e\u0004";
    static final int ASCII_ENCODATION = 0;
    static final int C40_ENCODATION = 1;
    static final int TEXT_ENCODATION = 2;
    static final int X12_ENCODATION = 3;
    static final int EDIFACT_ENCODATION = 4;
    static final int BASE256_ENCODATION = 5;

    private HighLevelEncoder() {
    }

    private static char randomize253State(char c2, int n) {
        int n2 = 149 * n % 253 + 1;
        int n3 = c2 + n2;
        return n3 <= 254 ? (char)n3 : (char)(n3 - 254);
    }

    public static String encodeHighLevel(String string) {
        return HighLevelEncoder.encodeHighLevel(string, SymbolShapeHint.FORCE_NONE, null, null);
    }

    public static String encodeHighLevel(String string, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2) {
        StringBuilder stringBuilder;
        Encoder[] encoderArray = new Encoder[]{new ASCIIEncoder(), new C40Encoder(), new TextEncoder(), new X12Encoder(), new EdifactEncoder(), new Base256Encoder()};
        EncoderContext encoderContext = new EncoderContext(string);
        encoderContext.setSymbolShape(symbolShapeHint);
        encoderContext.setSizeConstraints(dimension, dimension2);
        if (string.startsWith(MACRO_05_HEADER) && string.endsWith(MACRO_TRAILER)) {
            encoderContext.writeCodeword('\u00ec');
            encoderContext.setSkipAtEnd(2);
            encoderContext.pos += MACRO_05_HEADER.length();
        } else if (string.startsWith(MACRO_06_HEADER) && string.endsWith(MACRO_TRAILER)) {
            encoderContext.writeCodeword('\u00ed');
            encoderContext.setSkipAtEnd(2);
            encoderContext.pos += MACRO_06_HEADER.length();
        }
        int n = 0;
        while (encoderContext.hasMoreCharacters()) {
            encoderArray[n].encode(encoderContext);
            if (encoderContext.getNewEncoding() < 0) continue;
            n = encoderContext.getNewEncoding();
            encoderContext.resetEncoderSignal();
        }
        int n2 = encoderContext.getCodewordCount();
        encoderContext.updateSymbolInfo();
        int n3 = encoderContext.getSymbolInfo().getDataCapacity();
        if (n2 < n3 && n != 0 && n != 5) {
            encoderContext.writeCodeword('\u00fe');
        }
        if ((stringBuilder = encoderContext.getCodewords()).length() < n3) {
            stringBuilder.append('\u0081');
        }
        while (stringBuilder.length() < n3) {
            stringBuilder.append(HighLevelEncoder.randomize253State('\u0081', stringBuilder.length() + 1));
        }
        return encoderContext.getCodewords().toString();
    }

    static int lookAheadTest(CharSequence charSequence, int n, int n2) {
        float[] fArray;
        if (n >= charSequence.length()) {
            return n2;
        }
        if (n2 == 0) {
            fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.25f};
        } else {
            fArray = new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.25f};
            fArray[n2] = 0.0f;
        }
        int n3 = 0;
        while (true) {
            int n4;
            Object[] objectArray;
            Object[] objectArray2;
            if (n + n3 == charSequence.length()) {
                int n5 = Integer.MAX_VALUE;
                objectArray2 = new byte[6];
                objectArray = new int[6];
                int n6 = HighLevelEncoder.findMinimums(fArray, objectArray, n5, objectArray2);
                n4 = HighLevelEncoder.getMinimumCount(objectArray2);
                if (objectArray[0] == n6) {
                    return 0;
                }
                if (n4 == 1 && objectArray2[5] > 0) {
                    return 5;
                }
                if (n4 == 1 && objectArray2[4] > 0) {
                    return 4;
                }
                if (n4 == 1 && objectArray2[2] > 0) {
                    return 2;
                }
                if (n4 == 1 && objectArray2[3] > 0) {
                    return 3;
                }
                return 1;
            }
            char c2 = charSequence.charAt(n + n3);
            ++n3;
            if (HighLevelEncoder.isDigit(c2)) {
                fArray[0] = (float)((double)fArray[0] + 0.5);
            } else if (HighLevelEncoder.isExtendedASCII(c2)) {
                fArray[0] = (int)Math.ceil(fArray[0]);
                fArray[0] = fArray[0] + 2.0f;
            } else {
                fArray[0] = (int)Math.ceil(fArray[0]);
                fArray[0] = fArray[0] + 1.0f;
            }
            fArray[1] = HighLevelEncoder.isNativeC40(c2) ? fArray[1] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[1] + 2.6666667f : fArray[1] + 1.3333334f);
            fArray[2] = HighLevelEncoder.isNativeText(c2) ? fArray[2] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[2] + 2.6666667f : fArray[2] + 1.3333334f);
            fArray[3] = HighLevelEncoder.isNativeX12(c2) ? fArray[3] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[3] + 4.3333335f : fArray[3] + 3.3333333f);
            fArray[4] = HighLevelEncoder.isNativeEDIFACT(c2) ? fArray[4] + 0.75f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[4] + 4.25f : fArray[4] + 3.25f);
            fArray[5] = HighLevelEncoder.isSpecialB256(c2) ? fArray[5] + 4.0f : fArray[5] + 1.0f;
            if (n3 < 4) continue;
            objectArray2 = new int[6];
            objectArray = new byte[6];
            HighLevelEncoder.findMinimums(fArray, objectArray2, Integer.MAX_VALUE, (byte[])objectArray);
            n4 = HighLevelEncoder.getMinimumCount((byte[])objectArray);
            if (objectArray2[0] < objectArray2[5] && objectArray2[0] < objectArray2[1] && objectArray2[0] < objectArray2[2] && objectArray2[0] < objectArray2[3] && objectArray2[0] < objectArray2[4]) {
                return 0;
            }
            if (objectArray2[5] < objectArray2[0] || objectArray[1] + objectArray[2] + objectArray[3] + objectArray[4] == 0) {
                return 5;
            }
            if (n4 == 1 && objectArray[4] > 0) {
                return 4;
            }
            if (n4 == 1 && objectArray[2] > 0) {
                return 2;
            }
            if (n4 == 1 && objectArray[3] > 0) {
                return 3;
            }
            if (objectArray2[1] + 1 >= objectArray2[0] || objectArray2[1] + 1 >= objectArray2[5] || objectArray2[1] + 1 >= objectArray2[4] || objectArray2[1] + 1 >= objectArray2[2]) continue;
            if (objectArray2[1] < objectArray2[3]) {
                return 1;
            }
            if (objectArray2[1] == objectArray2[3]) break;
        }
        int n7 = n + n3 + 1;
        while (n7 < charSequence.length()) {
            char c2 = charSequence.charAt(n7);
            if (HighLevelEncoder.isX12TermSep(c2)) {
                return 3;
            }
            if (!HighLevelEncoder.isNativeX12(c2)) break;
            ++n7;
        }
        return 1;
    }

    private static int findMinimums(float[] fArray, int[] nArray, int n, byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        int n2 = 0;
        while (n2 < 6) {
            nArray[n2] = (int)Math.ceil(fArray[n2]);
            int n3 = nArray[n2];
            if (n > n3) {
                n = n3;
                Arrays.fill(byArray, (byte)0);
            }
            if (n == n3) {
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] + 1);
            }
            ++n2;
        }
        return n;
    }

    private static int getMinimumCount(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 6) {
            n += byArray[n2];
            ++n2;
        }
        return n;
    }

    static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    static boolean isExtendedASCII(char c2) {
        return c2 >= '\u0080' && c2 <= '\u00ff';
    }

    private static boolean isNativeC40(char c2) {
        return c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isNativeText(char c2) {
        return c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isNativeX12(char c2) {
        return HighLevelEncoder.isX12TermSep(c2) || c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isX12TermSep(char c2) {
        return c2 == '\r' || c2 == '*' || c2 == '>';
    }

    private static boolean isNativeEDIFACT(char c2) {
        return c2 >= ' ' && c2 <= '^';
    }

    private static boolean isSpecialB256(char c2) {
        return false;
    }

    public static int determineConsecutiveDigitCount(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = charSequence.length();
        if (n3 < n4) {
            char c2 = charSequence.charAt(n3);
            while (HighLevelEncoder.isDigit(c2) && n3 < n4) {
                ++n2;
                if (++n3 >= n4) continue;
                c2 = charSequence.charAt(n3);
            }
        }
        return n2;
    }

    static void illegalCharacter(char c2) {
        String string = Integer.toHexString(c2);
        string = String.valueOf("0000".substring(0, 4 - string.length())) + string;
        throw new IllegalArgumentException("Illegal character: " + c2 + " (0x" + string + ')');
    }
}

