/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.SecureRandom;

public class SecureRandomInitializer {
    private static final int NUM_RANDOM_BYTES = 16;
    private static byte[] sSeedBytes = new byte[16];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(SecureRandom generator) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("/dev/urandom");
            if (fis.read(sSeedBytes) != sSeedBytes.length) {
                throw new IOException("Failed to get enough random data.");
            }
            generator.setSeed(sSeedBytes);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

