/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.os.Handler;
import android.os.StrictMode;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.Log;
import org.chromium.base.ResourceExtractor;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.library_loader.LibraryLoader;
import org.chromium.base.library_loader.ProcessInitException;
import org.chromium.content.app.ContentMain;
import org.chromium.content.browser.DeviceUtils;
import org.chromium.content.browser.PepperPluginManager;

@JNINamespace(value="content")
public class BrowserStartupController {
    private static final String TAG = "cr.BrowserStartup";
    private static final boolean ALREADY_STARTED = true;
    private static final boolean NOT_ALREADY_STARTED = false;
    @VisibleForTesting
    static final int STARTUP_SUCCESS = -1;
    @VisibleForTesting
    static final int STARTUP_FAILURE = 1;
    private static BrowserStartupController sInstance;
    private static boolean sBrowserMayStartAsynchronously;
    private static boolean sShouldStartGpuProcessOnBrowserStartup;
    private final List<StartupCallback> mAsyncStartupCallbacks;
    private final Context mContext;
    private boolean mHasStartedInitializingBrowserProcess;
    private boolean mPostResourceExtractionTasksCompleted;
    private boolean mStartupDone;
    private boolean mStartupSuccess;
    private int mLibraryProcessType;

    private static void setAsynchronousStartup(boolean enable) {
        sBrowserMayStartAsynchronously = enable;
    }

    private static void setShouldStartGpuProcessOnBrowserStartup(boolean enable) {
        sShouldStartGpuProcessOnBrowserStartup = enable;
    }

    @VisibleForTesting
    @CalledByNative
    static boolean browserMayStartAsynchonously() {
        return sBrowserMayStartAsynchronously;
    }

    @VisibleForTesting
    @CalledByNative
    static void browserStartupComplete(int result) {
        if (sInstance != null) {
            sInstance.executeEnqueuedCallbacks(result, false);
        }
    }

    @CalledByNative
    static boolean shouldStartGpuProcessOnBrowserStartup() {
        return sShouldStartGpuProcessOnBrowserStartup;
    }

    BrowserStartupController(Context context, int libraryProcessType) {
        this.mContext = context.getApplicationContext();
        this.mAsyncStartupCallbacks = new ArrayList<StartupCallback>();
        this.mLibraryProcessType = libraryProcessType;
    }

    public static BrowserStartupController get(Context context, int libraryProcessType) {
        assert (ThreadUtils.runningOnUiThread()) : "Tried to start the browser on the wrong thread.";
        ThreadUtils.assertOnUiThread();
        if (sInstance == null) {
            assert (1 == libraryProcessType || 3 == libraryProcessType);
            sInstance = new BrowserStartupController(context, libraryProcessType);
        }
        assert (BrowserStartupController.sInstance.mLibraryProcessType == libraryProcessType) : "Wrong process type";
        return sInstance;
    }

    @VisibleForTesting
    static BrowserStartupController overrideInstanceForTest(BrowserStartupController controller) {
        if (sInstance == null) {
            sInstance = controller;
        }
        return sInstance;
    }

    public void startBrowserProcessesAsync(boolean startGpuProcess, StartupCallback callback) throws ProcessInitException {
        assert (ThreadUtils.runningOnUiThread()) : "Tried to start the browser on the wrong thread.";
        if (this.mStartupDone) {
            this.postStartupCompleted(callback);
            return;
        }
        this.mAsyncStartupCallbacks.add(callback);
        if (!this.mHasStartedInitializingBrowserProcess) {
            this.mHasStartedInitializingBrowserProcess = true;
            BrowserStartupController.setAsynchronousStartup(true);
            BrowserStartupController.setShouldStartGpuProcessOnBrowserStartup(startGpuProcess);
            this.prepareToStartBrowserProcess(false, new Runnable(){

                @Override
                public void run() {
                    ThreadUtils.assertOnUiThread();
                    if (BrowserStartupController.this.contentStart() > 0) {
                        BrowserStartupController.this.enqueueCallbackExecution(1, false);
                    }
                }
            });
        }
    }

    public void startBrowserProcessesSync(boolean singleProcess) throws ProcessInitException {
        if (!this.mStartupDone) {
            if (!this.mHasStartedInitializingBrowserProcess || !this.mPostResourceExtractionTasksCompleted) {
                this.prepareToStartBrowserProcess(singleProcess, null);
            }
            BrowserStartupController.setAsynchronousStartup(false);
            if (this.contentStart() > 0) {
                this.enqueueCallbackExecution(1, false);
            }
        }
        assert (this.mStartupDone);
        if (!this.mStartupSuccess) {
            throw new ProcessInitException(4);
        }
    }

    @VisibleForTesting
    int contentStart() {
        return ContentMain.start();
    }

    public void addStartupCompletedObserver(StartupCallback callback) {
        ThreadUtils.assertOnUiThread();
        if (this.mStartupDone) {
            this.postStartupCompleted(callback);
        } else {
            this.mAsyncStartupCallbacks.add(callback);
        }
    }

    private void executeEnqueuedCallbacks(int startupResult, boolean alreadyStarted) {
        assert (ThreadUtils.runningOnUiThread()) : "Callback from browser startup from wrong thread.";
        this.mStartupDone = true;
        this.mStartupSuccess = startupResult <= 0;
        for (StartupCallback asyncStartupCallback : this.mAsyncStartupCallbacks) {
            if (this.mStartupSuccess) {
                asyncStartupCallback.onSuccess(alreadyStarted);
                continue;
            }
            asyncStartupCallback.onFailure();
        }
        this.mAsyncStartupCallbacks.clear();
    }

    private void enqueueCallbackExecution(final int startupFailure, final boolean alreadyStarted) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                BrowserStartupController.this.executeEnqueuedCallbacks(startupFailure, alreadyStarted);
            }
        });
    }

    private void postStartupCompleted(final StartupCallback callback) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                if (BrowserStartupController.this.mStartupSuccess) {
                    callback.onSuccess(true);
                } else {
                    callback.onFailure();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void prepareToStartBrowserProcess(final boolean singleProcess, final Runnable completionCallback) throws ProcessInitException {
        Log.i(TAG, "Initializing chromium process, singleProcess=%b", singleProcess);
        ResourceExtractor resourceExtractor = ResourceExtractor.get(this.mContext);
        resourceExtractor.startExtractingResources();
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            LibraryLoader.get(this.mLibraryProcessType).ensureInitialized(this.mContext);
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        Runnable postResourceExtraction = new Runnable(){

            @Override
            public void run() {
                if (!BrowserStartupController.this.mPostResourceExtractionTasksCompleted) {
                    DeviceUtils.addDeviceSpecificUserAgentSwitch(BrowserStartupController.this.mContext);
                    BrowserStartupController.nativeSetCommandLineFlags(singleProcess, BrowserStartupController.nativeIsPluginEnabled() ? BrowserStartupController.this.getPlugins() : null);
                    BrowserStartupController.this.mPostResourceExtractionTasksCompleted = true;
                }
                if (completionCallback != null) {
                    completionCallback.run();
                }
            }
        };
        if (completionCallback == null) {
            resourceExtractor.waitForCompletion();
            postResourceExtraction.run();
        } else {
            resourceExtractor.addCompletionCallback(postResourceExtraction);
        }
    }

    public void initChromiumBrowserProcessForTests() {
        ResourceExtractor resourceExtractor = ResourceExtractor.get(this.mContext);
        resourceExtractor.startExtractingResources();
        resourceExtractor.waitForCompletion();
        BrowserStartupController.nativeSetCommandLineFlags(false, null);
    }

    private String getPlugins() {
        return PepperPluginManager.getPlugins(this.mContext);
    }

    private static native void nativeSetCommandLineFlags(boolean var0, String var1);

    private static native boolean nativeIsOfficialBuild();

    private static native boolean nativeIsPluginEnabled();

    static {
        sBrowserMayStartAsynchronously = false;
        sShouldStartGpuProcessOnBrowserStartup = true;
    }

    public static interface StartupCallback {
        public void onSuccess(boolean var1);

        public void onFailure();
    }
}

