/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.res.Configuration;
import android.os.Build;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.UnderlineSpan;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import org.chromium.base.Log;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.input.ChromiumBaseInputConnection;
import org.chromium.content.browser.input.CursorAnchorInfoController;
import org.chromium.content.browser.input.InputMethodManagerWrapper;
import org.chromium.content.browser.input.ReplicaInputConnection;
import org.chromium.content.browser.input.ThreadedInputConnectionFactory;
import org.chromium.ui.picker.InputDialogContainer;

@JNINamespace(value="content")
public class ImeAdapter {
    private static final String TAG = "cr_Ime";
    private static final boolean DEBUG_LOGS = false;
    private static final int COMPOSITION_KEY_CODE = 229;
    static char[] sSingleCharArray = new char[1];
    static KeyCharacterMap sKeyCharacterMap;
    private long mNativeImeAdapterAndroid;
    private InputMethodManagerWrapper mInputMethodManagerWrapper;
    private ChromiumBaseInputConnection mInputConnection;
    private ChromiumBaseInputConnection.Factory mInputConnectionFactory;
    private final ImeAdapterDelegate mViewEmbedder;
    private final CursorAnchorInfoController mCursorAnchorInfoController;
    private int mTextInputType = 0;
    private int mTextInputFlags;
    private Configuration mCurrentConfig;
    private int mLastSelectionStart;
    private int mLastSelectionEnd;
    private String mLastText;
    private int mLastCompositionStart;
    private int mLastCompositionEnd;

    public ImeAdapter(InputMethodManagerWrapper wrapper, ImeAdapterDelegate embedder) {
        this.mInputMethodManagerWrapper = wrapper;
        this.mViewEmbedder = embedder;
        this.mCurrentConfig = new Configuration(this.mViewEmbedder.getAttachedView().getResources().getConfiguration());
        this.mCursorAnchorInfoController = Build.VERSION.SDK_INT >= 21 ? CursorAnchorInfoController.create(wrapper, new CursorAnchorInfoController.ComposingTextDelegate(){

            @Override
            public CharSequence getText() {
                return ImeAdapter.this.mLastText;
            }

            @Override
            public int getSelectionStart() {
                return ImeAdapter.this.mLastSelectionStart;
            }

            @Override
            public int getSelectionEnd() {
                return ImeAdapter.this.mLastSelectionEnd;
            }

            @Override
            public int getComposingTextStart() {
                return ImeAdapter.this.mLastCompositionStart;
            }

            @Override
            public int getComposingTextEnd() {
                return ImeAdapter.this.mLastCompositionEnd;
            }
        }) : null;
    }

    private boolean isImeThreadEnabled() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        return this.nativeIsImeThreadEnabled(this.mNativeImeAdapterAndroid);
    }

    private void createInputConnectionFactory() {
        if (this.mInputConnectionFactory != null) {
            return;
        }
        if (this.isImeThreadEnabled()) {
            Log.i(TAG, "ImeThread is enabled.", new Object[0]);
            this.mInputConnectionFactory = new ThreadedInputConnectionFactory(this.mInputMethodManagerWrapper);
        } else {
            Log.i(TAG, "ImeThread is not enabled.", new Object[0]);
            this.mInputConnectionFactory = new ReplicaInputConnection.Factory();
        }
    }

    public ChromiumBaseInputConnection onCreateInputConnection(EditorInfo outAttrs) {
        outAttrs.imeOptions = 0x12000000;
        if (this.mTextInputType == 0) {
            this.setInputConnection(null);
            return null;
        }
        if (this.mInputConnectionFactory == null) {
            return null;
        }
        this.setInputConnection(this.mInputConnectionFactory.initializeAndGet(this.mViewEmbedder.getAttachedView(), this, this.mTextInputType, this.mTextInputFlags, this.mLastSelectionStart, this.mLastSelectionEnd, outAttrs));
        if (this.mCursorAnchorInfoController != null) {
            this.mCursorAnchorInfoController.resetMonitoringState();
        }
        return this.mInputConnection;
    }

    private void setInputConnection(ChromiumBaseInputConnection inputConnection) {
        if (this.mInputConnection == inputConnection) {
            return;
        }
        if (this.mInputConnection != null) {
            this.mInputConnection.unblockOnUiThread();
        }
        this.mInputConnection = inputConnection;
    }

    @VisibleForTesting
    public void setInputMethodManagerWrapperForTest(InputMethodManagerWrapper immw) {
        this.mInputMethodManagerWrapper = immw;
        if (this.mCursorAnchorInfoController != null) {
            this.mCursorAnchorInfoController.setInputMethodManagerWrapperForTest(immw);
        }
    }

    @VisibleForTesting
    void setInputConnectionFactory(ChromiumBaseInputConnection.Factory factory) {
        this.mInputConnectionFactory = factory;
    }

    @VisibleForTesting
    ChromiumBaseInputConnection.Factory getInputConnectionFactoryForTest() {
        return this.mInputConnectionFactory;
    }

    @VisibleForTesting
    public ChromiumBaseInputConnection getInputConnectionForTest() {
        return this.mInputConnection;
    }

    private static int getModifiers(int metaState) {
        int modifiers = 0;
        if ((metaState & 1) != 0) {
            modifiers |= 1;
        }
        if ((metaState & 2) != 0) {
            modifiers |= 4;
        }
        if ((metaState & 0x1000) != 0) {
            modifiers |= 2;
        }
        if ((metaState & 0x100000) != 0) {
            modifiers |= 0x200;
        }
        if ((metaState & 0x200000) != 0) {
            modifiers |= 0x400;
        }
        return modifiers;
    }

    public void updateKeyboardVisibility(int textInputType, int textInputFlags, boolean showIfNeeded) {
        this.mTextInputFlags = textInputFlags;
        if (this.mTextInputType != textInputType) {
            this.mTextInputType = textInputType;
            if (textInputType != 0) {
                this.restartInput();
            }
        }
        if (textInputType != 0) {
            if (showIfNeeded) {
                this.showSoftKeyboard();
            }
        } else {
            this.hideKeyboard();
        }
    }

    public void updateState(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean isNonImeChange) {
        if (!(this.mCursorAnchorInfoController == null || TextUtils.equals((CharSequence)this.mLastText, (CharSequence)text) && this.mLastSelectionStart == selectionStart && this.mLastSelectionEnd == selectionEnd && this.mLastCompositionStart == compositionStart && this.mLastCompositionEnd == compositionEnd)) {
            this.mCursorAnchorInfoController.invalidateLastCursorAnchorInfo();
        }
        this.mLastText = text;
        this.mLastSelectionStart = selectionStart;
        this.mLastSelectionEnd = selectionEnd;
        this.mLastCompositionStart = compositionStart;
        this.mLastCompositionEnd = compositionEnd;
        if (this.mInputConnection == null) {
            return;
        }
        boolean singleLine = this.mTextInputType != 14 && this.mTextInputType != 15;
        this.mInputConnection.updateStateOnUiThread(text, selectionStart, selectionEnd, compositionStart, compositionEnd, singleLine, isNonImeChange);
    }

    public void attach(long nativeImeAdapter) {
        if (this.mNativeImeAdapterAndroid == nativeImeAdapter) {
            return;
        }
        if (this.mNativeImeAdapterAndroid != 0L) {
            this.nativeResetImeAdapter(this.mNativeImeAdapterAndroid);
        }
        if (nativeImeAdapter != 0L) {
            this.nativeAttachImeAdapter(nativeImeAdapter);
        }
        this.mNativeImeAdapterAndroid = nativeImeAdapter;
        if (nativeImeAdapter != 0L) {
            this.createInputConnectionFactory();
        }
    }

    private void showSoftKeyboard() {
        this.mInputMethodManagerWrapper.showSoftInput(this.mViewEmbedder.getAttachedView(), 0, this.mViewEmbedder.getNewShowKeyboardReceiver());
        if (this.mViewEmbedder.getAttachedView().getResources().getConfiguration().keyboard != 1) {
            this.mViewEmbedder.onKeyboardBoundsUnchanged();
        }
    }

    private void hideKeyboard() {
        View view = this.mViewEmbedder.getAttachedView();
        if (this.mInputMethodManagerWrapper.isActive(view)) {
            this.mInputMethodManagerWrapper.hideSoftInputFromWindow(view.getWindowToken(), 0, null);
        }
        if (this.mTextInputType == 0 && this.mInputConnection != null) {
            this.restartInput();
        }
    }

    public void onKeyboardConfigurationChanged(Configuration newConfig) {
        if (this.mCurrentConfig.keyboard == newConfig.keyboard && this.mCurrentConfig.keyboardHidden == newConfig.keyboardHidden && this.mCurrentConfig.hardKeyboardHidden == newConfig.hardKeyboardHidden) {
            return;
        }
        this.mCurrentConfig = new Configuration(newConfig);
        if (this.mTextInputType != 0) {
            this.restartInput();
            this.showSoftKeyboard();
        }
    }

    public void onWindowFocusChanged(boolean gainFocus) {
        if (this.mInputConnectionFactory != null) {
            this.mInputConnectionFactory.onWindowFocusChanged(gainFocus);
        }
    }

    public void onViewAttachedToWindow() {
        if (this.mInputConnectionFactory != null) {
            this.mInputConnectionFactory.onViewAttachedToWindow();
        }
    }

    public void onViewDetachedFromWindow() {
        if (this.mInputConnectionFactory != null) {
            this.mInputConnectionFactory.onViewDetachedFromWindow();
        }
    }

    public void onViewFocusChanged(boolean gainFocus) {
        if (!gainFocus) {
            this.resetAndHideKeyboard();
        }
        if (this.mInputConnectionFactory != null) {
            this.mInputConnectionFactory.onViewFocusChanged(gainFocus);
        }
    }

    public void moveCursorToSelectionEnd() {
        if (this.mInputConnection != null) {
            this.mInputConnection.moveCursorToSelectionEndOnUiThread();
        }
    }

    @VisibleForTesting
    void setInputTypeForTest(int textInputType) {
        this.mTextInputType = textInputType;
    }

    private static boolean isTextInputType(int type2) {
        return type2 != 0 && !InputDialogContainer.isDialogInputType(type2);
    }

    public boolean hasTextInputType() {
        return ImeAdapter.isTextInputType(this.mTextInputType);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mInputConnection != null) {
            return this.mInputConnection.sendKeyEventOnUiThread(event);
        }
        return this.sendKeyEvent(event);
    }

    public void resetAndHideKeyboard() {
        this.mTextInputType = 0;
        this.mTextInputFlags = 0;
        this.hideKeyboard();
    }

    void updateSelection(int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
        this.mInputMethodManagerWrapper.updateSelection(this.mViewEmbedder.getAttachedView(), selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    void restartInput() {
        this.mInputMethodManagerWrapper.restartInput(this.mViewEmbedder.getAttachedView());
        if (this.mInputConnection != null) {
            this.mInputConnection.onRestartInputOnUiThread();
        }
    }

    boolean performContextMenuAction(int id2) {
        return this.mViewEmbedder.performContextMenuAction(id2);
    }

    boolean performEditorAction(int actionCode) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        if (actionCode == 5) {
            this.sendSyntheticKeyPress(61, 22);
        } else {
            this.sendSyntheticKeyPress(66, 22);
        }
        return true;
    }

    void notifyUserAction() {
        this.mInputMethodManagerWrapper.notifyUserAction();
    }

    @VisibleForTesting
    protected void sendSyntheticKeyPress(int keyCode, int flags) {
        long eventTime = SystemClock.uptimeMillis();
        this.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, keyCode, 0, 0, -1, 0, flags));
        this.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, keyCode, 0, 0, -1, 0, flags));
    }

    boolean sendCompositionToNative(CharSequence text, int newCursorPosition, boolean isCommit, int unicodeFromKeyEvent) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        if (TextUtils.equals((CharSequence)text, (CharSequence)"\n")) {
            this.sendSyntheticKeyPress(66, 6);
            return true;
        }
        this.mViewEmbedder.onImeEvent();
        long timestampMs = SystemClock.uptimeMillis();
        this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, 7, timestampMs, 229, 0, unicodeFromKeyEvent);
        if (isCommit) {
            this.nativeCommitText(this.mNativeImeAdapterAndroid, text.toString());
        } else {
            this.nativeSetComposingText(this.mNativeImeAdapterAndroid, text, text.toString(), newCursorPosition);
        }
        this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, 9, timestampMs, 229, 0, unicodeFromKeyEvent);
        return true;
    }

    @VisibleForTesting
    boolean finishComposingText() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeFinishComposingText(this.mNativeImeAdapterAndroid);
        return true;
    }

    boolean sendKeyEvent(KeyEvent event) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        int action = event.getAction();
        if (action != 0 && action != 1) {
            return false;
        }
        this.mViewEmbedder.onImeEvent();
        return this.nativeSendKeyEvent(this.mNativeImeAdapterAndroid, event, event.getAction(), ImeAdapter.getModifiers(event.getMetaState()), event.getEventTime(), event.getKeyCode(), event.getScanCode(), false, event.getUnicodeChar());
    }

    boolean deleteSurroundingText(int beforeLength, int afterLength) {
        this.mViewEmbedder.onImeEvent();
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, 7, SystemClock.uptimeMillis(), 229, 0, 0);
        this.nativeDeleteSurroundingText(this.mNativeImeAdapterAndroid, beforeLength, afterLength);
        this.nativeSendSyntheticKeyEvent(this.mNativeImeAdapterAndroid, 9, SystemClock.uptimeMillis(), 229, 0, 0);
        return true;
    }

    boolean setEditableSelectionOffsets(int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSetEditableSelectionOffsets(this.mNativeImeAdapterAndroid, start, end);
        return true;
    }

    boolean setComposingRegion(int start, int end) {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        this.nativeSetComposingRegion(this.mNativeImeAdapterAndroid, start, end);
        return true;
    }

    @CalledByNative
    private void focusedNodeChanged(boolean isEditable) {
        if (this.mCursorAnchorInfoController != null) {
            this.mCursorAnchorInfoController.focusedNodeChanged(isEditable);
        }
        if (this.mTextInputType != 0 && this.mInputConnection != null && isEditable) {
            this.restartInput();
        }
    }

    boolean requestTextInputStateUpdate() {
        if (this.mNativeImeAdapterAndroid == 0L) {
            return false;
        }
        if (this.mInputConnection == null) {
            return false;
        }
        return this.nativeRequestTextInputStateUpdate(this.mNativeImeAdapterAndroid);
    }

    public boolean onRequestCursorUpdates(int cursorUpdateMode) {
        if (this.mCursorAnchorInfoController == null) {
            return false;
        }
        return this.mCursorAnchorInfoController.onRequestCursorUpdates(cursorUpdateMode, this.mViewEmbedder.getAttachedView());
    }

    public void onUpdateFrameInfo(RenderCoordinates renderCoordinates, boolean hasInsertionMarker, boolean isInsertionMarkerVisible, float insertionMarkerHorizontal, float insertionMarkerTop, float insertionMarkerBottom) {
        if (this.mCursorAnchorInfoController == null) {
            return;
        }
        this.mCursorAnchorInfoController.onUpdateFrameInfo(renderCoordinates, hasInsertionMarker, isInsertionMarkerVisible, insertionMarkerHorizontal, insertionMarkerTop, insertionMarkerBottom, this.mViewEmbedder.getAttachedView());
    }

    @CalledByNative
    private void populateUnderlinesFromSpans(CharSequence text, long underlines) {
        CharacterStyle[] spans;
        if (!(text instanceof SpannableString)) {
            return;
        }
        SpannableString spannableString = (SpannableString)text;
        for (CharacterStyle span : spans = (CharacterStyle[])spannableString.getSpans(0, text.length(), CharacterStyle.class)) {
            if (span instanceof BackgroundColorSpan) {
                ImeAdapter.nativeAppendBackgroundColorSpan(underlines, spannableString.getSpanStart((Object)span), spannableString.getSpanEnd((Object)span), ((BackgroundColorSpan)span).getBackgroundColor());
                continue;
            }
            if (!(span instanceof UnderlineSpan)) continue;
            ImeAdapter.nativeAppendUnderlineSpan(underlines, spannableString.getSpanStart((Object)span), spannableString.getSpanEnd((Object)span));
        }
    }

    @CalledByNative
    private void cancelComposition() {
        if (this.mInputConnection != null) {
            this.restartInput();
        }
    }

    @CalledByNative
    private void setCharacterBounds(float[] characterBounds) {
        if (this.mCursorAnchorInfoController == null) {
            return;
        }
        this.mCursorAnchorInfoController.setCompositionCharacterBounds(characterBounds);
    }

    @CalledByNative
    private void detach() {
        this.mNativeImeAdapterAndroid = 0L;
        if (this.mCursorAnchorInfoController != null) {
            this.mCursorAnchorInfoController.focusedNodeChanged(false);
        }
    }

    private native boolean nativeSendSyntheticKeyEvent(long var1, int var3, long var4, int var6, int var7, int var8);

    private native boolean nativeSendKeyEvent(long var1, KeyEvent var3, int var4, int var5, long var6, int var8, int var9, boolean var10, int var11);

    private static native void nativeAppendUnderlineSpan(long var0, int var2, int var3);

    private static native void nativeAppendBackgroundColorSpan(long var0, int var2, int var3, int var4);

    private native void nativeSetComposingText(long var1, CharSequence var3, String var4, int var5);

    private native void nativeCommitText(long var1, String var3);

    private native void nativeFinishComposingText(long var1);

    private native void nativeAttachImeAdapter(long var1);

    private native void nativeSetEditableSelectionOffsets(long var1, int var3, int var4);

    private native void nativeSetComposingRegion(long var1, int var3, int var4);

    private native void nativeDeleteSurroundingText(long var1, int var3, int var4);

    private native void nativeResetImeAdapter(long var1);

    private native boolean nativeRequestTextInputStateUpdate(long var1);

    private native boolean nativeIsImeThreadEnabled(long var1);

    public static interface ImeAdapterDelegate {
        public void onImeEvent();

        public void onKeyboardBoundsUnchanged();

        public boolean performContextMenuAction(int var1);

        public View getAttachedView();

        public ResultReceiver getNewShowKeyboardReceiver();
    }
}

