/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import java.util.List;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.input.SelectPopup;
import org.chromium.content.browser.input.SelectPopupItem;
import org.chromium.ui.DropdownAdapter;
import org.chromium.ui.DropdownPopupWindow;

public class SelectPopupDropdown
implements SelectPopup {
    private final ContentViewCore mContentViewCore;
    private final Context mContext;
    private final DropdownPopupWindow mDropdownPopupWindow;
    private boolean mSelectionNotified;

    public SelectPopupDropdown(ContentViewCore contentViewCore, List<SelectPopupItem> items, Rect bounds, int[] selected, boolean rightAligned) {
        this.mContentViewCore = contentViewCore;
        this.mContext = this.mContentViewCore.getContext();
        this.mDropdownPopupWindow = new DropdownPopupWindow(this.mContext, this.mContentViewCore.getViewAndroidDelegate());
        this.mDropdownPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SelectPopupDropdown.this.notifySelection(new int[]{position});
                SelectPopupDropdown.this.hide(false);
            }
        });
        int initialSelection = -1;
        if (selected.length > 0) {
            initialSelection = selected[0];
        }
        this.mDropdownPopupWindow.setInitialSelection(initialSelection);
        this.mDropdownPopupWindow.setAdapter((ListAdapter)new DropdownAdapter(this.mContext, items, null));
        this.mDropdownPopupWindow.setRtl(rightAligned);
        RenderCoordinates renderCoordinates = this.mContentViewCore.getRenderCoordinates();
        float anchorX = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.left));
        float anchorY = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.top));
        float anchorWidth = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.right)) - anchorX;
        float anchorHeight = renderCoordinates.fromPixToDip(renderCoordinates.fromLocalCssToPix(bounds.bottom)) - anchorY;
        this.mDropdownPopupWindow.setAnchorRect(anchorX, anchorY, anchorWidth, anchorHeight);
        this.mDropdownPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                SelectPopupDropdown.this.notifySelection(null);
            }
        });
    }

    private void notifySelection(int[] indicies) {
        if (this.mSelectionNotified) {
            return;
        }
        this.mContentViewCore.selectPopupMenuItems(indicies);
        this.mSelectionNotified = true;
    }

    @Override
    public void show() {
        this.mDropdownPopupWindow.postShow();
    }

    @Override
    public void hide(boolean sendsCancelMessage) {
        if (sendsCancelMessage) {
            this.mDropdownPopupWindow.dismiss();
            this.notifySelection(null);
        } else {
            this.mSelectionNotified = true;
            this.mDropdownPopupWindow.dismiss();
        }
    }
}

