/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.system;

import java.nio.ByteBuffer;
import org.chromium.mojo.system.Flags;
import org.chromium.mojo.system.Handle;
import org.chromium.mojo.system.ResultAnd;

public interface DataPipe {

    public static interface ConsumerHandle
    extends Handle {
        @Override
        public ConsumerHandle pass();

        public int discardData(int var1, ReadFlags var2);

        public ResultAnd<Integer> readData(ByteBuffer var1, ReadFlags var2);

        public ByteBuffer beginReadData(int var1, ReadFlags var2);

        public void endReadData(int var1);
    }

    public static interface ProducerHandle
    extends Handle {
        @Override
        public ProducerHandle pass();

        public ResultAnd<Integer> writeData(ByteBuffer var1, WriteFlags var2);

        public ByteBuffer beginWriteData(int var1, WriteFlags var2);

        public void endWriteData(int var1);
    }

    public static class ReadFlags
    extends Flags<ReadFlags> {
        private static final int FLAG_NONE = 0;
        private static final int FLAG_ALL_OR_NONE = 1;
        private static final int FLAG_QUERY = 4;
        private static final int FLAG_PEEK = 8;
        public static final ReadFlags NONE = (ReadFlags)ReadFlags.none().immutable();

        private ReadFlags(int flags) {
            super(flags);
        }

        public ReadFlags setAllOrNone(boolean allOrNone) {
            return (ReadFlags)this.setFlag(1, allOrNone);
        }

        public ReadFlags query(boolean query) {
            return (ReadFlags)this.setFlag(4, query);
        }

        public ReadFlags peek(boolean peek) {
            return (ReadFlags)this.setFlag(8, peek);
        }

        public static ReadFlags none() {
            return new ReadFlags(0);
        }
    }

    public static class WriteFlags
    extends Flags<WriteFlags> {
        private static final int FLAG_NONE = 0;
        private static final int FLAG_ALL_OR_NONE = 1;
        public static final WriteFlags NONE = (WriteFlags)WriteFlags.none().immutable();

        private WriteFlags(int flags) {
            super(flags);
        }

        public WriteFlags setAllOrNone(boolean allOrNone) {
            return (WriteFlags)this.setFlag(1, allOrNone);
        }

        public static WriteFlags none() {
            return new WriteFlags(0);
        }
    }

    public static class CreateOptions {
        private CreateFlags mFlags = CreateFlags.none();
        private int mElementNumBytes;
        private int mCapacityNumBytes;

        public CreateFlags getFlags() {
            return this.mFlags;
        }

        public int getElementNumBytes() {
            return this.mElementNumBytes;
        }

        public void setElementNumBytes(int elementNumBytes) {
            this.mElementNumBytes = elementNumBytes;
        }

        public int getCapacityNumBytes() {
            return this.mCapacityNumBytes;
        }

        public void setCapacityNumBytes(int capacityNumBytes) {
            this.mCapacityNumBytes = capacityNumBytes;
        }
    }

    public static class CreateFlags
    extends Flags<CreateFlags> {
        private static final int FLAG_NONE = 0;
        public static final CreateFlags NONE = (CreateFlags)CreateFlags.none().immutable();

        protected CreateFlags(int flags) {
            super(flags);
        }

        public static CreateFlags none() {
            return new CreateFlags(0);
        }
    }
}

