/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import SevenZip.Compression.LZMA.Decoder;
import android.content.Context;
import android.content.res.Resources;
import android.os.SystemClock;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xwalk.core.XWalkEnvironment;

class XWalkDecompressor {
    private static final String[] MANDATORY_LIBRARIES = new String[]{"libxwalkcore.so"};
    private static final String[] MANDATORY_RESOURCES = new String[]{"libxwalkcore.so", "classes.dex", "icudtl.dat", "xwalk.pak", "xwalk_100_percent.pak"};
    private static final String TAG = "XWalkLib";
    private static final int STREAM_BUFFER_SIZE = 4096;
    private static final int LZMA_PROP_SIZE = 5;
    private static final int LZMA_OUTSIZE = 8;

    XWalkDecompressor() {
    }

    public static boolean isLibraryCompressed() {
        for (String library : MANDATORY_LIBRARIES) {
            try {
                InputStream input = XWalkDecompressor.openRawResource(library);
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            catch (Resources.NotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean decompressLibrary() {
        String libDir = XWalkEnvironment.getPrivateDataDir();
        File f = new File(libDir);
        if (f.exists() && f.isFile()) {
            f.delete();
        }
        if (!f.exists() && !f.mkdirs()) {
            return false;
        }
        long start = SystemClock.uptimeMillis();
        for (String library : MANDATORY_LIBRARIES) {
            try {
                Log.d((String)TAG, (String)("Decompressing " + library));
                InputStream input = XWalkDecompressor.openRawResource(library);
                XWalkDecompressor.extractLzmaToFile(input, new File(libDir, library));
            }
            catch (Resources.NotFoundException e) {
                Log.d((String)TAG, (String)(library + " not found"));
                return false;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage());
                return false;
            }
        }
        Log.d((String)TAG, (String)("Time to decompress : " + (SystemClock.uptimeMillis() - start) + " ms"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isResourceCompressed(String libFile) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(libFile);
            for (String resource : MANDATORY_RESOURCES) {
                ZipEntry entry = zipFile.getEntry("assets" + File.separator + resource + ".lzma");
                if (entry != null) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractResource(String libFile, String destDir) {
        Log.d((String)TAG, (String)("Extract resource from Apk " + libFile));
        long start = SystemClock.uptimeMillis();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(libFile);
            String[] arr$ = MANDATORY_RESOURCES;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                if (i$ < len$) {
                    String resource = arr$[i$];
                    ZipEntry entry = null;
                    if (XWalkDecompressor.isNativeLibrary(resource)) {
                        String abi = XWalkEnvironment.getDeviceAbi();
                        String path = "lib" + File.separator + abi + File.separator + resource;
                        entry = zipFile.getEntry(path);
                        if (entry == null && XWalkEnvironment.is64bitDevice()) {
                            if (abi.equals("arm64-v8a")) {
                                abi = "armeabi-v7a";
                            } else if (abi.equals("x86_64")) {
                                abi = "x86";
                            }
                            path = "lib" + File.separator + abi + File.separator + resource;
                            entry = zipFile.getEntry(path);
                        }
                    } else if (XWalkDecompressor.isAsset(resource)) {
                        String path = "assets" + File.separator + resource;
                        entry = zipFile.getEntry(path);
                    } else {
                        entry = zipFile.getEntry(resource);
                    }
                    if (entry == null) {
                        Log.e((String)TAG, (String)(resource + " not found"));
                        boolean bl = false;
                        return bl;
                    }
                    Log.d((String)TAG, (String)("Extracting " + resource));
                    XWalkDecompressor.extractStreamToFile(zipFile.getInputStream(entry), new File(destDir, resource));
                    ++i$;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)e.getLocalizedMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
        Log.d((String)TAG, (String)("Time to extract : " + (SystemClock.uptimeMillis() - start) + " ms"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decompressResource(String libFile, String destDir) {
        Log.d((String)TAG, (String)("Decompress resource from Apk " + libFile));
        long start = SystemClock.uptimeMillis();
        ArrayList<DecompressResourceTask> taskList = new ArrayList<DecompressResourceTask>(MANDATORY_RESOURCES.length);
        ExecutorService pool = Executors.newFixedThreadPool(MANDATORY_RESOURCES.length);
        ZipFile zipFile = null;
        boolean success = true;
        try {
            zipFile = new ZipFile(libFile);
            for (String resource : MANDATORY_RESOURCES) {
                ZipEntry entry = zipFile.getEntry("assets" + File.separator + resource + ".lzma");
                if (entry == null) {
                    Log.e((String)TAG, (String)(resource + " not found"));
                    boolean bl = false;
                    return bl;
                }
                File destFile = new File(destDir, resource);
                taskList.add(new DecompressResourceTask(zipFile, entry, destFile));
            }
            try {
                List futureList = pool.invokeAll(taskList);
                for (Future f : futureList) {
                    success &= ((Boolean)f.get()).booleanValue();
                }
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException e) {
                boolean bl;
                try {
                    Log.d((String)TAG, (String)"Failed to execute decompression");
                    bl = false;
                    pool.shutdown();
                }
                catch (Throwable throwable) {
                    try {
                        pool.shutdown();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        Log.d((String)TAG, (String)e2.getLocalizedMessage());
                        bl = false;
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                try {
                    zipFile.close();
                }
                catch (IOException | NullPointerException exception) {
                    // empty catch block
                }
                return bl;
            }
            pool.shutdown();
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
        Log.d((String)TAG, (String)("Time to decompress : " + (SystemClock.uptimeMillis() - start) + " ms"));
        return success;
    }

    private static boolean isNativeLibrary(String resource) {
        return resource.endsWith(".so");
    }

    private static boolean isAsset(String resource) {
        return resource.endsWith(".dat") || resource.endsWith(".pak");
    }

    private static InputStream openRawResource(String library) throws Resources.NotFoundException {
        Context context = XWalkEnvironment.getApplicationContext();
        Resources res = context.getResources();
        String libraryName = library.split("\\.")[0];
        int id2 = res.getIdentifier(libraryName, "raw", context.getPackageName());
        return res.openRawResource(id2);
    }

    private static void extractLzmaToFile(InputStream srcStream, File destFile) throws IOException {
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            input = new BufferedInputStream(srcStream);
            output = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] properties = new byte[5];
            if (((InputStream)input).read(properties, 0, 5) != 5) {
                throw new IOException("Input lzma file is too short");
            }
            Decoder decoder = new Decoder();
            if (!decoder.SetDecoderProperties(properties)) {
                throw new IOException("Incorrect lzma properties");
            }
            long outSize = 0L;
            for (int i = 0; i < 8; ++i) {
                int v = ((InputStream)input).read();
                if (v < 0) {
                    Log.w((String)TAG, (String)"Can't read stream size");
                }
                outSize |= (long)v << 8 * i;
            }
            if (!decoder.Code(input, output, outSize)) {
                throw new IOException("Error in data stream");
            }
        }
        catch (IOException e) {
            if (destFile.isFile()) {
                destFile.delete();
            }
            throw e;
        }
        finally {
            try {
                output.flush();
            }
            catch (IOException | NullPointerException exception) {}
            try {
                output.close();
            }
            catch (IOException | NullPointerException exception) {}
            try {
                ((InputStream)input).close();
            }
            catch (IOException | NullPointerException exception) {}
        }
    }

    private static void extractStreamToFile(InputStream input, File file) throws IOException {
        OutputStream output = null;
        try {
            input.available();
            output = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = input.read(buffer)) >= 0) {
                output.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            if (file.isFile()) {
                file.delete();
            }
            throw e;
        }
        finally {
            try {
                output.flush();
            }
            catch (IOException | NullPointerException exception) {}
            try {
                output.close();
            }
            catch (IOException | NullPointerException exception) {}
            try {
                input.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
    }

    private static class DecompressResourceTask
    implements Callable<Boolean> {
        ZipFile mZipFile;
        ZipEntry mZipEntry;
        File mDestFile;

        DecompressResourceTask(ZipFile zipFile, ZipEntry zipEntry, File destFile) {
            this.mZipFile = zipFile;
            this.mZipEntry = zipEntry;
            this.mDestFile = destFile;
        }

        @Override
        public Boolean call() {
            try {
                Log.d((String)XWalkDecompressor.TAG, (String)("Decompressing " + this.mZipEntry.getName()));
                XWalkDecompressor.extractLzmaToFile(this.mZipFile.getInputStream(this.mZipEntry), this.mDestFile);
            }
            catch (IOException e) {
                Log.e((String)XWalkDecompressor.TAG, (String)e.getLocalizedMessage());
                return false;
            }
            return true;
        }
    }
}

