/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.xwalk.core.extension.ReflectionHelper;

public class JsStubGenerator {
    public static String TAG = "JsStubGenerator";
    public static final String MSG_TO_OBJECT = "postMessageToObject";
    public static final String MSG_TO_CLASS = "postMessageToClass";
    public static final String MSG_TO_EXTENSION = "postMessageToExtension";
    ReflectionHelper reflection;
    String jsHeader = "var v8tools = requireNative(\"v8tools\");\nvar jsStubModule = requireNative(\"jsStub\");\njsStubModule.init(extension, v8tools);\nvar jsStub = jsStubModule.jsStub;\nvar helper = jsStub.createRootStub(exports);\n";

    JsStubGenerator(ReflectionHelper extReflection) {
        this.reflection = extReflection;
    }

    String generate() {
        String result = "";
        ReflectionHelper.MemberInfo entry = this.reflection.getEntryPoint();
        if (entry != null) {
            result = this.generateEntryPoint(entry);
        }
        String string2 = result = result.length() > 0 ? result : this.jsHeader;
        if (this.reflection.getEventList() != null) {
            result = result + this.generateEventTarget(this.reflection);
        }
        Map<String, ReflectionHelper.MemberInfo> members = this.reflection.getMembers();
        for (String key : members.keySet()) {
            ReflectionHelper.MemberInfo m = members.get(key);
            if (m.isEntryPoint) continue;
            switch (m.type) {
                case JS_PROPERTY: {
                    result = result + this.generateProperty(MSG_TO_EXTENSION, m);
                    break;
                }
                case JS_METHOD: {
                    result = result + this.generateMethod(MSG_TO_EXTENSION, m, true);
                    break;
                }
                case JS_CONSTRUCTOR: {
                    result = result + this.generateConstructor(m, true);
                    break;
                }
            }
        }
        return result + "\n";
    }

    String generateEntryPoint(ReflectionHelper.MemberInfo entry) {
        if (entry.type == ReflectionHelper.MemberType.JS_PROPERTY) {
            Class<?> type2 = ((Field)entry.accesser).getType();
            String funcName = type2.getSimpleName();
            return this.jsHeader + String.format("%s(exports, helper);\n", this.getPrototypeName(funcName));
        }
        if (entry.type == ReflectionHelper.MemberType.JS_METHOD) {
            return String.format("exports = %s;\n %s\n %s", this.getInternalName(entry.jsName), this.jsHeader, this.generateMethod(MSG_TO_EXTENSION, entry, false));
        }
        if (entry.type == ReflectionHelper.MemberType.JS_CONSTRUCTOR) {
            return String.format("exports = %s;\n %s\n %s", entry.jsName, this.jsHeader, this.generateConstructor(entry, false));
        }
        return "";
    }

    String[] classGenerator(ReflectionHelper targetReflect) {
        String result = "";
        String staticResult = "";
        if (targetReflect.getEventList() != null) {
            String eventStr = this.generateEventTarget(targetReflect);
            result = result + eventStr;
            staticResult = staticResult + eventStr;
        }
        Map<String, ReflectionHelper.MemberInfo> members = targetReflect.getMembers();
        for (String key : members.keySet()) {
            String memberStr;
            ReflectionHelper.MemberInfo m = members.get(key);
            String msgType = m.isStatic ? MSG_TO_CLASS : MSG_TO_OBJECT;
            switch (m.type) {
                case JS_PROPERTY: {
                    memberStr = this.generateProperty(msgType, m);
                    break;
                }
                case JS_METHOD: {
                    memberStr = this.generateMethod(msgType, m, true);
                    break;
                }
                default: {
                    memberStr = "";
                }
            }
            if (m.isStatic) {
                staticResult = staticResult + memberStr;
                continue;
            }
            result = result + memberStr;
        }
        return new String[]{result, staticResult};
    }

    String destroyBindingObject(ReflectionHelper targetReflect) {
        String result = "exports.destroy = function() {\n";
        Map<String, ReflectionHelper.MemberInfo> members = targetReflect.getMembers();
        for (String key : members.keySet()) {
            result = result + "delete exports[\"" + key + "\"];\n";
        }
        result = result + "helper.destroy();\n";
        result = result + "delete exports[\"__stubHelper\"];\n";
        result = result + "delete exports[\"destroy\"];\n";
        result = result + "};";
        return result;
    }

    String generateEventTarget(ReflectionHelper targetReflect) {
        String[] eventList = targetReflect.getEventList();
        if (eventList == null || eventList.length == 0) {
            return "";
        }
        String gen = "jsStub.makeEventTarget(exports);\n";
        for (String e : eventList) {
            gen = gen + "helper.addEvent(\"" + e + "\");\n";
        }
        return gen;
    }

    String generateProperty(String msgType, ReflectionHelper.MemberInfo m) {
        String name = m.jsName;
        return String.format("jsStub.defineProperty(\"%s\", exports, \"%s\", %b);\n", msgType, name, m.isWritable);
    }

    String generatePromiseMethod(String msgType, ReflectionHelper.MemberInfo mInfo) {
        String name = mInfo.jsName;
        String wrapArgs = mInfo.wrapArgs.length() > 0 ? mInfo.wrapArgs : "null";
        String wrapReturns = mInfo.wrapReturns.length() > 0 ? mInfo.wrapReturns : "null";
        return String.format("jsStub.addMethodWithPromise(\"%s\", exports, \"%s\", %s, %s);\n", msgType, name, wrapArgs, wrapReturns);
    }

    String getArgString(Method m, boolean withPromise) {
        if (m == null) {
            return "";
        }
        Class<?>[] pTypes = m.getParameterTypes();
        Annotation[][] anns = m.getParameterAnnotations();
        String jsArgs = "";
        int length = withPromise ? pTypes.length - 1 : pTypes.length;
        for (int i = 0; i < length; ++i) {
            Class<?> p = pTypes[i];
            String pStr = "arg" + i + "_" + p.getSimpleName();
            if (jsArgs.length() > 0) {
                jsArgs = jsArgs + ", ";
            }
            jsArgs = jsArgs + pStr;
        }
        return jsArgs;
    }

    String generateMethod(String msgType, ReflectionHelper.MemberInfo mInfo, boolean isMember) {
        if (mInfo.withPromise) {
            return this.generatePromiseMethod(msgType, mInfo);
        }
        String name = mInfo.jsName;
        Method m = (Method)mInfo.accesser;
        String iName = this.getInternalName(name);
        Annotation[][] anns = m.getParameterAnnotations();
        String jsArgs = this.getArgString(m, mInfo.withPromise);
        boolean isSync = !m.getReturnType().equals(Void.TYPE);
        String funcBody = String.format("function %s(%s) {\n" + (isSync ? "  return " : "  ") + "helper.invokeNative(\"%s\", \"%s\", [%s], %b);\n" + "};\n", iName, jsArgs, msgType, name, jsArgs, isSync);
        String memberStr = isMember ? String.format("exports[\"%s\"] = %s;\n", name, iName) : "";
        return funcBody + memberStr;
    }

    String getInternalName(String name) {
        return "__" + name;
    }

    String getPrototypeName(String funcName) {
        return "__" + funcName + "_prototype";
    }

    String generateConstructor(ReflectionHelper.MemberInfo mInfo, boolean isMember) {
        String name = mInfo.jsName;
        String protoFunc = this.getPrototypeName(name);
        String argStr = this.getArgString((Method)mInfo.accesser, false);
        ReflectionHelper targetReflect = this.reflection.getConstructorReflection(name);
        String[] classStr = this.classGenerator(targetReflect);
        String protoStr = String.format("function %s(exports, helper){\n%s\n%s\n}\n", protoFunc, classStr[0], this.destroyBindingObject(targetReflect));
        String self = String.format("function %s(%s) {\nvar newObject = this;\nvar objectId =\nNumber(helper.invokeNative(\"%s\", \"+%s\", [%s], true));\nif (!objectId) throw \"Error to create instance for constructor:%s.\";\nvar objectHelper = jsStub.getHelper(newObject, helper);\nobjectHelper.objectId = objectId;\nobjectHelper.constructorJsName = \"%s\";\nobjectHelper.registerLifecycleTracker();%s(newObject, objectHelper);\nhelper.addBindingObject(objectId, newObject);}\nhelper.constructors[\"%s\"] = %s;\n", name, argStr, MSG_TO_EXTENSION, name, argStr, name, name, protoFunc, name, name);
        String staticStr = String.format("(function(exports, helper){\n  helper.constructorJsName = \"%s\";\n%s\n})(%s, jsStub.getHelper(%s, helper));\n", name, classStr[1], name, name);
        String memberStr = isMember ? String.format("exports[\"%s\"] = %s;\n", name, name) : "";
        return protoStr + self + staticStr + memberStr;
    }
}

