/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Map;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.xwalk.core.internal.XWalkAPI;

@JNINamespace(value="xwalk")
@XWalkAPI(createInternally=true)
public class XWalkWebResourceResponseInternal {
    private String mMimeType;
    private String mEncoding;
    private InputStream mData;
    private int mStatusCode;
    private String mReasonPhrase;
    private Map<String, String> mResponseHeaders;
    private String[] mResponseHeaderNames;
    private String[] mResponseHeaderValues;

    XWalkWebResourceResponseInternal() {
        this.mMimeType = null;
        this.mEncoding = null;
        this.mData = null;
    }

    XWalkWebResourceResponseInternal(String mimeType, String encoding, InputStream data) {
        this.mMimeType = mimeType;
        this.mEncoding = encoding;
        this.setData(data);
    }

    XWalkWebResourceResponseInternal(String mimeType, String encoding, InputStream data, int statusCode, String reasonPhrase, Map<String, String> responseHeaders) {
        this(mimeType, encoding, data);
        this.mStatusCode = statusCode;
        this.mReasonPhrase = reasonPhrase;
        this.mResponseHeaders = responseHeaders;
    }

    private void fillInResponseHeaderNamesAndValuesIfNeeded() {
        if (this.mResponseHeaders == null || this.mResponseHeaderNames != null) {
            return;
        }
        this.mResponseHeaderNames = new String[this.mResponseHeaders.size()];
        this.mResponseHeaderValues = new String[this.mResponseHeaders.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : this.mResponseHeaders.entrySet()) {
            this.mResponseHeaderNames[i] = entry.getKey();
            this.mResponseHeaderValues[i] = entry.getValue();
            ++i;
        }
    }

    @XWalkAPI
    public void setMimeType(String mimeType) {
        this.mMimeType = mimeType;
    }

    @XWalkAPI
    public String getMimeType() {
        return this.mMimeType;
    }

    @CalledByNative
    public String getMimeTypeNative() {
        return this.mMimeType;
    }

    @XWalkAPI
    public void setEncoding(String encoding) {
        this.mEncoding = encoding;
    }

    @XWalkAPI
    public String getEncoding() {
        return this.mEncoding;
    }

    @CalledByNative
    public String getEncodingNative() {
        return this.mEncoding;
    }

    @XWalkAPI
    public void setData(InputStream data) {
        if (data != null && StringBufferInputStream.class.isAssignableFrom(data.getClass())) {
            throw new IllegalArgumentException("StringBufferInputStream is deprecated and must not be passed to a XWalkWebResourceResponse");
        }
        this.mData = data;
    }

    @XWalkAPI
    public InputStream getData() {
        return this.mData;
    }

    @CalledByNative
    public InputStream getDataNative() {
        return this.mData;
    }

    @XWalkAPI
    public void setStatusCodeAndReasonPhrase(int statusCode, String reasonPhrase) {
        if (statusCode < 100) {
            throw new IllegalArgumentException("statusCode can't be less than 100.");
        }
        if (statusCode > 599) {
            throw new IllegalArgumentException("statusCode can't be greater than 599.");
        }
        if (statusCode > 299 && statusCode < 400) {
            throw new IllegalArgumentException("statusCode can't be in the [300, 399] range.");
        }
        if (reasonPhrase == null) {
            throw new IllegalArgumentException("reasonPhrase can't be null.");
        }
        if (reasonPhrase.trim().isEmpty()) {
            throw new IllegalArgumentException("reasonPhrase can't be empty.");
        }
        for (int i = 0; i < reasonPhrase.length(); ++i) {
            char c = reasonPhrase.charAt(i);
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("reasonPhrase can't contain non-ASCII characters.");
        }
        this.mStatusCode = statusCode;
        this.mReasonPhrase = reasonPhrase;
    }

    @XWalkAPI
    public int getStatusCode() {
        return this.mStatusCode;
    }

    @CalledByNative
    public int getStatusCodeNative() {
        return this.mStatusCode;
    }

    @XWalkAPI
    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    @CalledByNative
    public String getReasonPhraseNative() {
        return this.mReasonPhrase;
    }

    @XWalkAPI
    public void setResponseHeaders(Map<String, String> headers) {
        this.mResponseHeaders = headers;
    }

    @XWalkAPI
    public Map<String, String> getResponseHeaders() {
        return this.mResponseHeaders;
    }

    @CalledByNative
    private String[] getResponseHeaderNames() {
        this.fillInResponseHeaderNamesAndValuesIfNeeded();
        return this.mResponseHeaderNames;
    }

    @CalledByNative
    private String[] getResponseHeaderValues() {
        this.fillInResponseHeaderNamesAndValuesIfNeeded();
        return this.mResponseHeaderValues;
    }
}

