package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;

import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.abook.abv.bl.dto.GroupDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;

public class CreatedRoomJSON extends AcmsCommonJSON {

    public ArrayList<ShopMemberDto> attendUsers;
    public ChatRoomDto chatRoomDto;

    public CreatedRoomJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) throws JSONValidationException {

        // ルーム一覧情報を取得
        if (!json.has(ABookCommConstants.KEY.BODY)) { return; }

        JSONObject createdRoomJson = json.getJSONObject(ABookCommConstants.KEY.BODY).getJSONObject(ABookCommConstants.KEY.CHAT_ROOM_INFO);
        if (createdRoomJson == null) { return; }

        JSONArray groupListJsonArray = createdRoomJson.getJSONArray(ABookCommConstants.KEY.ATTEND_USERS);

        chatRoomDto = new ChatRoomDto();
        chatRoomDto.userCount = groupListJsonArray.length();
        chatRoomDto.chatRoomId = createdRoomJson.getInt(ABookCommConstants.KEY.ROOM_ID);
        chatRoomDto.chatRoomName = createdRoomJson.getString(ABookCommConstants.KEY.ROOM_NAME);
        chatRoomDto.type = createdRoomJson.getInt(ABookCommConstants.KEY.ROOM_TYPE);

    }
}

