package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.dto.TaskDto;
import jp.agentec.abook.abv.bl.dto.TaskReportDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

/**
 * Created by leej on 2018/09/10.
 */

public class OperationDataJSON extends AcmsCommonJSON {
    public static final String OperationLastEditDate = "operationLastEditDate";
    public static final String TaskList = "taskList";
    public static final String OperationId = "operationId";
    public static final String TaskId = "taskId";
    public static final String TaskKey = "taskKey";
    public static final String TaskCode = "taskCode";
    public static final String TaskStatus = "taskStatus";
    public static final String TaskHotspotInfo = "taskHotspotInfo";
    public static final String Task = "task";
    public static final String ProcessKey = "processKey";
    public static final String PhaseNo = "phaseNo";
    public static final String TaskName = "taskName";

    // 1.0.1で追加
    public static final String TaskReportId = "taskReportId";           // 作業報告書ID      ※定期点検のみ
    public static final String TaskReportList = "taskReportList";       // 作業報告詳細リスト
    public static final String TaskReportLevel = "taskReportLevel";     // 作業報告階層
    public static final String EnableReport = "enableReport";            // 報告可能区分
    public static final String TaskReportInfoId = "taskReportInfoId";   // 作業報告書情報ID　※定期点検のみ
    public static final String ReportStartDate = "reportStartDate";     // 点検開始日時　　　※定期点検のみ
    public static final String ReportEndDate = "reportEndDate";         // 点検終了日時　　　※定期点検のみ
    public static final String TaskReportKey = "taskReportKey";         // 作業報告キー
    public static final String TaskReportInfo = "taskReportInfo";       // 作業報告データ

    public List<TaskDto> taskDtoList;
    public Date lastEditDate;

    public OperationDataJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) {
        lastEditDate = DateTimeUtil.toDate(json.getString(OperationLastEditDate), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
        taskDtoList = new ArrayList<TaskDto>();
        if (json.has(TaskList)) {
            JSONArray taskList = json.getJSONArray(TaskList);
            for (int i = 0; i < taskList.length(); i++) {
                JSONObject taskJson = taskList.getJSONObject(i);
                TaskDto dto = new TaskDto();

                dto.operationId = taskJson.getLong(OperationId);
                dto.taskId = taskJson.getLong(TaskId);
                dto.taskKey = taskJson.getString(TaskKey);
                if (taskJson.has(TaskCode)) {
                    dto.taskCode = taskJson.getString(TaskCode);
                }
                if (taskJson.has(TaskStatus)) {
                    dto.taskStatus = taskJson.getInt(TaskStatus);
                }
                dto.taskHotSpotInfo = taskJson.getJSONObject(TaskHotspotInfo).toString();

                if (taskJson.has(TaskStatus)) {
                    dto.taskStatus = taskJson.getInt(TaskStatus);
                }
                if (taskJson.has(ProcessKey)) {
                    dto.processKey = taskJson.getString(ProcessKey);
                }

                if (taskJson.has(PhaseNo)) {
                    dto.phaseNo = taskJson.getInt(PhaseNo);
                }

                if (taskJson.has(TaskName)) {
                    dto.taskName = taskJson.getString(TaskName);
                }

                // 作業報告詳細リスト
                JSONArray taskReportList = taskJson.getJSONArray(TaskReportList);
                dto.taskReportDtoList = new ArrayList<TaskReportDto>();
                for (int j = 0; j < taskReportList.length(); j++) {

                    TaskReportDto taskReportDto = new TaskReportDto();
                    JSONObject taskReportJson = taskReportList.getJSONObject(j);
                    taskReportDto.taskKey = dto.taskKey;
                    taskReportDto.taskReportLevel = taskReportJson.getInt(TaskReportLevel);

                    // 報告可能区分
                    if (taskReportJson.has(EnableReport)) {
                        taskReportDto.enableReport = taskReportJson.getInt(EnableReport);
                    }

                    if (taskJson.has(TaskReportId)) {
                        // taskListの中にtaskReportIdキーが存在
                        taskReportDto.taskReportId = taskJson.getInt(TaskReportId);
                    }

                    if (taskReportJson.has(TaskReportInfoId)) {
                        // 定期点検の場合
                        taskReportDto.taskReportInfoId = taskReportJson.getInt(TaskReportInfoId);
                    }
                    if (taskReportJson.has(ReportStartDate)) {
                        taskReportDto.reportStartDate = DateTimeUtil.toDate(taskReportJson.getString(ReportStartDate), DateTimeFormat.yyyyMMddHHmmss_hyphen);
                    }
                    if (taskReportJson.has(ReportEndDate)) {
                        taskReportDto.reportEndDate = DateTimeUtil.toDate(taskReportJson.getString(ReportEndDate), DateTimeFormat.yyyyMMddHHmmss_hyphen);
                    }

                    if (taskReportJson.has(TaskReportKey)) {
                        taskReportDto.attachedFileName = taskReportJson.getString(TaskReportKey);
                    }

                    if (taskReportJson.has(TaskReportInfo)) {
                        Object object = taskReportJson.get(TaskReportInfo);
                        if (object instanceof String) {
                            taskReportDto.jsonData = (String)object;
                        } else if (object instanceof JSONObject) {
                            taskReportDto.jsonData = object.toString();
                        } else {
                            taskReportDto.jsonData = "";
                        }
                    } else {
                        taskReportDto.jsonData = "";
                    }
                    dto.taskReportDtoList.add(taskReportDto);
                }
                taskDtoList.add(dto);
            }
        }
    }

}
