package jp.agentec.abook.abv.bl.acms.client.json;

import org.json.adf.JSONArray;
import org.json.adf.JSONObject;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.dto.OperationContentDto;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.dto.OperationGroupMasterRelationDto;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.abook.abv.bl.dto.TaskWorkerGroupDto;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

/**
 * Created by leej on 2018/08/17.
 */

public class OperationListJSON extends AcmsCommonJSON {

    public static final String OperationList = "operationList";
    public static final String OperationId = "operationId";
    public static final String OperationType = "operationType";
    public static final String ReportType = "reportType";
    public static final String OperationName = "operationName";
    public static final String OperationDescriptions = "operationDescriptions";
    public static final String OperationStartDate = "operationStartDate";
    public static final String OperationEndDate = "operationEndDate";
    public static final String OperationLastEditDate = "operationLastEditDate";
    public static final String ContentId = "contentId";
    //定期点検用
    public static final String ReportCycle = "reportCycle";
    public static final String EnableReportUpdate = "enableReportUpdate";

    public static final String EnableReportHistory = "enableReportHistory";

    // 作業編集可能区分
    public static final String EnableReportEdit = "enableReportEdit";

    // 作業担当グループリスト
    public static final String WorkingGroupList = "workingGroupList";
    public static final String ReportLevel = "reportLevel"; // 報告階層
    public static final String GroupId = "groupId"; // グループID
    public static final String GroupList = "groupList"; // グループリスト

    public static final String RelatedContentList = "relatedContentList";
    public static final String PushMessageList = "pushMessageList";

    public static final String PushMessageId = "pushMessageId";
    public static final String PushSendLoginId = "pushSendLoginId";
    public static final String PushSendDate = "pushSendDate";

    public static final String PushMessage = "pushMessage";

    public static final String EnableAddReport = "enableAddReport";


    public static final String OperationGroupMasterIdList = "operationGroupMasterIdList";

    public static final String QuickReport = "quickReport";

    public List<OperationDto> operationList;

    public OperationListJSON(String jsonString) throws AcmsException {
        super(jsonString);
    }

    @Override
    protected void parse(JSONObject json) {
        operationList = new ArrayList<OperationDto>();
        if (json.has(OperationList)) {
            JSONArray operations = json.getJSONArray(OperationList);

            for (int i = 0; i < operations.length(); i++) {
                JSONObject operationJson = operations.getJSONObject(i);
                OperationDto dto = new OperationDto();
                dto.operationContentDtoList = new ArrayList<OperationContentDto>();
                dto.taskWorkerGroupDtoList = new ArrayList<TaskWorkerGroupDto>();
                dto.operationGroupMasterRelationDtoList = new ArrayList<OperationGroupMasterRelationDto>();

                dto.operationId = operationJson.getLong(OperationId);
                dto.operationType = operationJson.getInt(OperationType);
                dto.operationName = operationJson.getString(OperationName);
                dto.operationDescriptions = operationJson.getString(OperationDescriptions);
                dto.operationStartDate = DateTimeUtil.toDate(operationJson.getString(OperationStartDate), "UTC", DateTimeFormat.yyyyMMdd_hyphen);
                dto.operationEndDate = DateTimeUtil.toDate(operationJson.getString(OperationEndDate), "UTC", DateTimeFormat.yyyyMMdd_hyphen);
                dto.reportType = operationJson.getInt(ReportType);      //　作業報告タイプ
                dto.enableReportHistory = operationJson.getInt(EnableReportHistory);        // 報告履歴管理
                dto.enableReportEdit = operationJson.has(EnableReportEdit) ? operationJson.getInt(EnableReportEdit) : 0;          // 作業編集区分
                dto.enableAddReport = operationJson.has(EnableAddReport) ? operationJson.getInt(EnableAddReport) : 0;          // 作業追加区分
                dto.quickReport = operationJson.has(QuickReport) ? operationJson.getInt(QuickReport) : 0;

                // 作業終了更新日
                if (operationJson.has(OperationLastEditDate)) {
                    dto.lastEditDate = DateTimeUtil.toDate(operationJson.getString(OperationLastEditDate), "UTC", DateTimeFormat.yyyyMMddHHmmss_hyphen);
                }

                if (operationJson.has(ReportCycle)) {
                    dto.reportCycle = operationJson.getInt(ReportCycle);
                }

                if (operationJson.has(EnableReportUpdate)) {
                    dto.enableReportUpdate = operationJson.getInt(EnableReportUpdate);
                }

                if (operationJson.has(ContentId)) {
                    // プロジェクト用資料の登録
                    OperationContentDto operationContentDto = new OperationContentDto();
                    operationContentDto.operationId = dto.operationId;
                    operationContentDto.contentId = operationJson.getLong(ContentId);
                    operationContentDto.operationContentFlg = true;
                    dto.operationContentDtoList.add(operationContentDto);
                }

                JSONArray relatedContentJsonArray = operationJson.getJSONArray(RelatedContentList);
                if (relatedContentJsonArray != null) {
                    for (int k = 0; k < relatedContentJsonArray.length(); k++) {
                        // 関連資料の登録
                        OperationContentDto operationContentDto = new OperationContentDto();
                        operationContentDto.operationId = dto.operationId;
                        operationContentDto.contentId = relatedContentJsonArray.getJSONObject(k).getInt(ContentId);
                        operationContentDto.operationContentFlg = false;
                        dto.operationContentDtoList.add(operationContentDto);
                    }
                }
                JSONArray pushMessagetJsonArray = operationJson.getJSONArray(PushMessageList);
                if (pushMessagetJsonArray != null ) {
                    dto.pushMessageList = new ArrayList<PushMessageDto>();
                    for (int k = 0; k < pushMessagetJsonArray.length(); k++) {
                        if (pushMessagetJsonArray.getJSONObject(k).length() == 0) {
                            break;
                        }
                        PushMessageDto pushMessageDto = new PushMessageDto();
                        pushMessageDto.pushMessageId = pushMessagetJsonArray.getJSONObject(k).getLong(PushMessageId);
                        pushMessageDto.operationId = dto.operationId;
                        pushMessageDto.pushSendLoginId = pushMessagetJsonArray.getJSONObject(k).getString(PushSendLoginId);
                        pushMessageDto.pushSendDate = DateTimeUtil.toDate(pushMessagetJsonArray.getJSONObject(k).getString(PushSendDate), DateTimeFormat.yyyyMMddHHmmss_hyphen);
                        pushMessageDto.pushMessage = pushMessagetJsonArray.getJSONObject(k).getString(PushMessage);
                        pushMessageDto.readingFlg = false;
                        dto.pushMessageList.add(pushMessageDto);
                    }
                }

                if (operationJson.has(WorkingGroupList)) {
                    JSONArray workingGroupJsonArray = operationJson.getJSONArray(WorkingGroupList);
                    for (int k = 0; k < workingGroupJsonArray.length(); k++) {
                        if (workingGroupJsonArray.getJSONObject(k).length() == 0) {
                            // リストの情報が空の場合、以下の処理を行わないようにする
                            break;
                        }
                        // 作業担当グループリストセット
                        TaskWorkerGroupDto taskWorkerGroupDto = new TaskWorkerGroupDto();
                        taskWorkerGroupDto.taskReportLevel = workingGroupJsonArray.getJSONObject(k).getInt(ReportLevel);
                        taskWorkerGroupDto.groupList = new ArrayList<Integer>();
                        JSONArray workingGroupListArray = workingGroupJsonArray.getJSONObject(k).getJSONArray(GroupList);
                        for (int j = 0; j < workingGroupListArray.length(); j++) {
                            taskWorkerGroupDto.groupList.add(workingGroupListArray.getJSONObject(j).getInt(GroupId));
                        }
                        dto.taskWorkerGroupDtoList.add(taskWorkerGroupDto);
                    }
                }

                // 作業種別IDリストをセット
                if (operationJson.has(OperationGroupMasterIdList)) {
                    // 作業種別に紐づく作業種別ID、作業IDセット
                    JSONArray operationGroupMasterIdJsonArray = operationJson.getJSONArray(OperationGroupMasterIdList);
                    for (int j = 0; j < operationGroupMasterIdJsonArray.length(); j++) {
                        OperationGroupMasterRelationDto operationGroupMasterRelationDto = new OperationGroupMasterRelationDto();
                        operationGroupMasterRelationDto.operationId = dto.operationId;
                        operationGroupMasterRelationDto.operationGroupMasterId = operationGroupMasterIdJsonArray.getInt(j);
                        dto.operationGroupMasterRelationDtoList.add(operationGroupMasterRelationDto);
                    }
                }
                operationList.add(dto);
            }
        }
    }
}