package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.adf.util.StringUtil;


public class TContent extends SQLiteTableScript {
	
	public TContent() {
	}
	
	@Override
	public List<String> getCreateScript(int version) {
		List<String> ddl = new ArrayList<String>();
		StringBuffer sql = new StringBuffer();
		
		//	since 1.0.0
		//	1.5.0 -> content_groups 追加
		sql.append(" CREATE TABLE t_content ( ");
		sql.append("        content_id BIGINT NOT NULL ");
		sql.append("      , content_name VARCHAR(256) NOT NULL ");
		sql.append("      , content_name_kana VARCHAR(256) ");
		sql.append("      , content_detail TEXT ");
		sql.append("      , orientation INTEGER ");	//	since 1.5.2
		sql.append("      , all_page_num INTEGER ");
		sql.append("      , detail_page_num INTEGER ");	//	since 1.5.0
		sql.append("      , updated_flg BOOLEAN ");
		sql.append("      , downloaded_flg BOOLEAN ");
		sql.append("      , downloading_flg BOOLEAN ");
		sql.append("      , meta_version INTEGER ");
		sql.append("      , resource_version INTEGER ");
		sql.append("      , delivery_start_date DATETIME ");
		sql.append("      , delivery_end_date DATETIME ");
		sql.append("      , favorite_flg BOOLEAN ");
		sql.append("      , content_protected_flg BOOLEAN ");
		sql.append("      , thumbnail_normal_path TEXT ");
		sql.append("      , thumbnail_big_path TEXT ");
		sql.append("      , page_path TEXT ");
		sql.append("      , resource_path TEXT ");
		sql.append("      , content_groups TEXT ");	//	since 1.5.0
		sql.append("      , new_flg BOOLEAN ");	//	since 1.5.0
		sql.append("      , contract_content_id INTEGER ");	//	since ABook+
		sql.append("      , reading_date DATETIME ");	//	since ABook+
		sql.append("      , last_viewed_page INTEGER ");	//	since ABook+
		sql.append("      , content_size INTEGER ");	//	since ABook+ (KByte)
		sql.append("      , reading_count INTEGER ");	//	since ABook+
		sql.append("      , content_type TEXT ");	//	since ABook+
		sql.append("      , last_delivery_date DATETIME ");	//	since ABook+
		sql.append("      , content_alert_level INTEGER ");	//	since ABook+
		sql.append("      , content_alert_message TEXT ");	//	since ABook+
		sql.append("      , disable_auto_dl BOOLEAN default 0 ");	//	since ABook+1.4
		sql.append("      , product_id TEXT ");	//	since ABook+1.5
		sql.append("      , price TEXT ");	//	since ABook+1.5
		sql.append("      , purchase_state INTEGER default -1 ");	//	since ABook+1.5
		sql.append("      , purchase_token TEXT ");	//	since ABook+1.5
		sql.append("      , delivery_type INTEGER default 0 ");	//	since ABook+1.5.2
		sql.append("      , disable_swipe BOOLEAN default 0 ");	//	since ABook+1.6.0

		sql.append("      , download_start_date DATETIME ");	//	since ABook+1.6.3 (from t_content_download_queue)
		sql.append("      , download_progress INTEGER ");	//	since ABook+1.6.3 (from t_content_download_queue)
		sql.append("      , downloaded_bytes BIGINT ");	//	since ABook+1.6.3 (from t_content_download_queue)
		sql.append("      , download_end_date DATETIME ");	//	since ABook+1.6.3 (from t_content_download_queue)
		sql.append("      , log_sended_flg BOOLEAN default 0");	//	since ABook+1.6.3 (from t_content_download_queue)
		sql.append("      , status VARCHAR(2) ");	//	since ABook+1.6.3 (from t_content_download_queue)
		sql.append("      , unauthorized_content_flg BOOLEAN default 0"); //since ABook See 1.7.2
		sql.append("      , operation_content_flg BOOLEAN default 0"); //since ABook Check 1.9.3
		sql.append("      , common_content_flg BOOLEAN default 0"); //since ABook Check 1.9.4
		sql.append("      , PRIMARY KEY (content_id) ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);

		sql.append(" CREATE INDEX idx_content_1 ON t_content ( ");
		sql.append("        content_name ");
		sql.append(" ) ");
		
		ddl.add(sql.toString());
		StringUtil.clear(sql);

		addIndex(ddl);

		return ddl;
	}

	private void addIndex(List<String> ddl) {
		ddl.add(" CREATE INDEX idx_content_delivery_start_date ON t_content (delivery_start_date) ");
		ddl.add(" CREATE INDEX idx_content_reading_date ON t_content (reading_date) ");
		ddl.add(" CREATE INDEX idx_content_reading_count ON t_content (reading_count) ");
		ddl.add(" CREATE INDEX idx_content_content_size ON t_content (content_size) ");
		ddl.add(" CREATE INDEX idx_content_log_sended_flg ON t_content (log_sended_flg) ");
	}

	@Override
	public List<String> getUpgradeScript(int oldVersion, int newVersion) {
		return null;
	}

	@Override
	public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
		return null;
	}
}
