package jp.agentec.abook.abv.ui.common.activity;

import android.content.DialogInterface;
import android.os.Bundle;

import java.util.Date;
import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.bl.logic.PushMessageLogic;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.PushMessageKey;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.activity.OperationListActivity;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.StringUtil;

public class ShowPushMessageDailogActivity extends ABVUIActivity {
    private static final String TAG = "ShowPushMessageDailogActivity";

    OperationLogic mOperationLogic = AbstractLogic.getLogic(OperationLogic.class);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String data = getIntent().getExtras() != null ? getIntent().getExtras().getString(PushMessageKey.data) : null;
        if (StringUtil.isNullOrEmpty(data)) {
            final long operationId = StringUtil.isNullOrEmpty(getIntent().getExtras().getString(PushMessageKey.operationId)) ? 0 : Long.parseLong(getIntent().getExtras().getString(PushMessageKey.operationId));

            if (operationId > 0) {
                Logger.d(TAG, "operationId : " + operationId);
                final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ShowPushMessageDailogActivity.this, getRString(R.string.app_name), getIntent().getExtras().getString(PushMessageKey.message));

                // リソースパターンの適用
                alertDialog.setPositiveButton(PatternStringUtil.patternToInt(getApplicationContext(),
                                                R.string.work_report,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                        new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        if (contentRefresher.isRefreshing()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                                R.string.msg_routineTask_report_disable_refreshing,
                                                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else if(ActivityHandlingHelper.getInstance().isMeetingConnected()) {
                            // リソースパターンの適用
                            ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                                                                                R.string.msg_routineTask_report_disable_meeting_room,
                                                                                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                        } else {
                            OperationListActivity operationListActivity = ActivityHandlingHelper.getInstance().getPreviousOperationListActivity();
                            if (operationListActivity != null && operationListActivity.isShowingBatchSync()) {
                                Logger.d(TAG, "is showing Batch Sync");
                                // 一括同期中は移動しない
                                ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, getString(R.string.msg_batch_sync_move_operation_view));
                            } else {
                                OperationDto operationDto = mOperationLogic.getOperation(operationId);
                                if (operationDto == null) {
                                    Logger.d(TAG, "operationDto is null");
                                    // リソースパターンの適用
                                    ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                            R.string.msg_routineTask_report_disable_no_operation,
                                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                } else if (operationDto.needSyncFlg) {
                                    Logger.d(TAG, "needSyncFlg is true");
                                    // リソースパターンの適用
                                    ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                            R.string.msg_routineTask_report_disable_not_updated,
                                            getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                } else {
                                    if (operationListActivity != null) {
                                        Logger.d(TAG, "startTaskDirectionOrReportView");
                                        operationListActivity.startTaskDirectionOrReportView(operationDto);
                                    } else {
                                        Logger.d(TAG, "operationListActivity is null");
                                        // リソースパターンの適用
                                        ErrorMessage.showErrorMessageToast(ShowPushMessageDailogActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
                                                R.string.msg_routineTask_report_disable_not_list,
                                                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
                                    }
                                }
                            }
                        }
                        dialog.dismiss();
                    }
                });

                alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int whichButton) {
                        dialog.dismiss();
                    }
                });

                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        finish();
                    }
                });

                alertDialog.show();
            } else {
                final ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ShowPushMessageDailogActivity.this, getRString(R.string.app_name), getIntent().getExtras().getString(PushMessageKey.message));
                alertDialog.setPositiveButton(R.string.move, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        // Check PushMessage
                        Bundle extras = getIntent().getExtras();
                        if (extras != null) {
                            Long roomId = extras.getLong(AppDefType.ChatPushMessageKey.roomId, 0);
                            String roomName = extras.getString(AppDefType.ChatPushMessageKey.roomName);
                            String pushSendLoginId = extras.getString(AppDefType.ChatPushMessageKey.pushSendLoginId);
                            long pushSendDate = extras.getLong(AppDefType.ChatPushMessageKey.pushSendDate);
                            String collaborationType = extras.getString(AppDefType.ChatPushMessageKey.collaborationType);
                            if (roomId > 0 && !StringUtil.isNullOrEmpty(roomName)) {
                                List<PushMessageDto> pushMessageDtoList = AbstractLogic.getLogic(PushMessageLogic.class).getAllPushMessageList();


                                Logger.d("pushSendDate","pushSendDate : " + pushSendDate);
                                String pushSendDateDate = DateTimeUtil.toString(new Date(pushSendDate), DateTimeFormat.yyyyMMddHHmmssSSS_none);
                                Logger.d("pushSendDate","pushSendDateDate : " + pushSendDateDate);
                                String pushSendDateDate2 = DateTimeUtil.toString(DateTimeUtil.toDate(pushSendDateDate, DateTimeFormat.yyyyMMddHHmmssSSS_none), DateTimeFormat.yyyyMMddHHmmssSSS_none);
                                Logger.d("pushSendDate","pushSendDateDate2 : " + pushSendDateDate2);

                                for (int i=0; i < pushMessageDtoList.size() - 1; i++) {
                                    String tempDate = DateTimeUtil.toString(pushMessageDtoList.get(i).pushSendDate, DateTimeFormat.yyyyMMddHHmmssSSS_none);

                                    Logger.d("tempDate","date : " + tempDate);
                                }
                                if (StringUtil.isNullOrEmpty(collaborationType)) {
                                    ActivityHandlingHelper.getInstance().startChatWebViewActivity(roomId, roomName);
                                } else {
                                    ActivityHandlingHelper.getInstance().startChatWebViewActivityWithCollaboration(roomId, roomName, collaborationType);
                                }
                            }
                        }
                        finish();
                    }
                });
                alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        finish();
                    }
                });
                alertDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {

                    }
                });
                alertDialog.show();
            }
        }
    }
}
