package jp.agentec.abook.abv.ui.common.helper;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ImageView;

public class ABVViewUnbindHelper {
	
    public static void unbindReferences(View view) {        
		try {
			if (view != null) {
				unbindViewReferences(view);
				if (view instanceof ViewGroup) {
					unbindViewGroupReferences((ViewGroup) view);
				}
			}
		} catch (Exception ignore) {

		}  	
    } 
    
    public static void unbindReferences(Activity activity, int viewID) {        
		try {
			View view = activity.findViewById(viewID);
			if (view != null) {
				unbindViewReferences(view);
				if (view instanceof ViewGroup) {
					unbindViewGroupReferences((ViewGroup) view);
				}
			}
		} catch (Exception ignore) {

		}  
    }
    
    private static void unbindViewGroupReferences(ViewGroup viewGroup) {        
		int nrOfChildren = viewGroup.getChildCount();
		for (int i = 0; i < nrOfChildren; i++) {
			View view = viewGroup.getChildAt(i);
			unbindViewReferences(view);
			if (view instanceof ViewGroup) {
				unbindViewGroupReferences((ViewGroup) view);
			}
		}
		try {
			viewGroup.removeAllViews();
		} catch (Exception ignore) {
		}
    }
    
    private static void unbindViewReferences(View view) {
    	try {            
    		view.setOnClickListener(null);        
    	} catch (Exception ignore) {}         
    	try {            
    		view.setOnCreateContextMenuListener(null);        
    	} catch (Exception ignore) {}         
    	try {            
    		view.setOnFocusChangeListener(null);        
    	} catch (Exception ignore) {}         
    	try {            
    		view.setOnKeyListener(null);        
    	} catch (Exception ignore) {}         
    	try {            
    		view.setOnLongClickListener(null);        
    	} catch (Exception ignore) {}         
    	try {           
    		view.setOnClickListener(null);        
    	} catch (Exception ignore) {}         
    	try {            
    		view.setTouchDelegate(null);        
    	} catch (Exception ignore) {}         
    	Drawable d = view.getBackground();        
    	if (d != null) {            
    		try {                
    			d.setCallback(null);            
    		} catch (Exception ignore) {}        
    	}                 
    	if (view instanceof ImageView) {            
    		ImageView imageView = (ImageView)view;            
    		d = imageView.getDrawable();            
    		if (d != null) {                
    			d.setCallback(null);           
    		}        
    		/*
    		if (d instanceof BitmapDrawable) {                
    			Bitmap bm = ((BitmapDrawable)d).getBitmap();                
    			bm.recycle();            
    		}  
    		*/                       
    		imageView.setImageDrawable(null);        
    	} else if (view instanceof WebView) {            
    		view.destroyDrawingCache();
    		((WebView)view).destroy();        
    	}         
    	try {
			//noinspection deprecation(API16から非推奨になった。無視)
    		view.setBackgroundDrawable(null);        
    	} catch (Exception ignore) {}                
    	try {            
    		view.setAnimation(null);        
    	} catch (Exception ignore) {}         
    	try {            
    		view.setContentDescription(null);        
    	} catch (Exception ignore) {}         
    	try {           
    		view.setTag(null);        
    	} catch (Exception ignore) {}    
    }
    
}