package jp.agentec.abook.abv.ui.home.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DownloadManager;
import android.app.PictureInPictureParams;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslError;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.webkit.CookieManager;
import android.webkit.DownloadListener;
import android.webkit.JavascriptInterface;
import android.webkit.JsResult;
import android.webkit.PermissionRequest;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

import jp.agentec.abook.abv.bl.acms.client.AcmsClient;
import jp.agentec.abook.abv.bl.acms.client.json.ArchiveDetailJSON;
import jp.agentec.abook.abv.bl.acms.client.json.ArchiveListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.ChangeRoomNameJSON;
import jp.agentec.abook.abv.bl.acms.client.json.CreatedRoomJSON;
import jp.agentec.abook.abv.bl.acms.client.json.GetFavoriteGroupJSON;
import jp.agentec.abook.abv.bl.acms.client.json.GetFavoriteUserJSON;
import jp.agentec.abook.abv.bl.acms.client.json.GroupListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.MessageInfoListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.MyInfoJSON;
import jp.agentec.abook.abv.bl.acms.client.json.RoomListJSON;
import jp.agentec.abook.abv.bl.acms.client.json.UserInviteResultJSON;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.constant.ABookCommConstants;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.dto.ArchiveDto;
import jp.agentec.abook.abv.bl.dto.ChatGroupDto;
import jp.agentec.abook.abv.bl.dto.ChatMessageDto;
import jp.agentec.abook.abv.bl.dto.ChatRoomDto;
import jp.agentec.abook.abv.bl.dto.MeetingDto;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.abook.abv.bl.dto.ShopMemberDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.CommunicationLogic;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVAuthenticatedActivity;
import jp.agentec.abook.abv.ui.common.activity.ABVContentViewActivity;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.home.view.FullscreenableChromeClient;
import jp.agentec.abook.abv.ui.viewer.activity.CommunicationWebViewActivity;
import jp.agentec.abook.abv.ui.viewer.activity.ParentWebViewActivity;
import jp.agentec.adf.util.CollectionUtil;
import jp.agentec.adf.util.StringUtil;

import static org.chromium.net.NetError.ERR_FAILED;

/**
 * Created by AIS-NB-048 on 2019/07/31.
 */

public class ChatWebViewActivity extends CommunicationWebViewActivity {
    private WebView mChatWebView;
    private String chatWebviewUrl;

    private final String TAG = "ChatWebViewActivity";

    private final String NETWORK_ERROR_PLACE_HOLDER = "file:///android_asset/chat/public_new/chat.html";
    //private final String NETWORK_ERROR_PLACE_HOLDER = "file:///android_asset/chat/public/networkError.html";
    private final String CHAT_PAGE_URL = "file:///android_asset/chat/public_new/chat.html";
    private final String CHAT_ROOM_PAGE_URL = "file:///android_asset/chat/public_new/chat_room.html";

    private final String PICTURE_COLLABORATION_PAGE_URL = "file:///android_asset/chat/public_new/collaboration_picture.html";
    private final String VIDEO_COLLABORATION_PAGE_URL = "file:///android_asset/chat/public_new/collaboration_video.html";
    private final String VOICE_COLLABORATION_PAGE_URL = "file:///android_asset/chat/public_new/collaboration_voice.html";
    private final String DOCUMENT_COLLABORATION_PAGE_URL = "file:///android_asset/chat/public_new/collaboration_documents.html";

    private final String DEFAULT_CHECKSUM = "0000000000";
    //AISDevelop
    private JsInf jsInf = new JsInf();

    private ValueCallback<Uri[]> mUploadMessage;

    private String sid;
    private String roomName;
    private String loginId;
    private String shopName;
    private boolean isOnline;
    private Long roomId;
    private String roomType;
    private String collaborationType;
    private String groupId;
    private String beforeRoomType;
    private Integer shopMemberId;
    private String selectedUserIdList;
    private String mSkey;
    private Integer joinMeetingId;
    // 0:協業生成, 1:協業参加
    private Integer collaborationJoinFlg = 0;
    private MeetingManager meetingManager = MeetingManager.getInstance();
    private ActivityHandlingHelper handlingHelper = ActivityHandlingHelper.getInstance();
    public AlertDialog myAlertDialog;

    private ImageButton mOperationHomeButton;                // ホームボタン
    private ImageButton mOperationRelatedContentButton;      // 関連資料ボタン

    private BroadcastReceiver receiver;

    private CommunicationLogic communicationLogic = AbstractLogic.getLogic(CommunicationLogic.class);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (isNormalSize()) {
            setPortraitIfNormal();
        }
        setContentView(R.layout.chat_webview);
        initializeWebView();
    }

    private void initializeWebView() {
        initiateDatas(getIntent());
        setupChatWebView();
        registJSReactor();
        addDownloadListener();
        observeNetworkChange();
        loadWebViewResource();
        setupDefaultChatWebViewURL();
    }

    private void initiateDatas(Intent intent) {
        communicationLogic.setPackagePath(getFilesDir().getAbsolutePath() + "/");
        sid = intent.getStringExtra("sid");
        roomId = intent.getLongExtra("roomId", 0);
        roomName = intent.getStringExtra("roomName");
        loginId = intent.getStringExtra("loginId");
        shopName = intent.getStringExtra("shopName");
        collaborationType = intent.getStringExtra("collaborationType");
        isOnline = false;

    }

    private void setupDefaultChatWebViewURL() {
        //ネットワークがない場合専用のページを表示。
        ShopMemberDto myInfo = communicationLogic.getMyShopMemberDto();
        if (myInfo != null) {
            shopMemberId = myInfo.shopMemberId;
        }
        chatWebviewUrl = NETWORK_ERROR_PLACE_HOLDER;
        if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
            registChatRoomPageLoader();
            Logger.d("DEVICE_NOT_CONNECTED_NETWORK:");
            return;
        }
        boolean isSIDValid = false;
        try {
            isSIDValid = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).checkSid(sid);
        } catch (Exception e) {
            Logger.d("SID_CHECK_ERROR");
        }

        if (!isSIDValid) { return; }

        isOnline = true;
        chatWebviewUrl = CHAT_PAGE_URL;
        showProgressPopup();
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                communicationLogic.initChatData();
                try {
                    updateMyInfoFromServer();
                    updateAllGroupInfo();
                    updateFavoriteInfo();
                    shopMemberId = communicationLogic.getMyShopMemberDto().shopMemberId;
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            try {
                                registChatRoomPageLoader();
                            } catch (Exception e) {
                                Logger.d("registChatRoomPageLoader Error");
                            }
                        }
                    });
                    closeProgressPopup();
                } catch (Exception e) {
                    Logger.d("Update error");
                }
            }
        });
    }

    private void setupChatWebView() {
        mChatWebView = findViewById(R.id.chatWebview2);
        mChatWebView.setOverScrollMode(View.OVER_SCROLL_NEVER);  //オーバースクロールしない。
        mChatWebView.setVerticalScrollBarEnabled(false); //スクロールバーを消す。
        mChatWebView.addJavascriptInterface(jsInf, "android");
        WebSettings settings = mChatWebView.getSettings();
        settings.setJavaScriptEnabled(true); //Javascriptを有効にする。
        settings.setAppCacheEnabled(true);
        settings.setCacheMode(WebSettings.LOAD_NO_CACHE);

        settings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        settings.setAllowFileAccess(true);
        settings.setUseWideViewPort(true);
        settings.setAllowContentAccess(true);
        settings.setAllowFileAccessFromFileURLs(true);
        settings.setSaveFormData(false);
        settings.setAllowUniversalAccessFromFileURLs(true);
        if (Logger.isDebugEnabled()) {
            mChatWebView.setWebContentsDebuggingEnabled(true); //デバッグモード（chromeからinspect可)
        }
    }

    private void registChatRoomPageLoader() {
        // 最後のチャットのルーム名
        String lastRoomName = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, "");
        // 最後のチャットのルーム
        String lastRoomId = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, "");

        String fixedParam = "&platform=android&isMobile=true&chatServerUrl=" + ABVEnvironment.getInstance().websocketServerHttpUrl;
        //ページをロード
        if (roomId != 0 && roomName != null) {  // by push message
            try {
                jsInf.updateRoomList();
            } catch (Exception e) {
                e.printStackTrace();
            }
            Integer integerRoomId = Integer.parseInt(roomId.toString());
            roomType = communicationLogic.getChatRoom(integerRoomId).type.toString();
            if (StringUtil.isNullOrEmpty(collaborationType)) {
                String parameterData = "sid=" + sid + "&loginId=" + loginId + "&shopName=" + shopName + "&roomId=" + roomId + "&roomName=" + roomName + fixedParam;
                mChatWebView.postUrl(CHAT_ROOM_PAGE_URL, parameterData.getBytes());
            } else {
                collaborationJoinFlg = ABookCommConstants.FLAG.COLLABORATION_JOIN_FLG.INVITE;
                try {
                    AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).joinCollaboration(sid, roomId.intValue());
                } catch (NetworkDisconnectedException e) {
                    e.printStackTrace();
                } catch (AcmsException e) {
                    e.printStackTrace();
                }
                moveCollaborationScreen(Integer.parseInt(collaborationType));
            }
        } else {  // Chat
            if (lastRoomName.length() > 0 && lastRoomId.length() > 0) {
                String parameterData = "sid=" + sid + "&loginId=" + loginId +  "&shopName=" + shopName +  "&roomId=" + lastRoomId + "&roomName=" + lastRoomName + fixedParam;
                mChatWebView.postUrl(chatWebviewUrl, parameterData.getBytes());
            } else {
                String parameterData = "sid=" + sid + "&loginId=" + loginId + "&shopName=" + shopName + fixedParam;
                mChatWebView.postUrl(chatWebviewUrl, parameterData.getBytes());
            }
        }
    }

    private void registJSReactor() {
        mChatWebView.setWebChromeClient(new FullscreenableChromeClient(this) {

            @Override
            @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
            public void onPermissionRequest(final PermissionRequest request) {
                request.grant(request.getResources());
            }

            @Override
            public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
                boolean result = false;
                // 画像が選択された場合
                if (fileChooserParams.getAcceptTypes()[0].toLowerCase().indexOf(ABookKeys.IMAGE) != -1) {
                    result = startCameraIntent(ABOOK_CHECK_TASK_IMAGE, "Camera", ABookKeys.IMAGE, true);
                    // 動画が選択された場合
                } else if (fileChooserParams.getAcceptTypes()[0].toLowerCase().indexOf(ABookKeys.VIDEO) != -1) {
                    result = startCameraIntent(ABOOK_CHECK_TASK_VIDEO, "Camera", ABookKeys.VIDEO, true);
                }
                if (result) {
                    if (mUploadMessage != null) {
                        mUploadMessage.onReceiveValue(null);
                    }
                    mUploadMessage = filePathCallback;
                }
                return result;
            }

            // WebView内のAlert Dialogを処理する
            @Override
            public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
                if (myAlertDialog != null && myAlertDialog.isShowing()) {
                    result.confirm();
                    return true;
                }

                if (message.equals("server error Ocurred")) {
                    message = getString(R.string.msg_error_chat_server);
                } else if (message.equals("Disconnected from the server")) {
                    message = getString(R.string.msg_error_chat_disconnected);
                } else if (message.equals("connect_error")) {
                    message = getString(R.string.msg_error_chat_connect);
                } else if (message.equals("Room not found")) {
                    message = getString(R.string.msg_error_chat_room_not_found);
                } else if (message.equals("ServerError 500")) {
                    message = getString(R.string.msg_error_chat_500);
                } else if (message.equals("error chat join")) {
                    message = getString(R.string.msg_error_chat_join);
                } else if (message.equals("Message length error")) {
                    message = getString(R.string.msg_error_chat_text_length);
                    // #36130 start
                } else if (message.equals("Input RoomName")) {
                    message = getString(R.string.msg_error_chat_input_roomname);
                    // #36130 end
                    // #36142
                } else if (message.equals("Please enter room name less than 20 characters")) {
                    message = getString(R.string.msg_error_chat_room_name_too_long);
                } else if (message.equals("InvalidSpecialCharacterRoomName")) {
                    message = getString(R.string.msg_error_chat_name_has_invalid_character);
                } else if (message.equals("SC_FORBIDDEN")) {
                    message = getString(R.string.msg_error_chat_room_sc_forbidden);
                } else {
                    message = message;
                }

                final String tempMessage = message;

                ABookAlertDialog dialog = AlertDialogUtil.createAlertDialog(ChatWebViewActivity.this, R.string.app_name);
                dialog.setMessage(message);
                dialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        // サーバと接続された場合、チャット画面を閉じる

                        if (tempMessage.equals(getString(R.string.msg_error_chat_disconnected)) || tempMessage.equals(getString(R.string.msg_error_chat_room_sc_forbidden))) {
                            mChatWebView.loadUrl("javascript:CHAT.leaveRoom()");
                            finish();
                        } else if (tempMessage.equals(getString(R.string.msg_error_chat_join))) {
                            getLogin();
                            finish();
                        }
                    }
                });

                myAlertDialog = dialog;
                if (!isFinishing() && !message.equals("false")) {
                    dialog.show();
                }
                result.confirm();
                return true;
            }

            // WebView内のConfirm Dialogを処理する
            @Override
            public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
                if (message.equals("Do you want to leave this room?")) {
                    message = getString(R.string.msg_chat_confirm_exit);
                } else if (message.equals("Do you want to remove selected members from the list?")) {
                    message = getString(R.string.msg_chat_confirm_member);
                    // #36128
                } else if (message.equals("Do you want to delete this room?")) {
                    message = getString(R.string.msg_chat_confirm_delete);
                }  else if (message.equals("error_already_exist_same_user")) {
                    message = getString(R.string.msg_error_already_exist_same_room);
                } else if (message.equals("방장 권한을 전달 받으시겠습니까?")){
                    message = getString(R.string.msg_confirm_send_host_change);
                }
                ABookAlertDialog confirmAlert = AlertDialogUtil.createAlertDialog(ChatWebViewActivity.this, R.string.app_name);
                confirmAlert.setMessage(message);

                if (message.equals(getString(R.string.msg_error_already_exist_same_room))) {
                    confirmAlert.setButton(DialogInterface.BUTTON_POSITIVE, getResources().getString(R.string.move), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            result.confirm();
                        }
                    });
                } else {
                    confirmAlert.setButton(DialogInterface.BUTTON_POSITIVE, getResources().getString(R.string.confirm), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            result.confirm();
                        }
                    });
                }
                confirmAlert.setButton(DialogInterface.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        result.cancel();
                    }
                });
                confirmAlert.setCancelable(false);
                showAlertDialog(confirmAlert);
                return true;
            }
        });
    }

    private void addDownloadListener() {
        mChatWebView.setDownloadListener(new DownloadListener() {
            @Override
            public void onDownloadStart(String url, String userAgent,
                                        String contentDisposition, String mimetype,
                                        long contentLength) {
                Uri uri = Uri.parse(url);
                DownloadManager.Request request = new DownloadManager.Request(uri);

                final String fileName = uri.getQueryParameter("fileName");

                //------------------------COOKIE!!------------------------
                String cookies = CookieManager.getInstance().getCookie(url);
                request.addRequestHeader("cookie", cookies);
                //------------------------COOKIE!!------------------------
                request.addRequestHeader("User-Agent", userAgent);
                request.setTitle(fileName);
                request.allowScanningByMediaScanner();
                request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED); //Notify client once download is completed!
                request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, fileName);
                DownloadManager dm = (DownloadManager) getSystemService(DOWNLOAD_SERVICE);
                if (dm != null) {
                    dm.enqueue(request);
                }
                Toast.makeText(getApplicationContext(), getString(R.string.download_start), //To notify the Client that the file is being downloaded
                        Toast.LENGTH_LONG).show();
            }
        });
    }

    private void observeNetworkChange() {
        // ブロードキャストレシーバーの追加
        receiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                ConnectivityManager connectivityManager = (ConnectivityManager) getApplicationContext().getSystemService(Context.CONNECTIVITY_SERVICE);

                if (DownloadManager.ACTION_DOWNLOAD_COMPLETE.equals(intent.getAction())) {
                    mChatWebView.loadUrl("javascript:CHAT_UI.dismissLoadingIndicator()");
                }

                if (intent.getAction().equals(ConnectivityManager.CONNECTIVITY_ACTION)) {
                    NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                    if (networkInfo == null || !networkInfo.isConnectedOrConnecting()) {
                        isOnline = false;
                        mChatWebView.loadUrl("javascript:CHAT_UI.refreshForOffline();");
                    } else {
                        isOnline = true;
                        mChatWebView.loadUrl("javascript:CHAT_UI.refreshForOnline();");
                    }
                }
            }
        };
        // レシーバーオブジェクトの生成
        IntentFilter tempIntent = new IntentFilter(DownloadManager.ACTION_DOWNLOAD_COMPLETE);
        tempIntent.addAction(WifiManager.NETWORK_STATE_CHANGED_ACTION);
        tempIntent.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
        registerReceiver(receiver, tempIntent);
    }

    private void loadWebViewResource() {
        mChatWebView.setWebViewClient(new WebViewClient() {
            @Override
            public void onLoadResource(WebView view, String url) {

                if (url.contains("profileFileName")) {
                    Uri uri = Uri.parse(url);
                    String fileName = uri.getQueryParameter("profileFileName");
                    String filePath = getFilesDir().getAbsolutePath() + "/" + fileName;
                    Logger.d(TAG, filePath);

                    File file = new File(filePath);
                    NetworkTask networkTask = new NetworkTask(url, filePath);
                    networkTask.execute();
                } else if (url.contains("/file/getImage")) {
                    Uri uri = Uri.parse(url);
                    String fileName = uri.getQueryParameter("fileName");
                    String filePath = getFilesDir().getAbsolutePath() + "/" + fileName;
                    Logger.d(TAG, filePath);

                    File file = new File(filePath);
                    NetworkTask networkTask = new NetworkTask(url, filePath);
                    networkTask.execute();
                } else {
                    super.onLoadResource(view, url);
                }
            }

            @Override
            public void onReceivedError(WebView view, int errorCode,
                                        String description, String failingUrl) {

                if (errorCode == ERR_FAILED) {

                    mChatWebView.removeView(view);
                    view.removeAllViews();
                    mChatWebView.reload();
                    mChatWebView.loadUrl(NETWORK_ERROR_PLACE_HOLDER);
                }
                Logger.d("WEB_VIEW_ERROR", "error code:" + errorCode + " - " + description);
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                    Logger.d("url", "url : " + url);

                    Uri uri = Uri.parse(url);
                    String fileName = new File(Objects.requireNonNull(uri.getPath())).getName();

                    // イメージをダウンロードする(png, jpg, jpeg, mp4, mov)
                    if (url.toLowerCase().endsWith(".png") || url.toLowerCase().endsWith(".jpg") || url.toLowerCase().endsWith(".jpeg")
                            || url.toLowerCase().endsWith(".mov") || url.toLowerCase().endsWith(".mp4")) {
                        view.loadUrl("javascript:CHAT_UI.showLoadingIndicator()");
                        DownloadManager mdDownloadManager = (DownloadManager) getSystemService(Context.DOWNLOAD_SERVICE);
                        DownloadManager.Request request = new DownloadManager.Request(
                                Uri.parse(url));
                        File destinationFile = new File(Environment.getExternalStorageDirectory(), fileName);
                        request.setDescription("Downloading ...");
                        request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);
                        request.setDestinationUri(Uri.fromFile(destinationFile));
                        assert mdDownloadManager != null;
                        mdDownloadManager.enqueue(request);
                    } else {  // その他のファイルはurlのみ確認
                        Logger.d("download ", "download URL :" + url);
                    }
                    return false;
                }

            @Override
            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                handler.proceed();
            }
        });
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (isNormalSize()) {
            setPortraitIfNormal();
        }
    }

    // 下辺のツールバー設定
    private void settingBottomToolbar() {
        // ホームボタン活性化
        mOperationHomeButton.setEnabled(true);
        // 共通資料ボタンの非活性化
        mOperationRelatedContentButton.setEnabled(true);
        // バッチを付けるか判定して、イメージを設定
        setCommunicationImageButton();


        // コミュニケーションボタン
        communicationButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showCommunicationMenuDialog();
            }
        });
    }

    /**
     * コミュニケーションメニューダイアログ
     */
    public void showCommunicationMenuDialog2() {
        mCommunicationMenuDialog = new Dialog(this);
        mCommunicationMenuDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        mCommunicationMenuDialog.setCanceledOnTouchOutside(false);
        mCommunicationMenuDialog.setContentView(R.layout.communication_menu_dialog);

        List<PushMessageDto> pushMessageDtoList = pushMessageLogic.getAllPushMessageList();

        boolean existUnreadFlg = false;
        for (PushMessageDto pushMessageDto : pushMessageDtoList) {
            if (!pushMessageDto.readingFlg) {
                existUnreadFlg = true;
                break;
            }
        }

        ImageView ivIcon = (ImageView)mCommunicationMenuDialog.findViewById(R.id.btn_push_message_list);

        if (existUnreadFlg) {
            ivIcon.setBackgroundResource(R.drawable.ic_communication_push_message_list_with_badge);
        } else {
            ivIcon.setBackgroundResource(R.drawable.ic_communication_push_message_list);
        }

        LinearLayout ll_menuItem_meeting = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_meeting);
        ll_menuItem_meeting.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ActivityHandlingHelper.getInstance().startMeetingActivity();
                mCommunicationMenuDialog.dismiss();
            }
        });

        LinearLayout ll_menuItem_push_message = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_push_message);
        ll_menuItem_push_message.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                showOperationSelectDialog();
                mCommunicationMenuDialog.dismiss();
            }
        });

        LinearLayout ll_menuItem_push_message_list = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_push_message_list);
        ll_menuItem_push_message_list.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//                showPushMessageListDialog();
                mCommunicationMenuDialog.dismiss();
            }
        });

        // chat
        LinearLayout ll_menuItem_chat = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_chat);
        ll_menuItem_chat.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                // チャット利用のはネットワークが繋がる時のみ
                if (ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
                    showProgressPopup();
                    ActivityHandlingHelper.getInstance().startChatWebViewActivity();
                    mCommunicationMenuDialog.dismiss();
                } else {
                    ABVToastUtil.showMakeText(ChatWebViewActivity.this, R.string.request_network_connection, Toast.LENGTH_SHORT);
                    return;
                }
            }
        });

        mCommunicationMenuDialog.findViewById(R.id.close_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mCommunicationMenuDialog.dismiss();
            }
        });

        mCommunicationMenuDialog.show();
    }

    // 保存するファイルをjpgに固定する
    public String getFileName(String url) {
        String filenameWithoutExtension = "";
        filenameWithoutExtension = String.valueOf(System.currentTimeMillis()
                + ".jpg");
        return filenameWithoutExtension;
    }

    public void getLogin() {
        // ローカルの言語を確認する
        String localLanguage = ActivityHandlingHelper.getInstance().getLocaleFileName();
        // 最後のチャットのルーム名
        String lastRoomName = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, "");
        // 最後のチャットのルーム
        String lastRoomId = PreferenceUtil.getUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, "");

        if (roomId != 0 && roomName != null) {
            // 最後のチャットのルーム名
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, roomName);
            // 最後のチャットのルーム
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, String.valueOf(roomId));

            mChatWebView.loadUrl(String.format("javascript:getLoginParameter('%s', '%s', '%s', '%s', '%s', '%s', '%s');", sid, loginId, shopName, roomId, roomName, localLanguage, shopMemberId));
        } else {
            if (lastRoomName.length() > 0 && lastRoomId.length() > 0) {
                mChatWebView.loadUrl(String.format("javascript:getLoginParameter('%s', '%s', '%s', '%s', '%s', '%s', '%s');", sid, loginId, shopName, lastRoomId, lastRoomName, localLanguage, shopMemberId));
            } else {
                mChatWebView.loadUrl(String.format("javascript:getLoginParameter('%s', '%s', '%s', undefined, undefined, '%s', '%s');", sid, loginId, shopName, localLanguage, shopMemberId));
            }
        }
    }

    public void getQueryParam() {
        String chatServerUrl = ABVEnvironment.getInstance().websocketServerHttpUrl;
        chatServerUrl= chatServerUrl.substring(0, chatServerUrl.length() - 3);
        String cmsServerUrl = ABVEnvironment.getInstance().acmsAddress+ ABVDataCache.getInstance().getUrlPath();

        mChatWebView.loadUrl(String.format("javascript:getGlobalParam('%s', '%s', '%s', '%s', '%s');", chatServerUrl, cmsServerUrl, "android", true, isOnline));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Uri[] result = null;
        Uri dataUri = null;
        if (data != null && resultCode == RESULT_OK) {
            String dataString = data.getDataString();
            if (dataString != null) {
                dataUri = Uri.parse(dataString);
                result = new Uri[]{dataUri};
            }
        }

        if (requestCode == ABOOK_CHECK_TASK_IMAGE) {
            if (mUploadMessage == null) {
                return;
            }
            // 画像
            try {
                if (dataUri == null) {
                    dataUri = imageUri;
                }
                Uri responseUri = attachmentImageProcessing(dataUri);
                if (responseUri != null) {
                    mUploadMessage.onReceiveValue(new Uri[]{responseUri});
                } else {
                    mUploadMessage.onReceiveValue(null);
                }
            } catch (Exception e) {
                Logger.e(TAG, e);
                mUploadMessage.onReceiveValue(null);
                ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
            }
        } else if (requestCode == ABOOK_CHECK_TASK_VIDEO) {
            if (mUploadMessage == null) {
                return;
            }
            mUploadMessage.onReceiveValue(result);
        }
        mUploadMessage = null;
    }

    /**
     * 未読のプッシュメッセージが存在するかチェック
     * @param pushMessageDtoList チェックするリスト
     * @return
     */
    private boolean checkUnReadCommunication(List<PushMessageDto> pushMessageDtoList) {
        boolean existUnreadFlg = false;
        for (PushMessageDto pushMessageDto : pushMessageDtoList) {
            if (!pushMessageDto.readingFlg) {
                existUnreadFlg = true;
                break;
            }
        }
        return existUnreadFlg;
    }

    private class JsInf {
        @JavascriptInterface
        public void saveVisitRoomInfo(String roomId, String roomName) {
            System.out.println("roomName : " + roomName);
            System.out.println("roomId : " + roomId);
            // 最後のチャットのルーム名
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMNAME, roomName);
            // 最後のチャットのルーム
            PreferenceUtil.putUserPref(getApplicationContext(), AppDefType.UserPrefKey.CHAT_LAST_ROOMID, roomId);
        }
        @JavascriptInterface
        public void getLoginParameter() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    getLogin();
                }
            });
        }

        @JavascriptInterface
        public void getGlobalParameter() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    getQueryParam();
                }
            });
        }

        @JavascriptInterface
        public void goHome() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    backToHome();
                }
            });

        }

        @JavascriptInterface
        public void openOperationRelatedContent() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    showCommonContent();
                }
            });
        }

        @JavascriptInterface
        public void openCommunication() {
            showCommunicationMenuDialog();
        }

        @JavascriptInterface
        public void openCommunicationHome() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    mChatWebView.loadUrl(CHAT_PAGE_URL);
                }
            });
        }

        @JavascriptInterface
        public void reload() {
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    ActivityHandlingHelper.getInstance().startChatWebViewActivity();
                }
            });

        }

        @JavascriptInterface
        public void saveSelectedUserList(String userIdList) {
            Log.d("userIdList " , userIdList );
            selectedUserIdList = userIdList;
        }

        @JavascriptInterface
        public String getSelectedUserList() {
            String userList = communicationLogic.getUserList(selectedUserIdList);
            Log.d("getSelectedUserList " , userList );
            return userList;
        }

        @JavascriptInterface
        public String getRoomList(String roomType, String keyword) {
            String chatRoomListStr = communicationLogic.getChatRoomList(Integer.parseInt(roomType), keyword);
            return chatRoomListStr;
        }

        @JavascriptInterface
        public void updateRoomList() throws NetworkDisconnectedException, AcmsException {
            Map<String, Object> chatRoomList;
            RoomListJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getRoomList(sid);
            //communicationLogic.deleteChatRoomList();
            communicationLogic.insertChatRoomList(resultJson.roomList);
        }

        @JavascriptInterface
        public void updateMyInfo() throws NetworkDisconnectedException, AcmsException {
            updateMyInfoFromServer();
        }

        @JavascriptInterface
        public void updateGroupInfo(String groupId) throws NetworkDisconnectedException, AcmsException {
            updateGroupInfoFromServer(groupId);
        }

        @JavascriptInterface
        public void updateGroupUser() throws NetworkDisconnectedException, AcmsException {
            updateGroupInfoFromServer(communicationLogic.getMyGroupIds());

        }

        @JavascriptInterface
        public void createChatRoom(String roomType, String userIdList, String encodedRoomName, String screenFlg, boolean isVoice) throws NetworkDisconnectedException, AcmsException {
            CreatedRoomJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).createRoom(sid, roomType, userIdList, encodedRoomName, loginId);
            if (ABookCommConstants.FLAG.SCREEN_FLG.MAKE_ROOM.equals(Integer.parseInt(screenFlg))) {
                final ChatRoomDto chatRoomDto = communicationLogic.getChatRoom(resultJson.chatRoomDto.chatRoomId);
                if (chatRoomDto != null) {
                    mChatWebView.post(new Runnable() {
                        @Override
                        public void run() {
                            mChatWebView.loadUrl(String.format("javascript:CHAT_UI.displayExistRoom('%s');", chatRoomDto.chatRoomId.toString()));
                        }
                    });
                    return;
                }
            }
            communicationLogic.insertChatRoom(resultJson.chatRoomDto);
            communicationLogic.addUserInRoom(StringUtil.join(",", userIdList, shopMemberId.toString()), resultJson.chatRoomDto.chatRoomId);
            final Integer chatRoomId = resultJson.chatRoomDto.chatRoomId;
            final String chatRoomName = resultJson.chatRoomDto.chatRoomName;
            if (isVoice) {
                roomId = chatRoomId.longValue();
                roomName = chatRoomName;
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl(String.format("javascript:CHAT_UI.startCollaboration('%s');", ABookCommConstants.FLAG.COLLABORATION_TYPE.AUDIO));
                    }
                });
            } else {
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl(String.format("javascript:CHAT_UI.joinRoom('%s', '%s');", chatRoomId, chatRoomName));
                    }
                });
            }
        }

        @JavascriptInterface
        public void changeRoomName(String changeRoomName) throws NetworkDisconnectedException, AcmsException {
            ChangeRoomNameJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).changeRoomName(sid, changeRoomName, roomId.intValue());
            if (resultJson.status != 200) { return; }

            communicationLogic.updateChatRoomName(changeRoomName, roomId.intValue());
            joinRoom(roomId.toString(), changeRoomName);
        }

        @JavascriptInterface
        public void joinRoom(String joinRoomId, String joinRoomName) {
            ChatRoomDto chatRoom = communicationLogic.getChatRoom(Integer.parseInt(joinRoomId));
            roomId = chatRoom.chatRoomId.longValue();
            roomName = chatRoom.chatRoomName;
            roomType = chatRoom.type.toString();
            beforeRoomType = chatRoom.type.toString();
            communicationLogic.roomDisplayOff(roomId.intValue(), ABookCommConstants.FLAG.ROOM_VIEW_FLAG.VISIBLE);

            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    mChatWebView.loadUrl(CHAT_ROOM_PAGE_URL);
                }
            });
        }


        @JavascriptInterface
        public void roomDisplayOff() {
            communicationLogic.roomDisplayOff(roomId.intValue(), ABookCommConstants.FLAG.ROOM_VIEW_FLAG.INVISIBLE);
            mChatWebView.post(new Runnable() {
                @Override
                public void run() {
                    mChatWebView.loadUrl(CHAT_PAGE_URL);
                }
            });
        }

        @JavascriptInterface
        public void inviteUsers(String userIds, boolean isCollaboration) throws NetworkDisconnectedException, AcmsException {
            final UserInviteResultJSON result = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).inviteUsers(sid, roomId.intValue(), roomName, userIds);
            if (result.roomId == null) {
                communicationLogic.addUserInRoom(userIds, roomId.intValue());
                if (!isCollaboration) {
                    mChatWebView.post(new Runnable() {
                        @Override
                        public void run() {
                            mChatWebView.loadUrl(CHAT_ROOM_PAGE_URL);
                        }
                    });
                }
            } else {
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl(String.format("javascript:CHAT_UI.displayExistRoom('%s');", result.roomId.toString()));
                    }
                });
            }
        }

        @JavascriptInterface
        public String getRoomType() {
            return roomType;
        }

        @JavascriptInterface
        public String getBeforeRoomType() {
            return beforeRoomType;
        }

        @JavascriptInterface
        public void clearBeforeRoomType() {
            beforeRoomType = null;
        }

        @JavascriptInterface
        public void updateMessages(String roomId) throws NetworkDisconnectedException, AcmsException {
            MessageInfoListJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getMessages(sid, roomId);
            for (ChatMessageDto chatMessageDto : resultJson.chatMessageDtoArrayList) {
                chatMessageDto.chatRoomId = Integer.parseInt(roomId);
            }
            communicationLogic.insertMessageList(resultJson.chatMessageDtoArrayList);
            communicationLogic.insertShopMember(resultJson.shopMemberDtoArrayList);
        }

        @JavascriptInterface
        public String getMessageList(String roomId) {
            String messageListStr = communicationLogic.getMessages(Integer.parseInt(roomId));
            return messageListStr;
        }

        @JavascriptInterface
        public String searchMessages(String keyword, String userList) {
            String messageListStr = communicationLogic.searMessages(roomId.intValue(), keyword, userList);
            return messageListStr;
        }

        @JavascriptInterface
        public String getFavoriteUsers() {
            String favoriteUsersStr = communicationLogic.getFavoriteUsers();
            return favoriteUsersStr;
        }

        @JavascriptInterface
        public String getFavoriteUsersNotInRoom() {
            String favoriteUsersStr = communicationLogic.getFavoriteUsersNotInRoom(roomId.intValue());
            return favoriteUsersStr;
        }

        @JavascriptInterface
        public String getMyInfo() {
            String myInfoStr = communicationLogic.getMyInfo();
            return myInfoStr;
        }

        @JavascriptInterface
        public String getUsersInRoom(String roomId) {
            String attendUsers = communicationLogic.getUsersInRoom(Integer.parseInt(roomId));
            return attendUsers;
        }

        @JavascriptInterface
        public String getMyGroupUsers() {
            String myGroupUsersStr = communicationLogic.getMyGroupUsers();
            return myGroupUsersStr;
        }

        @JavascriptInterface
        public String getMyGroupUsersNotInRoom() {
            String myGroupUsersStr = communicationLogic.getMyGroupUsersNotInRoom(roomId.intValue());
            return myGroupUsersStr;
        }

        @JavascriptInterface
        public String getMyGroupShopMemberByName(String keyword) {
            String searchUserStr = communicationLogic.getMyGroupUserByName(keyword);
            return searchUserStr;
        }

        @JavascriptInterface
        public String getMyGroupShopMemberNotInRoomByName(String keywords) {
            String searchUserStr = communicationLogic.getMyGroupUserNotInRoomByName(keywords, roomId.intValue());
            return searchUserStr;
        }

        @JavascriptInterface
        public String getAllGroupShopMemberByName(String shopMemberName) {
            String searchUserStr = communicationLogic.getAllGroupShopMemberByName(shopMemberName);
            return searchUserStr;
        }

        @JavascriptInterface
        public String getAllGroupShopMemberNotInRoomByName(String keywords) {
            String searchUserStr = communicationLogic.getAllGroupShopMemberNotInRoomByName(keywords, roomId.intValue());
            return searchUserStr;
        }

        @JavascriptInterface
        public String getGroupByName(String keyword) {
            String searchGroupStr = communicationLogic.getGroupByName(keyword);
            return searchGroupStr;
        }

        @JavascriptInterface
        public String getFavoriteGroups() {
            String favoriteGroupsStr = communicationLogic.getFavoriteGroups();
            return favoriteGroupsStr;
        }
        @JavascriptInterface
        public void updateUserInfo(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
            updateUserInfoFromServer(shopMemberId);
        }

        @JavascriptInterface
        public String getGroupInfo(String groupId) {
            String groupInfoStr = communicationLogic.getGroupSearchData(Integer.parseInt(groupId));
            return groupInfoStr;
        }

        @JavascriptInterface
        public String getGroupInfoForAddUser(String groupId) {
            String groupInfoStr = communicationLogic.getGroupSearchDataForAddUser(Integer.parseInt(groupId), roomId.intValue());
            return groupInfoStr;
        }

        @JavascriptInterface
        public String getNameCardData(String shopMemberId) {
            String nameCardStr = communicationLogic.getNameCardInfo(Integer.parseInt(shopMemberId));
            return nameCardStr;
        }

        @JavascriptInterface
        public String getFavoriteGroupsList() {
            String favoriteGroupsListStr = communicationLogic.getFavoriteGroups();
            return favoriteGroupsListStr;
        }

        @JavascriptInterface
        public boolean addFavoriteUser(String shopMemberId) throws AcmsException {
            Integer favoriteCount = communicationLogic.getFavoriteCount();
            if (favoriteCount >= ABookCommConstants.SIZE.MAX_FAVORITE_COUNT ) {
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl("javascript:alert('" + "お気に入りは最大100件までです。" + "');");
                    }
                });
                return false;
            } else {
                boolean result = false;
                try {
                    result = insertFavoriteUser(shopMemberId);
                    if (!result) { return false; }

                    mChatWebView.post(new Runnable() {
                        @Override
                        public void run() {
                            mChatWebView.loadUrl("javascript:CHAT_UI.refreshContactScreen();");
                        }
                    });
                    return true;
                } catch (NetworkDisconnectedException e) {
                    mChatWebView.post(new Runnable() {
                        @Override
                        public void run() {
                            mChatWebView.loadUrl("javascript:alert('接続しているネットワークがありません。');");
                        }
                    });
                }
            }
            return false;
        }

        @JavascriptInterface
        public boolean removeFavoriteUser(String shopMemberId) throws AcmsException {
            try {
                boolean result = deleteFavoriteUser(shopMemberId);
                if (!result) {
                    return false;
                }
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl("javascript:CHAT_UI.refreshContactScreen();");
                    }
                });
                return true;
            } catch (NetworkDisconnectedException e) {
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl("javascript:alert('接続しているネットワークがありません。');");
                    }
                });
            }
            return false;
        }

        @JavascriptInterface
        public boolean addFavoriteGroup(String groupId) throws  AcmsException {

            Integer favoriteCount = communicationLogic.getFavoriteCount();
            if (favoriteCount >= ABookCommConstants.SIZE.MAX_FAVORITE_COUNT) {
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl("javascript:alert('" + "お気に入りは最大100件までです。" + "');");
                    }
                });
                return false;
            } else {
                boolean result = false;
                try {
                    result = insertFavoriteGroup(groupId);
                    if (!result) {
                        return false;
                    }
                    mChatWebView.post(new Runnable() {
                        @Override
                        public void run() {
                            mChatWebView.loadUrl("javascript:CHAT_UI.refreshContactScreen();");
                        }
                    });
                    return true;
                } catch (NetworkDisconnectedException e) {
                    mChatWebView.post(new Runnable() {
                        @Override
                        public void run() {
                            mChatWebView.loadUrl("javascript:alert('接続しているネットワークがありません。');");
                        }
                    });
                }
            }
            return false;
        }

        @JavascriptInterface
        public boolean removeFavoriteGroup(String groupId) throws AcmsException {
            boolean result = false;
            try {
                result = deleteFavoriteGroup(groupId);
                if (!result) {
                    return false;
                }

                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl("javascript:CHAT_UI.refreshContactScreen();");
                    }
                });
                return true;
            } catch (NetworkDisconnectedException e) {
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl("javascript:alert('接続しているネットワークがありません。');");
                    }
                });
            }
            return false;
        }

        @JavascriptInterface
        public void updateFavorite() throws NetworkDisconnectedException, AcmsException {
            updateFavoriteInfo();
        }

        @JavascriptInterface
        public void updateArchiveList() throws NetworkDisconnectedException, AcmsException {
            SharedPreferences pref = getSharedPreferences(ABookCommConstants.TAG, MODE_PRIVATE);
            String updateDate = pref.getString(ABookCommConstants.KEY.ARCHIVE_INFO_LAST_UPDATE_DATE, DEFAULT_CHECKSUM);
            ArchiveListJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getArchives(sid, updateDate);
            communicationLogic.updateArchives(resultJson.archiveList);
            if (StringUtil.isNullOrEmpty(resultJson.archiveLastUpdateDate)) { return; }

            SharedPreferences.Editor editor = pref.edit();
            editor.putString(ABookCommConstants.KEY.ARCHIVE_INFO_LAST_UPDATE_DATE, resultJson.archiveLastUpdateDate);
            editor.commit();
        }

        @JavascriptInterface
        public String getArchiveList() {
            String archiveListStr = communicationLogic.getAllArchive();
            return archiveListStr;
        }

        @JavascriptInterface
        public String getArchiveListByName(String keyword) {
            String archiveListStr = communicationLogic.getArchiveListByName(keyword);
            return archiveListStr;
        }

        @JavascriptInterface
        public String getUserInfo(String shopMemberId) {
            String archiveListStr = communicationLogic.getUserInfo(Integer.parseInt(shopMemberId));
            return archiveListStr;
        }

        @JavascriptInterface
        public String getUserInfoList(String shopMemberIds) {
            String userIds = shopMemberIds;
            String UserInfoList = communicationLogic.getUserList(shopMemberIds);
            return UserInfoList;
        }

        @JavascriptInterface
        public String getArchiveDetail(String archiveId) {
            String archiveListStr = communicationLogic.getArchiveDetail(Integer.parseInt(archiveId));
            return archiveListStr;
        }

        @JavascriptInterface
        public void updateArchiveDetail(String archiveId) throws NetworkDisconnectedException, AcmsException {
            ArchiveDto archiveDto = communicationLogic.getArchive(Integer.parseInt(archiveId));
            ArchiveDetailJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getArchiveDetail(sid, Integer.parseInt(archiveId), archiveDto.collaborationDetailId);

            if (resultJson.archiveDto == null) {
                return;
            }
            communicationLogic.updateArchiveDetial(resultJson.archiveDto);
        }

        @JavascriptInterface
        public void joinCollaboration(String collaborationType, String meetingId) throws NetworkDisconnectedException, AcmsException {
            joinMeetingId = Integer.parseInt(meetingId);
            collaborationJoinFlg = ABookCommConstants.FLAG.COLLABORATION_JOIN_FLG.JOIN;
            AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).joinCollaboration(sid, roomId.intValue());
            moveCollaborationScreen(Integer.parseInt(collaborationType));
        }

        @JavascriptInterface
        public void inviteCollaboration(String inviteUserIds, String collaborationType) throws NetworkDisconnectedException, AcmsException {
            AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).inviteCollaboration(sid, roomId.intValue(), roomName, inviteUserIds, collaborationType);
        }

        @JavascriptInterface
        public void startCollaboration(String collaborationType) {
            collaborationJoinFlg = ABookCommConstants.FLAG.COLLABORATION_JOIN_FLG.CREATE;
            moveCollaborationScreen(Integer.parseInt(collaborationType));
        }

        @JavascriptInterface
        public String getCollaborationJoinFlg() {
            return collaborationJoinFlg.toString();
        }

        @JavascriptInterface
        public String getCollaborationType() {
            return collaborationType;
        }

        @JavascriptInterface
        public String getToMoveGroupId() {
            return groupId;
        }

        @JavascriptInterface
        public void setToMoveGroupId(String moveToGroupId) {
            groupId = moveToGroupId;
        }

        @JavascriptInterface
        public String getContentList() {
            return communicationLogic.getContentList();
        }

        @JavascriptInterface
        public String getUserListByLoginId(String loginIdList) {
            return communicationLogic.getUserListByLoginId(loginIdList);
        }


        @JavascriptInterface
        public String createContentView() {
            Integer meetingId = null;
            meetingManager.close();
            activityHandlingHelper.removeContentViewActivity(activityHandlingHelper.getContentViewActivity());
            try {
                connectMeetingServer();
                List<MeetingDto> meetingList= meetingManager.getMeetingList(mSkey);
                for (MeetingDto meeting : meetingList) {
                    if (meeting.title.equals("Collaboration__"+roomId) && meetingManager.isOwner()) {
                        meetingManager.deleteMeeting(meeting.meetingId, mSkey);
                    }
                }
                meetingId = meetingManager.createMeeting(mSkey, "Collaboration_"+roomId, roomId.toString());
                meetingManager.join(meetingId, mSkey, roomId.toString(), true);
            } catch (Exception e) {
                mChatWebView.loadUrl("javascript:alert('" + "会議室サーバに接続できませんでした。" + "');");
            }
            finishBeforeContentListActivity();
            PictureInPictureParams.Builder mPipBuilder = new PictureInPictureParams.Builder();
            enterPictureInPictureMode(mPipBuilder.build());
            startContentListActivity(true);
            return meetingId.toString();
        }

        @JavascriptInterface
        public void startContentView() {
            Integer meetingId;
            meetingManager.close();
            activityHandlingHelper.removeContentViewActivity(activityHandlingHelper.getContentViewActivity());
            try {
                connectMeetingServer();
                List<MeetingDto> meetingList= meetingManager.getMeetingList(mSkey);
                meetingManager.join(joinMeetingId, mSkey, roomId.toString(), false);
            } catch (Exception e) {
                mChatWebView.loadUrl("javascript:alert('" + "会議室サーバに接続できませんでした。" + "');");
            }
            finishBeforeContentListActivity();
            PictureInPictureParams.Builder mPipBuilder = new PictureInPictureParams.Builder();
            enterPictureInPictureMode(mPipBuilder.build());
            startContentListActivity(false);
        }

        @JavascriptInterface
        public void startPipMode() {
            PictureInPictureParams.Builder mPipBuilder = new PictureInPictureParams.Builder();
            enterPictureInPictureMode(mPipBuilder.build());

        }

        @JavascriptInterface
        public void exitMeetingRoom() {
            exitMeetingRoom();
        }
    }

    /**
     * 作業一覧へ遷移
     */
    private void backToHome() {
        mChatWebView.loadUrl("javascript:CHAT.leaveRoom()");
        exitMeetingRoom();
        finish();
        Intent intent = new Intent();
        intent.setClass(ChatWebViewActivity.this, OperationListActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        startActivity(intent, NaviConsts.Left);
    }

    private void finishBeforeContentListActivity() {
        OperationRelatedContentActivity beforeActiryty = activityHandlingHelper.getActivity(OperationRelatedContentActivity.class);
        if (beforeActiryty != null) {
            beforeActiryty.finish();
        }
    }

    public void exitMeetingRoom() {
        if (meetingManager.isConnected() && meetingManager.isOwner()) {
            try {
                meetingManager.deleteMeeting();
            } catch (Exception e) {
                Logger.e(TAG, "showMeetingExitDialog deleteMeeting error", e);
            }
        }
        meetingManager.close();
        handlingHelper.saveMeetingInfo(null, null, null, false);
    }

    private void startContentListActivity(boolean isOwner) {
        Activity targetActivity = activityHandlingHelper.getCurrentActivity();
        if (targetActivity instanceof ChatWebViewActivity) {
            Stack<ABVAuthenticatedActivity> stack = activityHandlingHelper.getCurrentActivityStack();
            if (stack.size() > 1){
                targetActivity = stack.get(stack.size()-2);
            }
        }

        Intent intent = new Intent();
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        intent.setClass(targetActivity, OperationRelatedContentActivity.class);
        intent.putExtra("isCollaboration", true);
        intent.putExtra("isCollaborationOwner", isOwner);
        targetActivity.startActivity(intent);
    }
    public void connectMeetingServer() throws Exception {
        meetingManager = MeetingManager.getInstance();
        mSkey = meetingManager.getSessionKey(true);
    }

    private void updateMyInfoFromServer() throws NetworkDisconnectedException, AcmsException {
        MyInfoJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getMyInfo(sid);
        if (resultJson.shopMemberDto != null) {
            communicationLogic.insertMyInfo(resultJson.shopMemberDto);
        }
    }

    private void updateUserInfoFromServer(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        MyInfoJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter)
                .getNameCard(sid, shopMemberId);
        communicationLogic.insertShopMember(resultJson.shopMemberDto);
    }

    private boolean insertFavoriteUser(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).insertFavoriteUser(sid,Integer.parseInt(shopMemberId));
        if (!result) { return false; }
        List<Integer> shopMeberIds = new ArrayList<>();
        shopMeberIds.add(Integer.parseInt(shopMemberId));
        communicationLogic.updateFavoriteUser(shopMeberIds);
        return result;
    }

    private boolean deleteFavoriteUser(String shopMemberId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter)
                .deleteFavoriteUser(sid, Integer.parseInt(shopMemberId));
        if (result) {
            List<Integer> deleteFavoriteList = new ArrayList<Integer>();
            deleteFavoriteList.add(Integer.parseInt(shopMemberId));
            communicationLogic.deleteavoriteUser(deleteFavoriteList);
        }
        return result;
    }

    private boolean insertFavoriteGroup(String groupId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter)
                .insertFavoriteGroup(sid, Integer.parseInt(groupId));
        return result;
    }
    @Override
    public void onBackPressed() {

            super.onBackPressed();

    }
    private void moveCollaborationScreen(Integer collaborationType) {
        switch (collaborationType) {
            case 0:
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl(VOICE_COLLABORATION_PAGE_URL);
                    }
                });
                break;
            case 2:
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl(PICTURE_COLLABORATION_PAGE_URL);
                    }
                });
                break;
            case 3:
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl(VIDEO_COLLABORATION_PAGE_URL);
                    }
                });
                break;
            case 4:
                mChatWebView.post(new Runnable() {
                    @Override
                    public void run() {
                        mChatWebView.loadUrl(DOCUMENT_COLLABORATION_PAGE_URL);
                    }
                });
                break;
            default:
                break;
        }
    }

    private boolean deleteFavoriteGroup(String groupId) throws NetworkDisconnectedException, AcmsException {
        boolean result = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter)
                .deleteFavoriteGroup(sid, Integer.parseInt(groupId));

        if (!result) { return false; }

        List<Integer> deleteFavoriteList = new ArrayList<Integer>();
        deleteFavoriteList.add(Integer.parseInt(groupId));
        communicationLogic.deleteavoriteGroup(deleteFavoriteList);
        return true;
    }

    private void updateGroupInfoFromServer(String groupIds) throws NetworkDisconnectedException, AcmsException {
        ArrayList<String> checkSumList = new ArrayList<String>();
        SharedPreferences pref = getSharedPreferences(ABookCommConstants.TAG, MODE_PRIVATE);

        for (String groupId : groupIds.split(",")) {
            //checkSumList.add(pref.getString(groupId,DEFAULT_CHECKSUM));
            checkSumList.add(DEFAULT_CHECKSUM);
        }
        String checkSumListStr = StringUtil.join(",",checkSumList);
        if (groupIds.equals(ABookCommConstants.FLAG.GROUP_REQUEST_ALL.toString())) {
            checkSumListStr = DEFAULT_CHECKSUM;
        }
        try {
            GroupListJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getGroupInfo(sid,groupIds,checkSumListStr);
            if (CollectionUtil.isNotEmpty(resultJson.groupList)) {
                SharedPreferences.Editor editor = pref.edit();
                communicationLogic.updateGroup(resultJson.groupList);
                if (groupIds.equals(ABookCommConstants.FLAG.GROUP_REQUEST_ALL.toString())) {
                    editor.putString(ABookCommConstants.FLAG.GROUP_REQUEST_ALL.toString(),resultJson.allGroupLastUpdateDate);
                } else {
                    for (ChatGroupDto groupDto : resultJson.groupList) {
                        editor.putString(Integer.toString(groupDto.groupId),groupDto.updateDate);
                    }
                }
                editor.commit();
            }
        } catch (AcmsException e) {
            e.printStackTrace();
        }

    }

    private void updateFavoriteUser() throws NetworkDisconnectedException, AcmsException {
        GetFavoriteUserJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getFavoriteUser(sid);
        communicationLogic.updateFavoriteUser(resultJson.favoriteUserIds);
    }

    private void updateFavoriteGroup() throws NetworkDisconnectedException, AcmsException {
        GetFavoriteGroupJSON resultJson = AcmsClient.getInstance(ABVEnvironment.getInstance().networkAdapter).getFavoriteGroup(sid);
        communicationLogic.updateFavoriteGroup(resultJson.favoriteGroupIds);
    }

    private void updateAllGroupInfo() throws NetworkDisconnectedException, AcmsException {
        updateGroupInfoFromServer(ABookCommConstants.FLAG.GROUP_REQUEST_ALL.toString());
        List<ChatGroupDto> groupList = communicationLogic.getAllGroup();

        for (ChatGroupDto group : groupList) {
            updateGroupInfoFromServer(Integer.toString(group.groupId));
        }
    }

    private void updateFavoriteInfo() throws NetworkDisconnectedException, AcmsException {
        updateFavoriteUser();
        updateFavoriteGroup();
    }

    /**　
     * ボタンイベント設定
     */
    private void setOnButtonEvent() {
        // 作業のホーム画面へ
        mOperationHomeButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                backToHome();
            }
        });
    }

    @Override
    public void onPictureInPictureModeChanged (boolean isInPictureInPictureMode, Configuration newConfig) {
        if (isInPictureInPictureMode) {
            mChatWebView.loadUrl("javascript:$('.pip_indicator').removeClass('none');");
        } else {
            mChatWebView.loadUrl("javascript:$('.pip_indicator').addClass('none');");
        }
    }

    // 共通資料画面表示
    private void showCommonContent() {
        Intent intent = new Intent();
        intent.setClass(ChatWebViewActivity.this, OperationRelatedContentActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        startActivity(intent, NaviConsts.Left);
    }

    public class NetworkTask extends AsyncTask<Void, Void, Bitmap> {

        private String url;
        private String filePath;
        private ContentValues values;
        private Bitmap mBitmap;
        public NetworkTask(String url, String filePath) {

            this.url = url;
            this.filePath = filePath;
        }


        @Override
        protected Bitmap doInBackground(Void... params) {
            try {
                mBitmap =BitmapFactory.decodeStream((InputStream) new URL(url).getContent());
            } catch (IOException e) {
                e.printStackTrace();
            }
            return mBitmap;
        }

        @Override
        protected void onPostExecute(Bitmap resultBitmap) {
            super.onPostExecute(resultBitmap);
            try {
                if (resultBitmap == null) {
                    return;
                }
                File f = new File(filePath);

                f.createNewFile();

                Bitmap bitmap = resultBitmap;

                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.PNG, 0, bos);
                byte[] bitmapData = bos.toByteArray();

                FileOutputStream fos = new FileOutputStream(f);
                fos.write(bitmapData);
                fos.flush();
                fos.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onDestroy(){
        exitMeetingRoom();
        super.onDestroy();
        if (receiver != null) {
            unregisterReceiver(receiver);
            receiver = null;
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        boolean eventPrevent = false;
        switch (keyCode) {
            case KeyEvent.KEYCODE_BACK:
                backToHome();
                eventPrevent = true;
                break;
        }
        return eventPrevent;
    }

}
