package jp.agentec.abook.abv.ui.viewer.helper;

import android.content.Context;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.exception.ABVExceptionCode;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.launcher.android.R;

/**
 * シーン画像ファイルをサーバへ登録する処理クラス
 */
public class SceneSendHelper {
    private static final String TAG = "SceneSendHelper";

    private SceneSendHelper.DeviceImageListSendListener listener;
    private Context mContext;
    public SceneSendHelper(Context context) {
        mContext = context;
    }

    public void setListener(SceneSendHelper.DeviceImageListSendListener listener) {
        this.listener = listener;
    }

    public interface DeviceImageListSendListener {
        void sceneSendfinish();
        void changeProgress(final int progress);
        void sceneSendFail(final String errorMessage);
        void sceneSendFailRetry(List<String> retrySendImages);
    }

    /**
     * シーン画像をサーバへ送信
     * @param sendImages シーン画像ファイルPath配列
     * @param operationId 作業ID
     * @param OperationName 作業名
     * @param isBaseSceneUpload ベースシーン登録フラグ（true:登録、false:登録しない）
     * @param isBaseSceneUploadSuccess ベースシーン登録済みフラグ（true:登録済み、false:未登録）
     */
    public void sendSceneImages(final List<String> sendImages, final Long operationId, final String OperationName, final boolean isBaseSceneUpload, final boolean isBaseSceneUploadSuccess) {
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                String firstFilePath = sendImages.get(0);
                final List<String> needSendImages = new ArrayList<>(sendImages);
                for(String filePath : sendImages){
                    File file = new File(filePath);
                    try {
                        if (isBaseSceneUpload && !isBaseSceneUploadSuccess && firstFilePath.equals(filePath)) {
                            AbstractLogic.getLogic(OperationLogic.class).sendPanoContent(operationId, OperationName, file);
                        } else {
                            AbstractLogic.getLogic(OperationLogic.class).sendScene(file, null);
                        }
                        needSendImages.remove(filePath);

                        //プログレスバー進捗
                        int progress = (int) (((float)(sendImages.size() - needSendImages.size()) / sendImages.size()) * 100);
                        listener.changeProgress(progress);

                        //送信終了
                        if (needSendImages.size() == 0) {
                            listener.sceneSendfinish();
                        }
                    } catch (AcmsException ex) {
                        Logger.e(TAG, ex.toString());
                        if (ex.getCode() == ABVExceptionCode.P_E_ACMS_P007) {
                            listener.sceneSendFail(mContext.getString(R.string.error_msg_open_pano_edit));
                        } else if (ex.getCode() == ABVExceptionCode.P_E_ACMS_P002) {
                            listener.sceneSendFail(mContext.getString(R.string.P002));
                        } else {
                            listener.sceneSendFailRetry(needSendImages);
                        }
                        break;
                    } catch (ABVException abve) {
                        Logger.e(TAG, abve.toString());
                        if (abve.getCode() == ABVExceptionCode.P_E_ACMS_P002) {
                            listener.sceneSendFail(mContext.getString(R.string.P002));
                        }
                    } catch (Exception e) {
                        Logger.e(TAG, e.toString());
                        listener.sceneSendFailRetry(needSendImages);
                        break;
                    }
                }
            }
        });
    }
}
