/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.pdf417.decoder.ec;

import oz.util.barcode.pdf417.decoder.ec.ModulusPoly;

public final class ModulusGF {
    public static final ModulusGF PDF417_GF = new ModulusGF(929, 3);
    private final int[] expTable;
    private final int[] logTable;
    private final ModulusPoly zero;
    private final ModulusPoly one;
    private final int modulus;

    private ModulusGF(int n, int n2) {
        this.modulus = n;
        this.expTable = new int[n];
        this.logTable = new int[n];
        int n3 = 1;
        int n4 = 0;
        while (n4 < n) {
            this.expTable[n4] = n3;
            n3 = n3 * n2 % n;
            ++n4;
        }
        n4 = 0;
        while (n4 < n - 1) {
            this.logTable[this.expTable[n4]] = n4;
            ++n4;
        }
        this.zero = new ModulusPoly(this, new int[1]);
        this.one = new ModulusPoly(this, new int[]{1});
    }

    ModulusPoly getZero() {
        return this.zero;
    }

    ModulusPoly getOne() {
        return this.one;
    }

    ModulusPoly buildMonomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.zero;
        }
        int[] nArray = new int[n + 1];
        nArray[0] = n2;
        return new ModulusPoly(this, nArray);
    }

    int add(int n, int n2) {
        return (n + n2) % this.modulus;
    }

    int subtract(int n, int n2) {
        return (this.modulus + n - n2) % this.modulus;
    }

    int exp(int n) {
        return this.expTable[n];
    }

    int log(int n) {
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[n];
    }

    int inverse(int n) {
        if (n == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.modulus - this.logTable[n] - 1];
    }

    int multiply(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[n] + this.logTable[n2]) % (this.modulus - 1)];
    }

    int getSize() {
        return this.modulus;
    }
}

