/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.main.overlay;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import oz.viewer.ui.main.overlay.AOverlayUtil;
import oz.viewer.ui.main.overlay.AutoHideAbleOZOverlayView;
import oz.viewer.ui.main.overlay.OverlayLayout;

public class APageStatusManager
extends AutoHideAbleOZOverlayView {
    private static final int MIN_MARGIN_TOP = 10;
    private static final int SMALL_MARGIN_RIGHT = 10;
    private static final int BIG_MARGIN_RIGHT = 35;
    private TextView mView;
    private String mText;
    private boolean mNeedMinimumMarginTop;
    private boolean mBigScrollImageMarginRight;

    public APageStatusManager(OverlayLayout overlayLayout) {
        super(overlayLayout, 7);
        this.setAutoHideEnable(true);
        this.initView();
        this.setNeedMinimumMarginTop(true);
    }

    private void initView() {
        this.mView = new TextView(this.getContext());
        this.mView.setTextColor(-1);
        this.mView.setTextSize(14.0f);
        this.mView.setGravity(17);
        this.mView.setPadding(AOverlayUtil.getDP10(), AOverlayUtil.DpToPx(2), AOverlayUtil.getDP10(), AOverlayUtil.DpToPx(2));
        ShapeDrawable shapeDrawable = AOverlayUtil.getRoundRectDrawable(AOverlayUtil.getDP10());
        shapeDrawable.getPaint().setAntiAlias(true);
        shapeDrawable.getPaint().setColor(-1090519040);
        this.mView.setBackgroundDrawable((Drawable)shapeDrawable);
        this.mView.setVisibility(8);
    }

    protected View getView() {
        return this.mView;
    }

    protected void addToOverlayView(OverlayLayout overlayLayout, View view) {
        FrameLayout frameLayout = (FrameLayout)overlayLayout.findLayout(22000);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 53);
        this.updateMargin(layoutParams);
        frameLayout.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    private void updateMargin(FrameLayout.LayoutParams layoutParams) {
        layoutParams.setMargins(0, this.mNeedMinimumMarginTop ? AOverlayUtil.DpToPx(10) : 0, AOverlayUtil.DpToPx(this.mBigScrollImageMarginRight ? 35 : 10), AOverlayUtil.getDP10());
    }

    protected void updateView() {
        this.updateMargin((FrameLayout.LayoutParams)this.mView.getLayoutParams());
        this.mView.setText((CharSequence)this.mText);
    }

    public void setPageStatusText(String string) {
        if (this.mText == null || !this.mText.equals(string)) {
            this.mText = string;
            this.requestNeedUpdateView();
        }
    }

    public void setNeedMinimumMarginTop(boolean bl) {
        if (this.mNeedMinimumMarginTop != bl) {
            this.mNeedMinimumMarginTop = bl;
            this.requestNeedUpdateView();
        }
    }

    public void setNeedBigScrollImageMarginRight(boolean bl) {
        if (this.mBigScrollImageMarginRight != bl) {
            this.mBigScrollImageMarginRight = bl;
            this.requestNeedUpdateView();
        }
    }
}

