/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.os.Handler;
import java.util.LinkedList;
import java.util.List;
import org.chromium.base.Callback;

public class Promise<T> {
    private static final int UNFULFILLED = 0;
    private static final int FULFILLED = 1;
    private static final int REJECTED = 2;
    private int mState = 0;
    private T mResult;
    private final List<Callback<T>> mFulfillCallbacks = new LinkedList<Callback<T>>();
    private Exception mRejectReason;
    private final List<Callback<Exception>> mRejectCallbacks = new LinkedList<Callback<Exception>>();
    private final Thread mThread = Thread.currentThread();
    private final Handler mHandler = new Handler();
    private boolean mThrowingRejectionHandler;

    public void then(Callback<T> onFulfill) {
        this.checkThread();
        if (this.mThrowingRejectionHandler) {
            this.thenInner(onFulfill);
            return;
        }
        assert (this.mRejectCallbacks.size() == 0) : "Do not call the single argument Promise.then(Callback) on a Promise that already has a rejection handler.";
        Callback<Exception> onReject = new Callback<Exception>(){

            @Override
            public void onResult(Exception reason) {
                throw new UnhandledRejectionException("Promise was rejected without a rejection handler.", reason);
            }
        };
        this.then(onFulfill, onReject);
        this.mThrowingRejectionHandler = true;
    }

    public void then(Callback<T> onFulfill, Callback<Exception> onReject) {
        this.checkThread();
        this.thenInner(onFulfill);
        this.exceptInner(onReject);
    }

    public void except(Callback<Exception> onReject) {
        this.checkThread();
        this.exceptInner(onReject);
    }

    public Callback<T> fulfillmentCallback() {
        return new Callback<T>(){

            @Override
            public void onResult(T result) {
                Promise.this.fulfill(result);
            }
        };
    }

    private void thenInner(Callback<T> onFulfill) {
        if (this.mState == 1) {
            this.postCallbackToLooper(onFulfill, this.mResult);
        } else if (this.mState == 0) {
            this.mFulfillCallbacks.add(onFulfill);
        }
    }

    private void exceptInner(Callback<Exception> onReject) {
        assert (!this.mThrowingRejectionHandler) : "Do not add an exception handler to a Promise you have called the single argument Promise.then(Callback) on.";
        if (this.mState == 2) {
            this.postCallbackToLooper(onReject, this.mRejectReason);
        } else if (this.mState == 0) {
            this.mRejectCallbacks.add(onReject);
        }
    }

    public <R> Promise<R> then(final Function<T, R> function) {
        this.checkThread();
        final Promise<T> promise = new Promise<T>();
        this.thenInner(new Callback<T>(){

            @Override
            public void onResult(T result) {
                try {
                    promise.fulfill(function.apply(result));
                }
                catch (Exception e) {
                    promise.reject(e);
                }
            }
        });
        this.exceptInner(Promise.rejectPromiseCallback(promise));
        return promise;
    }

    public <R> Promise<R> then(final AsyncFunction<T, R> function) {
        this.checkThread();
        final Promise<T> promise = new Promise<T>();
        this.thenInner(new Callback<T>(){

            @Override
            public void onResult(T result) {
                try {
                    function.apply(result).then(new Callback<R>(){

                        @Override
                        public void onResult(R result) {
                            promise.fulfill(result);
                        }
                    }, Promise.rejectPromiseCallback(promise));
                }
                catch (Exception e) {
                    promise.reject(e);
                }
            }
        });
        this.exceptInner(Promise.rejectPromiseCallback(promise));
        return promise;
    }

    public void fulfill(T result) {
        this.checkThread();
        assert (this.mState == 0);
        this.mState = 1;
        this.mResult = result;
        for (Callback<T> callback : this.mFulfillCallbacks) {
            this.postCallbackToLooper(callback, result);
        }
        this.mFulfillCallbacks.clear();
    }

    public void reject(Exception reason) {
        this.checkThread();
        assert (this.mState == 0);
        this.mState = 2;
        this.mRejectReason = reason;
        for (Callback<Exception> callback : this.mRejectCallbacks) {
            this.postCallbackToLooper(callback, reason);
        }
        this.mRejectCallbacks.clear();
    }

    public void reject() {
        this.reject(null);
    }

    public boolean isFulfilled() {
        this.checkThread();
        return this.mState == 1;
    }

    public boolean isRejected() {
        this.checkThread();
        return this.mState == 2;
    }

    public static <T> Promise<T> fulfilled(T result) {
        Promise<T> promise = new Promise<T>();
        promise.fulfill(result);
        return promise;
    }

    private void checkThread() {
        assert (this.mThread == Thread.currentThread()) : "Promise must only be used on a single Thread.";
    }

    private <S> void postCallbackToLooper(final Callback<S> callback, final S result) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                callback.onResult(result);
            }
        });
    }

    private static <T> Callback<Exception> rejectPromiseCallback(final Promise<T> promise) {
        return new Callback<Exception>(){

            @Override
            public void onResult(Exception reason) {
                promise.reject(reason);
            }
        };
    }

    public static class UnhandledRejectionException
    extends RuntimeException {
        public UnhandledRejectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface AsyncFunction<A, R> {
        public Promise<R> apply(A var1);
    }

    public static interface Function<A, R> {
        public R apply(A var1);
    }
}

