/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.base.CollectionUtil;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
class DeviceSensors
implements SensorEventListener {
    private static final String TAG = "cr.DeviceSensors";
    private static final String EXPERIMENTAL_WEB_PLAFTORM_FEATURES = "enable-experimental-web-platform-features";
    private Thread mThread;
    private Handler mHandler;
    private final Context mAppContext;
    private final Object mHandlerLock = new Object();
    private long mNativePtr;
    private final Object mNativePtrLock = new Object();
    private float[] mMagneticFieldVector;
    private float[] mTruncatedRotationVector;
    private float[] mDeviceRotationMatrix;
    private double[] mRotationAngles;
    private SensorManagerProxy mSensorManagerProxy;
    private static DeviceSensors sSingleton;
    private static Object sSingletonLock;
    static final Set<Integer> DEVICE_ORIENTATION_SENSORS_A;
    static final Set<Integer> DEVICE_ORIENTATION_SENSORS_B;
    static final Set<Integer> DEVICE_ORIENTATION_SENSORS_C;
    static final Set<Integer> DEVICE_ORIENTATION_ABSOLUTE_SENSORS;
    static final Set<Integer> DEVICE_MOTION_SENSORS;
    static final Set<Integer> DEVICE_LIGHT_SENSORS;
    @VisibleForTesting
    final Set<Integer> mActiveSensors = new HashSet<Integer>();
    final List<Set<Integer>> mOrientationSensorSets;
    Set<Integer> mDeviceOrientationSensors;
    boolean mDeviceLightIsActive = false;
    boolean mDeviceMotionIsActive = false;
    boolean mDeviceOrientationIsActive = false;
    boolean mDeviceOrientationIsActiveWithBackupSensors = false;
    boolean mDeviceOrientationAbsoluteIsActive = false;
    boolean mOrientationNotAvailable = false;

    protected DeviceSensors(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mOrientationSensorSets = CollectionUtil.newArrayList(DEVICE_ORIENTATION_SENSORS_A, DEVICE_ORIENTATION_SENSORS_B, DEVICE_ORIENTATION_SENSORS_C);
    }

    @VisibleForTesting
    protected boolean registerOrientationSensorsWithFallback(int rateInMicroseconds) {
        if (this.mOrientationNotAvailable) {
            return false;
        }
        if (this.mDeviceOrientationSensors != null) {
            return this.registerSensors(this.mDeviceOrientationSensors, rateInMicroseconds, true);
        }
        this.ensureRotationStructuresAllocated();
        for (Set<Integer> sensors : this.mOrientationSensorSets) {
            this.mDeviceOrientationSensors = sensors;
            if (!this.registerSensors(this.mDeviceOrientationSensors, rateInMicroseconds, true)) continue;
            return true;
        }
        this.mOrientationNotAvailable = true;
        this.mDeviceOrientationSensors = null;
        this.mDeviceRotationMatrix = null;
        this.mRotationAngles = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public boolean start(long nativePtr, int eventType, int rateInMicroseconds) {
        boolean success = false;
        Object object = this.mNativePtrLock;
        synchronized (object) {
            switch (eventType) {
                case 2: {
                    success = this.registerOrientationSensorsWithFallback(rateInMicroseconds);
                    break;
                }
                case 4: {
                    this.ensureRotationStructuresAllocated();
                    success = this.registerSensors(DEVICE_ORIENTATION_ABSOLUTE_SENSORS, rateInMicroseconds, true);
                    break;
                }
                case 1: {
                    success = this.registerSensors(DEVICE_MOTION_SENSORS, rateInMicroseconds, false);
                    break;
                }
                case 8: {
                    success = this.registerSensors(DEVICE_LIGHT_SENSORS, rateInMicroseconds, true);
                    break;
                }
                default: {
                    Log.e(TAG, "Unknown event type: %d", eventType);
                    return false;
                }
            }
            if (success) {
                this.mNativePtr = nativePtr;
                this.setEventTypeActive(eventType, true);
            }
            return success;
        }
    }

    @CalledByNative
    public int getNumberActiveDeviceMotionSensors() {
        HashSet<Integer> deviceMotionSensors = new HashSet<Integer>(DEVICE_MOTION_SENSORS);
        deviceMotionSensors.removeAll(this.mActiveSensors);
        return DEVICE_MOTION_SENSORS.size() - deviceMotionSensors.size();
    }

    @CalledByNative
    public int getOrientationSensorTypeUsed() {
        if (this.mOrientationNotAvailable) {
            return 0;
        }
        if (this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_A) {
            return 3;
        }
        if (this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_B) {
            return 1;
        }
        if (this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_C) {
            return 2;
        }
        assert (false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void stop(int eventType) {
        HashSet<Integer> sensorsToRemainActive = new HashSet<Integer>();
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mDeviceOrientationIsActive && eventType != 2) {
                sensorsToRemainActive.addAll(this.mDeviceOrientationSensors);
            }
            if (this.mDeviceOrientationAbsoluteIsActive && eventType != 4) {
                sensorsToRemainActive.addAll(DEVICE_ORIENTATION_ABSOLUTE_SENSORS);
            }
            if (this.mDeviceMotionIsActive && eventType != 1) {
                sensorsToRemainActive.addAll(DEVICE_MOTION_SENSORS);
            }
            if (this.mDeviceLightIsActive && eventType != 8) {
                sensorsToRemainActive.addAll(DEVICE_LIGHT_SENSORS);
            }
            HashSet<Integer> sensorsToDeactivate = new HashSet<Integer>(this.mActiveSensors);
            sensorsToDeactivate.removeAll(sensorsToRemainActive);
            this.unregisterSensors(sensorsToDeactivate);
            this.setEventTypeActive(eventType, false);
            if (this.mActiveSensors.isEmpty()) {
                this.mNativePtr = 0L;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        this.sensorChanged(event.sensor.getType(), event.values);
    }

    @VisibleForTesting
    void sensorChanged(int type2, float[] values) {
        switch (type2) {
            case 1: {
                if (this.mDeviceMotionIsActive) {
                    this.gotAccelerationIncludingGravity(values[0], values[1], values[2]);
                }
                if (!this.mDeviceOrientationIsActiveWithBackupSensors) break;
                this.getOrientationFromGeomagneticVectors(values, this.mMagneticFieldVector);
                break;
            }
            case 10: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotAcceleration(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotRotationRate(values[0], values[1], values[2]);
                break;
            }
            case 11: {
                if (this.mDeviceOrientationAbsoluteIsActive) {
                    this.convertRotationVectorToAngles(values, this.mRotationAngles);
                    this.gotOrientationAbsolute(this.mRotationAngles[0], this.mRotationAngles[1], this.mRotationAngles[2]);
                }
                if (!this.mDeviceOrientationIsActive || this.mDeviceOrientationSensors != DEVICE_ORIENTATION_SENSORS_B) break;
                if (!this.mDeviceOrientationAbsoluteIsActive) {
                    this.convertRotationVectorToAngles(values, this.mRotationAngles);
                }
                this.gotOrientation(this.mRotationAngles[0], this.mRotationAngles[1], this.mRotationAngles[2]);
                break;
            }
            case 15: {
                if (!this.mDeviceOrientationIsActive) break;
                this.convertRotationVectorToAngles(values, this.mRotationAngles);
                this.gotOrientation(this.mRotationAngles[0], this.mRotationAngles[1], this.mRotationAngles[2]);
                break;
            }
            case 2: {
                if (!this.mDeviceOrientationIsActiveWithBackupSensors) break;
                if (this.mMagneticFieldVector == null) {
                    this.mMagneticFieldVector = new float[3];
                }
                System.arraycopy(values, 0, this.mMagneticFieldVector, 0, this.mMagneticFieldVector.length);
                break;
            }
            case 5: {
                if (!this.mDeviceLightIsActive) break;
                this.gotLight(values[0]);
                break;
            }
            default: {
                return;
            }
        }
    }

    @VisibleForTesting
    public static double[] computeDeviceOrientationFromRotationMatrix(float[] matrixR, double[] values) {
        if (matrixR.length != 9) {
            return values;
        }
        if (matrixR[8] > 0.0f) {
            values[0] = Math.atan2(-matrixR[1], matrixR[4]);
            values[1] = Math.asin(matrixR[7]);
            values[2] = Math.atan2(-matrixR[6], matrixR[8]);
        } else if (matrixR[8] < 0.0f) {
            values[0] = Math.atan2(matrixR[1], -matrixR[4]);
            values[1] = -Math.asin(matrixR[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = Math.atan2(matrixR[6], -matrixR[8]);
        } else if (matrixR[6] > 0.0f) {
            values[0] = Math.atan2(-matrixR[1], matrixR[4]);
            values[1] = Math.asin(matrixR[7]);
            values[2] = -1.5707963267948966;
        } else if (matrixR[6] < 0.0f) {
            values[0] = Math.atan2(matrixR[1], -matrixR[4]);
            values[1] = -Math.asin(matrixR[7]);
            values[1] = values[1] + (values[1] >= 0.0 ? -Math.PI : Math.PI);
            values[2] = -1.5707963267948966;
        } else {
            values[0] = Math.atan2(matrixR[3], matrixR[0]);
            values[1] = matrixR[7] > 0.0f ? 1.5707963267948966 : -1.5707963267948966;
            values[2] = 0.0;
        }
        if (values[0] < 0.0) {
            values[0] = values[0] + Math.PI * 2;
        }
        return values;
    }

    public void convertRotationVectorToAngles(float[] rotationVector, double[] angles) {
        if (rotationVector.length > 4) {
            System.arraycopy(rotationVector, 0, this.mTruncatedRotationVector, 0, 4);
            SensorManager.getRotationMatrixFromVector((float[])this.mDeviceRotationMatrix, (float[])this.mTruncatedRotationVector);
        } else {
            SensorManager.getRotationMatrixFromVector((float[])this.mDeviceRotationMatrix, (float[])rotationVector);
        }
        DeviceSensors.computeDeviceOrientationFromRotationMatrix(this.mDeviceRotationMatrix, angles);
        for (int i = 0; i < 3; ++i) {
            angles[i] = Math.toDegrees(angles[i]);
        }
    }

    private void getOrientationFromGeomagneticVectors(float[] acceleration, float[] magnetic) {
        if (acceleration == null || magnetic == null) {
            return;
        }
        if (!SensorManager.getRotationMatrix((float[])this.mDeviceRotationMatrix, null, (float[])acceleration, (float[])magnetic)) {
            return;
        }
        DeviceSensors.computeDeviceOrientationFromRotationMatrix(this.mDeviceRotationMatrix, this.mRotationAngles);
        this.gotOrientation(Math.toDegrees(this.mRotationAngles[0]), Math.toDegrees(this.mRotationAngles[1]), Math.toDegrees(this.mRotationAngles[2]));
    }

    private SensorManagerProxy getSensorManagerProxy() {
        if (this.mSensorManagerProxy != null) {
            return this.mSensorManagerProxy;
        }
        ThreadUtils.assertOnUiThread();
        SensorManager sensorManager = (SensorManager)this.mAppContext.getSystemService("sensor");
        if (sensorManager != null) {
            this.mSensorManagerProxy = new SensorManagerProxyImpl(sensorManager);
        }
        return this.mSensorManagerProxy;
    }

    @VisibleForTesting
    void setSensorManagerProxy(SensorManagerProxy sensorManagerProxy) {
        this.mSensorManagerProxy = sensorManagerProxy;
    }

    private void setEventTypeActive(int eventType, boolean active) {
        switch (eventType) {
            case 2: {
                this.mDeviceOrientationIsActive = active;
                this.mDeviceOrientationIsActiveWithBackupSensors = active && this.mDeviceOrientationSensors == DEVICE_ORIENTATION_SENSORS_C;
                return;
            }
            case 4: {
                this.mDeviceOrientationAbsoluteIsActive = active;
                return;
            }
            case 1: {
                this.mDeviceMotionIsActive = active;
                return;
            }
            case 8: {
                this.mDeviceLightIsActive = active;
                return;
            }
        }
    }

    private void ensureRotationStructuresAllocated() {
        if (this.mDeviceRotationMatrix == null) {
            this.mDeviceRotationMatrix = new float[9];
        }
        if (this.mRotationAngles == null) {
            this.mRotationAngles = new double[3];
        }
        if (this.mTruncatedRotationVector == null) {
            this.mTruncatedRotationVector = new float[4];
        }
    }

    private boolean registerSensors(Set<Integer> sensorTypes, int rateInMicroseconds, boolean failOnMissingSensor) {
        HashSet<Integer> sensorsToActivate = new HashSet<Integer>(sensorTypes);
        sensorsToActivate.removeAll(this.mActiveSensors);
        if (sensorsToActivate.isEmpty()) {
            return true;
        }
        boolean success = false;
        for (Integer sensorType : sensorsToActivate) {
            boolean result = this.registerForSensorType(sensorType, rateInMicroseconds);
            if (!result && failOnMissingSensor) {
                this.unregisterSensors(sensorsToActivate);
                return false;
            }
            if (!result) continue;
            this.mActiveSensors.add(sensorType);
            success = true;
        }
        return success;
    }

    private void unregisterSensors(Iterable<Integer> sensorTypes) {
        for (Integer sensorType : sensorTypes) {
            if (!this.mActiveSensors.contains(sensorType)) continue;
            this.getSensorManagerProxy().unregisterListener(this, sensorType);
            this.mActiveSensors.remove(sensorType);
        }
    }

    private boolean registerForSensorType(int type2, int rateInMicroseconds) {
        SensorManagerProxy sensorManager = this.getSensorManagerProxy();
        if (sensorManager == null) {
            return false;
        }
        return sensorManager.registerListener(this, type2, rateInMicroseconds, this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotOrientation(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotOrientation(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotOrientationAbsolute(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotOrientationAbsolute(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAcceleration(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotAcceleration(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAccelerationIncludingGravity(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotAccelerationIncludingGravity(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotRotationRate(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotRotationRate(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotLight(double value) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0L) {
                this.nativeGotLight(this.mNativePtr, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler() {
        Object object = this.mHandlerLock;
        synchronized (object) {
            if (this.mHandler == null) {
                HandlerThread thread = new HandlerThread("DeviceMotionAndOrientation");
                thread.start();
                this.mHandler = new Handler(thread.getLooper());
            }
            return this.mHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    static DeviceSensors getInstance(Context appContext) {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new DeviceSensors(appContext);
            }
            return sSingleton;
        }
    }

    private native void nativeGotOrientation(long var1, double var3, double var5, double var7);

    private native void nativeGotOrientationAbsolute(long var1, double var3, double var5, double var7);

    private native void nativeGotAcceleration(long var1, double var3, double var5, double var7);

    private native void nativeGotAccelerationIncludingGravity(long var1, double var3, double var5, double var7);

    private native void nativeGotRotationRate(long var1, double var3, double var5, double var7);

    private native void nativeGotLight(long var1, double var3);

    static {
        sSingletonLock = new Object();
        DEVICE_ORIENTATION_SENSORS_A = CollectionUtil.newHashSet(15);
        DEVICE_ORIENTATION_SENSORS_B = CollectionUtil.newHashSet(11);
        DEVICE_ORIENTATION_SENSORS_C = CollectionUtil.newHashSet(1, 2);
        DEVICE_ORIENTATION_ABSOLUTE_SENSORS = CollectionUtil.newHashSet(11);
        DEVICE_MOTION_SENSORS = CollectionUtil.newHashSet(1, 10, 4);
        DEVICE_LIGHT_SENSORS = CollectionUtil.newHashSet(5);
    }

    static class SensorManagerProxyImpl
    implements SensorManagerProxy {
        private final SensorManager mSensorManager;

        SensorManagerProxyImpl(SensorManager sensorManager) {
            this.mSensorManager = sensorManager;
        }

        @Override
        public boolean registerListener(SensorEventListener listener, int sensorType, int rate, Handler handler) {
            List sensors = this.mSensorManager.getSensorList(sensorType);
            if (sensors.isEmpty()) {
                return false;
            }
            return this.mSensorManager.registerListener(listener, (Sensor)sensors.get(0), rate, handler);
        }

        @Override
        public void unregisterListener(SensorEventListener listener, int sensorType) {
            List sensors = this.mSensorManager.getSensorList(sensorType);
            if (sensors.isEmpty()) {
                return;
            }
            try {
                this.mSensorManager.unregisterListener(listener, (Sensor)sensors.get(0));
            }
            catch (IllegalArgumentException e) {
                Log.w(DeviceSensors.TAG, "Failed to unregister device sensor " + ((Sensor)sensors.get(0)).getName(), new Object[0]);
            }
        }
    }

    static interface SensorManagerProxy {
        public boolean registerListener(SensorEventListener var1, int var2, int var3, Handler var4);

        public void unregisterListener(SensorEventListener var1, int var2);
    }
}

