/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import java.util.ArrayList;
import java.util.List;
import org.chromium.base.PackageUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public class SpeechRecognition {
    private static final String PROVIDER_PACKAGE_NAME = "com.google.android.googlequicksearchbox";
    private static final int PROVIDER_MIN_VERSION = 300207030;
    private static final int STATE_IDLE = 0;
    private static final int STATE_AWAITING_SPEECH = 1;
    private static final int STATE_CAPTURING_SPEECH = 2;
    private int mState;
    private static ComponentName sRecognitionProvider;
    private final Context mContext;
    private final Intent mIntent;
    private final RecognitionListener mListener;
    private SpeechRecognizer mRecognizer;
    private long mNativeSpeechRecognizerImplAndroid;
    private boolean mContinuous;

    public static boolean initialize(Context context) {
        if (!SpeechRecognizer.isRecognitionAvailable((Context)context)) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent("android.speech.RecognitionService");
        List list = pm.queryIntentServices(intent, 4);
        for (ResolveInfo resolve : list) {
            ServiceInfo service = resolve.serviceInfo;
            if (!service.packageName.equals(PROVIDER_PACKAGE_NAME) || PackageUtils.getPackageVersion(context, service.packageName) < 300207030) continue;
            sRecognitionProvider = new ComponentName(service.packageName, service.name);
            return true;
        }
        return false;
    }

    private SpeechRecognition(Context context, long nativeSpeechRecognizerImplAndroid) {
        this.mContext = context;
        this.mContinuous = false;
        this.mNativeSpeechRecognizerImplAndroid = nativeSpeechRecognizerImplAndroid;
        this.mListener = new Listener();
        this.mIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mRecognizer = sRecognitionProvider != null ? SpeechRecognizer.createSpeechRecognizer((Context)this.mContext, (ComponentName)sRecognitionProvider) : SpeechRecognizer.createSpeechRecognizer((Context)this.mContext);
        this.mRecognizer.setRecognitionListener(this.mListener);
    }

    private void terminate(int error) {
        if (this.mState != 0) {
            if (this.mState == 2) {
                this.nativeOnSoundEnd(this.mNativeSpeechRecognizerImplAndroid);
            }
            this.nativeOnAudioEnd(this.mNativeSpeechRecognizerImplAndroid);
            this.mState = 0;
        }
        if (error != 0) {
            this.nativeOnRecognitionError(this.mNativeSpeechRecognizerImplAndroid, error);
        }
        this.mRecognizer.destroy();
        this.mRecognizer = null;
        this.nativeOnRecognitionEnd(this.mNativeSpeechRecognizerImplAndroid);
        this.mNativeSpeechRecognizerImplAndroid = 0L;
    }

    @CalledByNative
    private static SpeechRecognition createSpeechRecognition(Context context, long nativeSpeechRecognizerImplAndroid) {
        return new SpeechRecognition(context, nativeSpeechRecognizerImplAndroid);
    }

    @CalledByNative
    private void startRecognition(String language, boolean continuous, boolean interimResults) {
        if (this.mRecognizer == null) {
            return;
        }
        this.mContinuous = continuous;
        this.mIntent.putExtra("android.speech.extra.DICTATION_MODE", continuous);
        this.mIntent.putExtra("android.speech.extra.LANGUAGE", language);
        this.mIntent.putExtra("android.speech.extra.PARTIAL_RESULTS", interimResults);
        this.mRecognizer.startListening(this.mIntent);
    }

    @CalledByNative
    private void abortRecognition() {
        if (this.mRecognizer == null) {
            return;
        }
        this.mRecognizer.cancel();
        this.terminate(2);
    }

    @CalledByNative
    private void stopRecognition() {
        if (this.mRecognizer == null) {
            return;
        }
        this.mContinuous = false;
        this.mRecognizer.stopListening();
    }

    private native void nativeOnAudioStart(long var1);

    private native void nativeOnSoundStart(long var1);

    private native void nativeOnSoundEnd(long var1);

    private native void nativeOnAudioEnd(long var1);

    private native void nativeOnRecognitionResults(long var1, String[] var3, float[] var4, boolean var5);

    private native void nativeOnRecognitionError(long var1, int var3);

    private native void nativeOnRecognitionEnd(long var1);

    class Listener
    implements RecognitionListener {
        Listener() {
        }

        public void onBeginningOfSpeech() {
            SpeechRecognition.this.mState = 2;
            SpeechRecognition.this.nativeOnSoundStart(SpeechRecognition.this.mNativeSpeechRecognizerImplAndroid);
        }

        public void onBufferReceived(byte[] buffer) {
        }

        public void onEndOfSpeech() {
            if (!SpeechRecognition.this.mContinuous) {
                SpeechRecognition.this.nativeOnSoundEnd(SpeechRecognition.this.mNativeSpeechRecognizerImplAndroid);
                SpeechRecognition.this.nativeOnAudioEnd(SpeechRecognition.this.mNativeSpeechRecognizerImplAndroid);
                SpeechRecognition.this.mState = 0;
            }
        }

        public void onError(int error) {
            int code = 0;
            switch (error) {
                case 3: {
                    code = 3;
                    break;
                }
                case 5: {
                    code = 2;
                    break;
                }
                case 8: 
                case 9: {
                    code = 5;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    code = 4;
                    break;
                }
                case 7: {
                    code = 9;
                    break;
                }
                case 6: {
                    code = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            SpeechRecognition.this.terminate(code);
        }

        public void onEvent(int event, Bundle bundle) {
        }

        public void onPartialResults(Bundle bundle) {
            this.handleResults(bundle, true);
        }

        public void onReadyForSpeech(Bundle bundle) {
            SpeechRecognition.this.mState = 1;
            SpeechRecognition.this.nativeOnAudioStart(SpeechRecognition.this.mNativeSpeechRecognizerImplAndroid);
        }

        public void onResults(Bundle bundle) {
            this.handleResults(bundle, false);
            SpeechRecognition.this.terminate(0);
        }

        public void onRmsChanged(float rms) {
        }

        private void handleResults(Bundle bundle, boolean provisional) {
            if (SpeechRecognition.this.mContinuous && provisional) {
                provisional = false;
            }
            ArrayList list = bundle.getStringArrayList("results_recognition");
            String[] results = list.toArray(new String[list.size()]);
            float[] scores = bundle.getFloatArray("confidence_scores");
            SpeechRecognition.this.nativeOnRecognitionResults(SpeechRecognition.this.mNativeSpeechRecognizerImplAndroid, results, scores, provisional);
        }
    }
}

