/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import org.chromium.base.Log;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
class TimeZoneMonitor {
    private static final String TAG = "cr.TimeZoneMonitor";
    private final Context mAppContext;
    private final IntentFilter mFilter = new IntentFilter("android.intent.action.TIMEZONE_CHANGED");
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                Log.e(TimeZoneMonitor.TAG, "unexpected intent", new Object[0]);
                return;
            }
            TimeZoneMonitor.this.nativeTimeZoneChangedFromJava(TimeZoneMonitor.this.mNativePtr);
        }
    };
    private long mNativePtr;

    private TimeZoneMonitor(Context context, long nativePtr) {
        this.mAppContext = context.getApplicationContext();
        this.mNativePtr = nativePtr;
        this.mAppContext.registerReceiver(this.mBroadcastReceiver, this.mFilter);
    }

    @CalledByNative
    static TimeZoneMonitor getInstance(Context context, long nativePtr) {
        return new TimeZoneMonitor(context, nativePtr);
    }

    @CalledByNative
    void stop() {
        this.mAppContext.unregisterReceiver(this.mBroadcastReceiver);
        this.mNativePtr = 0L;
    }

    private native void nativeTimeZoneChangedFromJava(long var1);
}

