/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.accessibility.captioning;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.accessibility.CaptioningManager;
import java.util.Locale;
import org.chromium.content.browser.accessibility.captioning.CaptioningChangeDelegate;
import org.chromium.content.browser.accessibility.captioning.CaptioningStyle;
import org.chromium.content.browser.accessibility.captioning.SystemCaptioningBridge;

@TargetApi(value=19)
public class KitKatCaptioningBridge
implements SystemCaptioningBridge {
    private final CaptioningManager.CaptioningChangeListener mCaptioningChangeListener = new KitKatCaptioningChangeListener();
    private final CaptioningChangeDelegate mCaptioningChangeDelegate = new CaptioningChangeDelegate();
    private final CaptioningManager mCaptioningManager;
    private static KitKatCaptioningBridge sKitKatCaptioningBridge;

    public static KitKatCaptioningBridge getInstance(Context context) {
        if (sKitKatCaptioningBridge == null) {
            sKitKatCaptioningBridge = new KitKatCaptioningBridge(context);
        }
        return sKitKatCaptioningBridge;
    }

    private KitKatCaptioningBridge(Context context) {
        this.mCaptioningManager = (CaptioningManager)context.getApplicationContext().getSystemService("captioning");
    }

    private void syncToDelegate() {
        this.mCaptioningChangeDelegate.onEnabledChanged(this.mCaptioningManager.isEnabled());
        this.mCaptioningChangeDelegate.onFontScaleChanged(this.mCaptioningManager.getFontScale());
        this.mCaptioningChangeDelegate.onLocaleChanged(this.mCaptioningManager.getLocale());
        this.mCaptioningChangeDelegate.onUserStyleChanged(this.getCaptioningStyleFrom(this.mCaptioningManager.getUserStyle()));
    }

    @Override
    public void syncToListener(SystemCaptioningBridge.SystemCaptioningBridgeListener listener) {
        if (!this.mCaptioningChangeDelegate.hasActiveListener()) {
            this.syncToDelegate();
        }
        this.mCaptioningChangeDelegate.notifyListener(listener);
    }

    @Override
    public void addListener(SystemCaptioningBridge.SystemCaptioningBridgeListener listener) {
        if (!this.mCaptioningChangeDelegate.hasActiveListener()) {
            this.mCaptioningManager.addCaptioningChangeListener(this.mCaptioningChangeListener);
            this.syncToDelegate();
        }
        this.mCaptioningChangeDelegate.addListener(listener);
        this.mCaptioningChangeDelegate.notifyListener(listener);
    }

    @Override
    public void removeListener(SystemCaptioningBridge.SystemCaptioningBridgeListener listener) {
        this.mCaptioningChangeDelegate.removeListener(listener);
        if (!this.mCaptioningChangeDelegate.hasActiveListener()) {
            this.mCaptioningManager.removeCaptioningChangeListener(this.mCaptioningChangeListener);
        }
    }

    private CaptioningStyle getCaptioningStyleFrom(CaptioningManager.CaptionStyle userStyle) {
        return CaptioningStyle.createFrom(userStyle);
    }

    private class KitKatCaptioningChangeListener
    extends CaptioningManager.CaptioningChangeListener {
        private KitKatCaptioningChangeListener() {
        }

        public void onEnabledChanged(boolean enabled) {
            KitKatCaptioningBridge.this.mCaptioningChangeDelegate.onEnabledChanged(enabled);
        }

        public void onFontScaleChanged(float fontScale) {
            KitKatCaptioningBridge.this.mCaptioningChangeDelegate.onFontScaleChanged(fontScale);
        }

        public void onLocaleChanged(Locale locale) {
            KitKatCaptioningBridge.this.mCaptioningChangeDelegate.onLocaleChanged(locale);
        }

        public void onUserStyleChanged(CaptioningManager.CaptionStyle userStyle) {
            CaptioningStyle captioningStyle = KitKatCaptioningBridge.this.getCaptioningStyleFrom(userStyle);
            KitKatCaptioningBridge.this.mCaptioningChangeDelegate.onUserStyleChanged(captioningStyle);
        }
    }
}

