/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import org.chromium.base.VisibleForTesting;
import org.chromium.content.browser.input.ChromiumBaseInputConnection;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.ImeUtils;
import org.chromium.content.browser.input.InputMethodUma;

public class ReplicaInputConnection
extends BaseInputConnection
implements ChromiumBaseInputConnection {
    private static final String TAG = "cr_Ime";
    private static final boolean DEBUG_LOGS = false;
    public static final int INVALID_SELECTION = -1;
    public static final int INVALID_COMPOSITION = -1;
    private final ImeAdapter mImeAdapter;
    private final Editable mEditable;
    private boolean mSingleLine;
    private int mNumNestedBatchEdits = 0;
    private int mPendingAccent;
    private final Handler mHandler;

    @VisibleForTesting
    ReplicaInputConnection(View view, ImeAdapter imeAdapter, Handler handler, Editable editable, int inputType, int inputFlags, EditorInfo outAttrs) {
        super(view, true);
        this.mImeAdapter = imeAdapter;
        this.mEditable = editable;
        this.mHandler = handler;
        int initialSelStart = Selection.getSelectionStart((CharSequence)editable);
        int initialSelEnd = Selection.getSelectionEnd((CharSequence)editable);
        ImeUtils.computeEditorInfo(inputType, inputFlags, initialSelStart, initialSelEnd, outAttrs);
    }

    @Override
    public void updateStateOnUiThread(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean singleLine, boolean isNonImeChange) {
        this.mSingleLine = singleLine;
        if (!isNonImeChange) {
            return;
        }
        text = text.replace('\u00a0', ' ');
        selectionStart = Math.min(selectionStart, text.length());
        selectionEnd = Math.min(selectionEnd, text.length());
        compositionStart = Math.min(compositionStart, text.length());
        compositionEnd = Math.min(compositionEnd, text.length());
        String prevText = this.mEditable.toString();
        boolean textUnchanged = prevText.equals(text);
        if (!textUnchanged) {
            this.mEditable.replace(0, this.mEditable.length(), (CharSequence)text);
        }
        Selection.setSelection((Spannable)this.mEditable, (int)selectionStart, (int)selectionEnd);
        if (compositionStart == compositionEnd) {
            ReplicaInputConnection.removeComposingSpans((Spannable)this.mEditable);
        } else {
            super.setComposingRegion(compositionStart, compositionEnd);
        }
        this.updateSelectionIfRequired();
    }

    public Editable getEditable() {
        return this.mEditable;
    }

    private void updateSelectionIfRequired() {
        if (this.mNumNestedBatchEdits != 0) {
            return;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = ReplicaInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = ReplicaInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        this.mImeAdapter.updateSelection(selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        return this.updateComposingText(text, newCursorPosition, false);
    }

    private boolean updateComposingText(CharSequence text, int newCursorPosition, boolean isPendingAccent) {
        int accentToSend = isPendingAccent ? this.mPendingAccent : 0;
        this.mPendingAccent = 0;
        super.setComposingText(text, newCursorPosition);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.sendCompositionToNative(text, newCursorPosition, false, accentToSend);
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        this.mPendingAccent = 0;
        super.commitText(text, newCursorPosition);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.sendCompositionToNative(text, newCursorPosition, text.length() > 0, 0);
    }

    public boolean performEditorAction(int actionCode) {
        return this.mImeAdapter.performEditorAction(actionCode);
    }

    public boolean performContextMenuAction(int id2) {
        return this.mImeAdapter.performContextMenuAction(id2);
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText et = new ExtractedText();
        et.text = this.mEditable.toString();
        et.partialEndOffset = this.mEditable.length();
        et.selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        et.selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        et.flags = this.mSingleLine ? 1 : 0;
        return et;
    }

    public boolean beginBatchEdit() {
        ++this.mNumNestedBatchEdits;
        return true;
    }

    public boolean endBatchEdit() {
        if (this.mNumNestedBatchEdits == 0) {
            return false;
        }
        --this.mNumNestedBatchEdits;
        if (this.mNumNestedBatchEdits == 0) {
            this.updateSelectionIfRequired();
        }
        return this.mNumNestedBatchEdits != 0;
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        return this.deleteSurroundingTextImpl(beforeLength, afterLength, false);
    }

    @VisibleForTesting
    static boolean isIndexBetweenUtf16SurrogatePair(CharSequence str, int index) {
        return index > 0 && index < str.length() && Character.isHighSurrogate(str.charAt(index - 1)) && Character.isLowSurrogate(str.charAt(index));
    }

    private boolean deleteSurroundingTextImpl(int beforeLength, int afterLength, boolean fromPhysicalKey) {
        if (this.mPendingAccent != 0) {
            this.finishComposingText();
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int availableBefore = selectionStart;
        int availableAfter = this.mEditable.length() - selectionEnd;
        beforeLength = Math.min(beforeLength, availableBefore);
        afterLength = Math.min(afterLength, availableAfter);
        if (ReplicaInputConnection.isIndexBetweenUtf16SurrogatePair((CharSequence)this.mEditable, selectionStart - beforeLength)) {
            ++beforeLength;
        }
        if (ReplicaInputConnection.isIndexBetweenUtf16SurrogatePair((CharSequence)this.mEditable, selectionEnd + afterLength)) {
            ++afterLength;
        }
        super.deleteSurroundingText(beforeLength, afterLength);
        this.updateSelectionIfRequired();
        if (fromPhysicalKey) {
            return true;
        }
        return this.mImeAdapter.deleteSurroundingText(beforeLength, afterLength);
    }

    @Override
    public boolean sendKeyEventOnUiThread(KeyEvent event) {
        return this.sendKeyEvent(event);
    }

    public boolean sendKeyEvent(KeyEvent event) {
        int action = event.getAction();
        int keycode = event.getKeyCode();
        int unicodeChar = event.getUnicodeChar();
        if (action != 0) {
            this.mImeAdapter.sendKeyEvent(event);
            return true;
        }
        if (keycode == 67) {
            this.deleteSurroundingTextImpl(1, 0, true);
        } else if (keycode == 112) {
            this.deleteSurroundingTextImpl(0, 1, true);
        } else if (keycode == 66) {
            this.finishComposingText();
        } else {
            if ((unicodeChar & Integer.MIN_VALUE) != 0) {
                int pendingAccent = unicodeChar & Integer.MAX_VALUE;
                StringBuilder builder = new StringBuilder();
                builder.appendCodePoint(pendingAccent);
                this.updateComposingText(builder.toString(), 1, true);
                this.mPendingAccent = pendingAccent;
                return true;
            }
            if (this.mPendingAccent != 0 && unicodeChar != 0) {
                int combined = KeyEvent.getDeadChar((int)this.mPendingAccent, (int)unicodeChar);
                if (combined != 0) {
                    StringBuilder builder = new StringBuilder();
                    builder.appendCodePoint(combined);
                    this.commitText(builder.toString(), 1);
                    return true;
                }
                this.finishComposingText();
            }
        }
        this.replaceSelectionWithUnicodeChar(unicodeChar);
        this.mImeAdapter.sendKeyEvent(event);
        return true;
    }

    private void replaceSelectionWithUnicodeChar(int unicodeChar) {
        int selectionEnd;
        if (unicodeChar == 0) {
            return;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        if (selectionStart > (selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable))) {
            int temp = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = temp;
        }
        this.mEditable.replace(selectionStart, selectionEnd, (CharSequence)Character.toString((char)unicodeChar));
        this.updateSelectionIfRequired();
    }

    public boolean finishComposingText() {
        this.mPendingAccent = 0;
        if (ReplicaInputConnection.getComposingSpanStart((Spannable)this.mEditable) == ReplicaInputConnection.getComposingSpanEnd((Spannable)this.mEditable)) {
            return true;
        }
        super.finishComposingText();
        this.updateSelectionIfRequired();
        this.mImeAdapter.finishComposingText();
        return true;
    }

    public boolean setSelection(int start, int end) {
        int textLength = this.mEditable.length();
        if (start < 0 || end < 0 || start > textLength || end > textLength) {
            return true;
        }
        super.setSelection(start, end);
        this.updateSelectionIfRequired();
        return this.mImeAdapter.setEditableSelectionOffsets(start, end);
    }

    public boolean setComposingRegion(int start, int end) {
        int textLength = this.mEditable.length();
        int a = Math.min(start, end);
        int b = Math.max(start, end);
        if (a < 0) {
            a = 0;
        }
        if (b < 0) {
            b = 0;
        }
        if (a > textLength) {
            a = textLength;
        }
        if (b > textLength) {
            b = textLength;
        }
        if (a == b) {
            ReplicaInputConnection.removeComposingSpans((Spannable)this.mEditable);
        } else {
            super.setComposingRegion(a, b);
        }
        this.updateSelectionIfRequired();
        return this.mImeAdapter.setComposingRegion(a, b);
    }

    @Override
    public void onRestartInputOnUiThread() {
        this.mNumNestedBatchEdits = 0;
        this.mPendingAccent = 0;
    }

    @Override
    public void moveCursorToSelectionEndOnUiThread() {
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        this.setSelection(selectionEnd, selectionEnd);
    }

    @Override
    public void unblockOnUiThread() {
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @TargetApi(value=21)
    public boolean requestCursorUpdates(int cursorUpdateMode) {
        return this.mImeAdapter.onRequestCursorUpdates(cursorUpdateMode);
    }

    @VisibleForTesting
    ImeState getImeStateForTesting() {
        String text = this.mEditable.toString();
        int selectionStart = Selection.getSelectionStart((CharSequence)this.mEditable);
        int selectionEnd = Selection.getSelectionEnd((CharSequence)this.mEditable);
        int compositionStart = ReplicaInputConnection.getComposingSpanStart((Spannable)this.mEditable);
        int compositionEnd = ReplicaInputConnection.getComposingSpanEnd((Spannable)this.mEditable);
        return new ImeState(text, selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    @VisibleForTesting
    static class ImeState {
        public final String text;
        public final int selectionStart;
        public final int selectionEnd;
        public final int compositionStart;
        public final int compositionEnd;

        public ImeState(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
            this.text = text;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
            this.compositionStart = compositionStart;
            this.compositionEnd = compositionEnd;
        }
    }

    static class Factory
    implements ChromiumBaseInputConnection.Factory {
        private final Editable mEditable;
        private final Handler mHandler = new Handler(Looper.getMainLooper());

        Factory() {
            this.mEditable = Editable.Factory.getInstance().newEditable((CharSequence)"");
            Selection.setSelection((Spannable)this.mEditable, (int)0);
        }

        @Override
        public ReplicaInputConnection initializeAndGet(View view, ImeAdapter imeAdapter, int inputType, int inputFlags, int selectionStart, int selectionEnd, EditorInfo outAttrs) {
            new InputMethodUma().recordProxyViewReplicaInputConnection();
            return new ReplicaInputConnection(view, imeAdapter, this.mHandler, this.mEditable, inputType, inputFlags, outAttrs);
        }

        @Override
        public Handler getHandler() {
            return this.mHandler;
        }

        @Override
        public void onWindowFocusChanged(boolean gainFocus) {
        }

        @Override
        public void onViewFocusChanged(boolean gainFocus) {
        }

        @Override
        public void onViewAttachedToWindow() {
        }

        @Override
        public void onViewDetachedFromWindow() {
        }
    }
}

