/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.common;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import org.chromium.base.Log;
import org.chromium.base.ThreadUtils;
import org.chromium.base.TraceEvent;

public class CleanupReference
extends WeakReference<Object> {
    private static final String TAG = "cr.CleanupReference";
    private static final boolean DEBUG = false;
    private static ReferenceQueue<Object> sGcQueue = new ReferenceQueue();
    private static Object sCleanupMonitor = new Object();
    private static final Thread sReaperThread = new Thread("cr.CleanupReference"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CleanupReference ref = (CleanupReference)sGcQueue.remove();
                        Object object = sCleanupMonitor;
                        synchronized (object) {
                            Message.obtain((Handler)LazyHolder.sHandler, (int)2, (Object)ref).sendToTarget();
                            sCleanupMonitor.wait(500L);
                        }
                    }
                }
                catch (Exception e) {
                    Log.e(CleanupReference.TAG, "Queue remove exception:", e);
                    continue;
                }
                break;
            }
        }
    };
    private static final int ADD_REF = 1;
    private static final int REMOVE_REF = 2;
    private static Set<CleanupReference> sRefs;
    private Runnable mCleanupTask;

    public CleanupReference(Object obj, Runnable cleanupTask) {
        super(obj, sGcQueue);
        this.mCleanupTask = cleanupTask;
        this.handleOnUiThread(1);
    }

    public void cleanupNow() {
        this.handleOnUiThread(2);
    }

    private void handleOnUiThread(int what) {
        Message msg = Message.obtain((Handler)LazyHolder.sHandler, (int)what, (Object)this);
        if (Looper.myLooper() == msg.getTarget().getLooper()) {
            msg.getTarget().handleMessage(msg);
            msg.recycle();
        } else {
            msg.sendToTarget();
        }
    }

    private void runCleanupTaskInternal() {
        sRefs.remove(this);
        if (this.mCleanupTask != null) {
            this.mCleanupTask.run();
            this.mCleanupTask = null;
        }
        this.clear();
    }

    static {
        sReaperThread.setDaemon(true);
        sReaperThread.start();
        sRefs = new HashSet<CleanupReference>();
    }

    private static class LazyHolder {
        static final Handler sHandler = new Handler(ThreadUtils.getUiThreadLooper()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                try {
                    TraceEvent.begin("CleanupReference.LazyHolder.handleMessage");
                    CleanupReference ref = (CleanupReference)msg.obj;
                    switch (msg.what) {
                        case 1: {
                            sRefs.add(ref);
                            break;
                        }
                        case 2: {
                            ref.runCleanupTaskInternal();
                            break;
                        }
                        default: {
                            Log.e(CleanupReference.TAG, "Bad message=%d", msg.what);
                        }
                    }
                    Object object = sCleanupMonitor;
                    synchronized (object) {
                        while ((ref = (CleanupReference)sGcQueue.poll()) != null) {
                            ref.runCleanupTaskInternal();
                        }
                        sCleanupMonitor.notifyAll();
                    }
                }
                finally {
                    TraceEvent.end("CleanupReference.LazyHolder.handleMessage");
                }
            }
        };

        private LazyHolder() {
        }
    }
}

