/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content_public.common;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;

@JNINamespace(value="content")
public class MediaMetadata {
    @NonNull
    private String mTitle;
    @NonNull
    private String mArtist;
    @NonNull
    private String mAlbum;

    public String getTitle() {
        return this.mTitle;
    }

    public String getArtist() {
        return this.mArtist;
    }

    public String getAlbum() {
        return this.mAlbum;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setArtist(String artist) {
        this.mArtist = artist;
    }

    public void setAlbum(String album) {
        this.mAlbum = album;
    }

    @CalledByNative
    private static MediaMetadata create(String title, String artist, String album) {
        return new MediaMetadata(title == null ? "" : title, artist == null ? "" : artist, album == null ? "" : album);
    }

    public MediaMetadata(@NonNull String title, @NonNull String artist, @NonNull String album) {
        this.mTitle = title;
        this.mArtist = artist;
        this.mAlbum = album;
    }

    public MediaMetadata(MediaMetadata other) {
        this(other.mTitle, other.mArtist, other.mAlbum);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MediaMetadata)) {
            return false;
        }
        MediaMetadata other = (MediaMetadata)obj;
        return TextUtils.equals((CharSequence)this.mTitle, (CharSequence)other.mTitle) && TextUtils.equals((CharSequence)this.mArtist, (CharSequence)other.mArtist) && TextUtils.equals((CharSequence)this.mAlbum, (CharSequence)other.mAlbum);
    }

    public int hashCode() {
        int result = this.mTitle.hashCode();
        result = 31 * result + this.mArtist.hashCode();
        result = 31 * result + this.mAlbum.hashCode();
        return result;
    }
}

