/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.mojo.bindings;

import org.chromium.mojo.bindings.DataHeader;
import org.chromium.mojo.bindings.Decoder;
import org.chromium.mojo.bindings.Encoder;
import org.chromium.mojo.bindings.Message;
import org.chromium.mojo.bindings.Struct;

public final class QueryVersion
extends Struct {
    private static final int STRUCT_SIZE = 8;
    private static final DataHeader[] VERSION_ARRAY = new DataHeader[]{new DataHeader(8, 0)};
    private static final DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    private QueryVersion(int version) {
        super(8, version);
    }

    public QueryVersion() {
        this(0);
    }

    public static QueryVersion deserialize(Message message) {
        return QueryVersion.decode(new Decoder(message));
    }

    public static QueryVersion decode(Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        QueryVersion result = new QueryVersion(mainDataHeader.elementsOrVersion);
        return result;
    }

    @Override
    protected final void encode(Encoder encoder) {
        encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.getClass().hashCode();
        return result;
    }
}

