/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.net;

import android.content.Context;
import java.util.ArrayList;
import org.chromium.base.ObserverList;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.NativeClassQualifiedName;
import org.chromium.net.NetworkChangeNotifierAutoDetect;
import org.chromium.net.RegistrationPolicyAlwaysRegister;
import org.chromium.net.RegistrationPolicyApplicationStatus;

@JNINamespace(value="net")
public class NetworkChangeNotifier {
    private final Context mContext;
    private final ArrayList<Long> mNativeChangeNotifiers;
    private final ObserverList<ConnectionTypeObserver> mConnectionTypeObservers;
    private NetworkChangeNotifierAutoDetect mAutoDetector;
    private int mCurrentConnectionType = 0;
    private double mCurrentMaxBandwidth = Double.POSITIVE_INFINITY;
    private int mMaxBandwidthConnectionType = this.mCurrentConnectionType;
    private static NetworkChangeNotifier sInstance;

    @VisibleForTesting
    protected NetworkChangeNotifier(Context context) {
        this.mContext = context.getApplicationContext();
        this.mNativeChangeNotifiers = new ArrayList();
        this.mConnectionTypeObservers = new ObserverList();
    }

    @CalledByNative
    public static NetworkChangeNotifier init(Context context) {
        if (sInstance == null) {
            sInstance = new NetworkChangeNotifier(context);
        }
        return sInstance;
    }

    public static boolean isInitialized() {
        return sInstance != null;
    }

    static void resetInstanceForTests(NetworkChangeNotifier notifier) {
        sInstance = notifier;
    }

    @CalledByNative
    public int getCurrentConnectionType() {
        return this.mCurrentConnectionType;
    }

    @CalledByNative
    public int getCurrentConnectionSubtype() {
        return this.mAutoDetector == null ? 0 : this.mAutoDetector.getCurrentConnectionSubtype(this.mAutoDetector.getCurrentNetworkState());
    }

    @CalledByNative
    public double getCurrentMaxBandwidthInMbps() {
        return this.mCurrentMaxBandwidth;
    }

    @CalledByNative
    public int getCurrentDefaultNetId() {
        return this.mAutoDetector == null ? -1 : this.mAutoDetector.getDefaultNetId();
    }

    @CalledByNative
    public int[] getCurrentNetworksAndTypes() {
        return this.mAutoDetector == null ? new int[]{} : this.mAutoDetector.getNetworksAndTypes();
    }

    public static double getMaxBandwidthForConnectionSubtype(int subtype) {
        return NetworkChangeNotifier.nativeGetMaxBandwidthForConnectionSubtype(subtype);
    }

    @CalledByNative
    public void addNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.add(nativeChangeNotifier);
    }

    @CalledByNative
    public void removeNativeObserver(long nativeChangeNotifier) {
        this.mNativeChangeNotifiers.remove(nativeChangeNotifier);
    }

    public static NetworkChangeNotifier getInstance() {
        assert (sInstance != null);
        return sInstance;
    }

    public static void setAutoDetectConnectivityState(boolean shouldAutoDetect) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(shouldAutoDetect, new RegistrationPolicyApplicationStatus());
    }

    public static void registerToReceiveNotificationsAlways() {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, new RegistrationPolicyAlwaysRegister());
    }

    public static void setAutoDetectConnectivityState(NetworkChangeNotifierAutoDetect.RegistrationPolicy policy) {
        NetworkChangeNotifier.getInstance().setAutoDetectConnectivityStateInternal(true, policy);
    }

    private void destroyAutoDetector() {
        if (this.mAutoDetector != null) {
            this.mAutoDetector.destroy();
            this.mAutoDetector = null;
        }
    }

    private void setAutoDetectConnectivityStateInternal(boolean shouldAutoDetect, NetworkChangeNotifierAutoDetect.RegistrationPolicy policy) {
        if (shouldAutoDetect) {
            if (this.mAutoDetector == null) {
                this.mAutoDetector = new NetworkChangeNotifierAutoDetect(new NetworkChangeNotifierAutoDetect.Observer(){

                    @Override
                    public void onConnectionTypeChanged(int newConnectionType) {
                        NetworkChangeNotifier.this.updateCurrentConnectionType(newConnectionType);
                    }

                    @Override
                    public void onMaxBandwidthChanged(double maxBandwidthMbps) {
                        NetworkChangeNotifier.this.updateCurrentMaxBandwidth(maxBandwidthMbps);
                    }

                    @Override
                    public void onNetworkConnect(int netId, int connectionType) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkConnect(netId, connectionType);
                    }

                    @Override
                    public void onNetworkSoonToDisconnect(int netId) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkSoonToDisconnect(netId);
                    }

                    @Override
                    public void onNetworkDisconnect(int netId) {
                        NetworkChangeNotifier.this.notifyObserversOfNetworkDisconnect(netId);
                    }

                    @Override
                    public void purgeActiveNetworkList(int[] activeNetIds) {
                        NetworkChangeNotifier.this.notifyObserversToPurgeActiveNetworkList(activeNetIds);
                    }
                }, this.mContext, policy);
                NetworkChangeNotifierAutoDetect.NetworkState networkState = this.mAutoDetector.getCurrentNetworkState();
                this.updateCurrentConnectionType(this.mAutoDetector.getCurrentConnectionType(networkState));
                this.updateCurrentMaxBandwidth(this.mAutoDetector.getCurrentMaxBandwidthInMbps(networkState));
            }
        } else {
            this.destroyAutoDetector();
        }
    }

    @CalledByNative
    public static void forceConnectivityState(boolean networkAvailable) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().forceConnectivityStateInternal(networkAvailable);
    }

    private void forceConnectivityStateInternal(boolean forceOnline) {
        boolean connectionCurrentlyExists;
        boolean bl = connectionCurrentlyExists = this.mCurrentConnectionType != 6;
        if (connectionCurrentlyExists != forceOnline) {
            this.updateCurrentConnectionType(forceOnline ? 0 : 6);
            this.updateCurrentMaxBandwidth(forceOnline ? Double.POSITIVE_INFINITY : 0.0);
        }
    }

    @CalledByNative
    public static void fakeNetworkConnected(int netId, int connectionType) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkConnect(netId, connectionType);
    }

    @CalledByNative
    public static void fakeNetworkSoonToBeDisconnected(int netId) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkSoonToDisconnect(netId);
    }

    @CalledByNative
    public static void fakeNetworkDisconnected(int netId) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfNetworkDisconnect(netId);
    }

    @CalledByNative
    public static void fakePurgeActiveNetworkList(int[] activeNetIds) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversToPurgeActiveNetworkList(activeNetIds);
    }

    @CalledByNative
    public static void fakeDefaultNetwork(int netId, int connectionType) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfConnectionTypeChange(connectionType, netId);
    }

    @CalledByNative
    public static void fakeMaxBandwidthChanged(double maxBandwidthMbps) {
        NetworkChangeNotifier.setAutoDetectConnectivityState(false);
        NetworkChangeNotifier.getInstance().notifyObserversOfMaxBandwidthChange(maxBandwidthMbps);
    }

    private void updateCurrentConnectionType(int newConnectionType) {
        this.mCurrentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange(newConnectionType);
    }

    private void updateCurrentMaxBandwidth(double maxBandwidthMbps) {
        if (maxBandwidthMbps == this.mCurrentMaxBandwidth && this.mCurrentConnectionType == this.mMaxBandwidthConnectionType) {
            return;
        }
        this.mCurrentMaxBandwidth = maxBandwidthMbps;
        this.mMaxBandwidthConnectionType = this.mCurrentConnectionType;
        this.notifyObserversOfMaxBandwidthChange(maxBandwidthMbps);
    }

    void notifyObserversOfConnectionTypeChange(int newConnectionType) {
        this.notifyObserversOfConnectionTypeChange(newConnectionType, this.getCurrentDefaultNetId());
    }

    private void notifyObserversOfConnectionTypeChange(int newConnectionType, int defaultNetId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyConnectionTypeChanged(nativeChangeNotifier, newConnectionType, defaultNetId);
        }
        for (ConnectionTypeObserver observer : this.mConnectionTypeObservers) {
            observer.onConnectionTypeChanged(newConnectionType);
        }
    }

    void notifyObserversOfMaxBandwidthChange(double maxBandwidthMbps) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyMaxBandwidthChanged(nativeChangeNotifier, maxBandwidthMbps);
        }
    }

    void notifyObserversOfNetworkConnect(int netId, int connectionType) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyOfNetworkConnect(nativeChangeNotifier, netId, connectionType);
        }
    }

    void notifyObserversOfNetworkSoonToDisconnect(int netId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyOfNetworkSoonToDisconnect(nativeChangeNotifier, netId);
        }
    }

    void notifyObserversOfNetworkDisconnect(int netId) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyOfNetworkDisconnect(nativeChangeNotifier, netId);
        }
    }

    void notifyObserversToPurgeActiveNetworkList(int[] activeNetIds) {
        for (Long nativeChangeNotifier : this.mNativeChangeNotifiers) {
            this.nativeNotifyPurgeActiveNetworkList(nativeChangeNotifier, activeNetIds);
        }
    }

    public static void addConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().addConnectionTypeObserverInternal(observer);
    }

    private void addConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.addObserver(observer);
    }

    public static void removeConnectionTypeObserver(ConnectionTypeObserver observer) {
        NetworkChangeNotifier.getInstance().removeConnectionTypeObserverInternal(observer);
    }

    private void removeConnectionTypeObserverInternal(ConnectionTypeObserver observer) {
        this.mConnectionTypeObservers.removeObserver(observer);
    }

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyConnectionTypeChanged(long var1, int var3, int var4);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyMaxBandwidthChanged(long var1, double var3);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyOfNetworkConnect(long var1, int var3, int var4);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyOfNetworkSoonToDisconnect(long var1, int var3);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyOfNetworkDisconnect(long var1, int var3);

    @NativeClassQualifiedName(value="NetworkChangeNotifierDelegateAndroid")
    private native void nativeNotifyPurgeActiveNetworkList(long var1, int[] var3);

    private static native double nativeGetMaxBandwidthForConnectionSubtype(int var0);

    public static NetworkChangeNotifierAutoDetect getAutoDetectorForTest() {
        return NetworkChangeNotifier.getInstance().mAutoDetector;
    }

    public static boolean isOnline() {
        int connectionType = NetworkChangeNotifier.getInstance().getCurrentConnectionType();
        return connectionType != 6;
    }

    public static interface ConnectionTypeObserver {
        public void onConnectionTypeChanged(int var1);
    }
}

