/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import android.view.WindowManager;
import org.chromium.base.TraceEvent;

public class VSyncMonitor {
    private static final long NANOSECONDS_PER_SECOND = 1000000000L;
    private static final long NANOSECONDS_PER_MICROSECOND = 1000L;
    private boolean mInsideVSync = false;
    private boolean mConsecutiveVSync = false;
    private Listener mListener;
    private long mRefreshPeriodNano;
    private boolean mHaveRequestInFlight;
    private final Choreographer mChoreographer;
    private final Choreographer.FrameCallback mVSyncFrameCallback;
    private long mGoodStartingPointNano;
    private final Handler mHandler = new Handler();

    public VSyncMonitor(Context context, Listener listener) {
        boolean useEstimatedRefreshPeriod;
        this.mListener = listener;
        float refreshRate = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRefreshRate();
        boolean bl = useEstimatedRefreshPeriod = refreshRate < 30.0f;
        if (refreshRate <= 0.0f) {
            refreshRate = 60.0f;
        }
        this.mRefreshPeriodNano = (long)(1.0E9f / refreshRate);
        this.mChoreographer = Choreographer.getInstance();
        this.mVSyncFrameCallback = new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                TraceEvent.begin("VSync");
                if (useEstimatedRefreshPeriod && VSyncMonitor.this.mConsecutiveVSync) {
                    long lastRefreshDurationNano = frameTimeNanos - VSyncMonitor.this.mGoodStartingPointNano;
                    float lastRefreshDurationWeight = 0.1f;
                    VSyncMonitor.this.mRefreshPeriodNano += (long)(lastRefreshDurationWeight * (float)(lastRefreshDurationNano - VSyncMonitor.this.mRefreshPeriodNano));
                }
                VSyncMonitor.this.mGoodStartingPointNano = frameTimeNanos;
                VSyncMonitor.this.onVSyncCallback(frameTimeNanos, VSyncMonitor.this.getCurrentNanoTime());
                TraceEvent.end("VSync");
            }
        };
        this.mGoodStartingPointNano = this.getCurrentNanoTime();
    }

    public long getVSyncPeriodInMicroseconds() {
        return this.mRefreshPeriodNano / 1000L;
    }

    public void requestUpdate() {
        assert (this.mHandler.getLooper() == Looper.myLooper());
        this.postCallback();
    }

    public boolean isInsideVSync() {
        return this.mInsideVSync;
    }

    private long getCurrentNanoTime() {
        return System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onVSyncCallback(long frameTimeNanos, long currentTimeNanos) {
        assert (this.mHaveRequestInFlight);
        this.mInsideVSync = true;
        this.mHaveRequestInFlight = false;
        try {
            if (this.mListener != null) {
                this.mListener.onVSync(this, frameTimeNanos / 1000L);
            }
        }
        finally {
            this.mInsideVSync = false;
        }
    }

    private void postCallback() {
        if (this.mHaveRequestInFlight) {
            return;
        }
        this.mHaveRequestInFlight = true;
        this.mConsecutiveVSync = this.mInsideVSync;
        this.mChoreographer.postFrameCallback(this.mVSyncFrameCallback);
    }

    public static interface Listener {
        public void onVSync(VSyncMonitor var1, long var2);
    }
}

