/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.base;

import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chromium.base.ContentUriUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.base.VisibleForTesting;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.chromium.base.annotations.MainDex;
import org.chromium.ui.R;
import org.chromium.ui.UiUtils;
import org.chromium.ui.base.WindowAndroid;

@JNINamespace(value="ui")
@MainDex
public class SelectFileDialog
implements WindowAndroid.IntentCallback,
WindowAndroid.PermissionCallback {
    private static final String TAG = "SelectFileDialog";
    private static final String IMAGE_TYPE = "image/";
    private static final String VIDEO_TYPE = "video/";
    private static final String AUDIO_TYPE = "audio/";
    private static final String ALL_IMAGE_TYPES = "image/*";
    private static final String ALL_VIDEO_TYPES = "video/*";
    private static final String ALL_AUDIO_TYPES = "audio/*";
    private static final String ANY_TYPES = "*/*";
    private static WindowAndroid sOverrideWindowAndroid = null;
    private final long mNativeSelectFileDialog;
    private List<String> mFileTypes;
    private boolean mCapture;
    private boolean mAllowMultiple;
    private Uri mCameraOutputUri;
    private WindowAndroid mWindowAndroid;
    private boolean mSupportsImageCapture;
    private boolean mSupportsVideoCapture;
    private boolean mSupportsAudioCapture;

    private SelectFileDialog(long nativeSelectFileDialog) {
        this.mNativeSelectFileDialog = nativeSelectFileDialog;
    }

    @VisibleForTesting
    public static void setWindowAndroidForTests(WindowAndroid window) {
        sOverrideWindowAndroid = window;
    }

    @TargetApi(value=18)
    @CalledByNative
    private void selectFile(String[] fileTypes, boolean capture, boolean multiple, WindowAndroid window) {
        this.mFileTypes = new ArrayList<String>(Arrays.asList(fileTypes));
        this.mCapture = capture;
        this.mAllowMultiple = multiple;
        this.mWindowAndroid = sOverrideWindowAndroid == null ? window : sOverrideWindowAndroid;
        this.mSupportsImageCapture = this.mWindowAndroid.canResolveActivity(new Intent("android.media.action.IMAGE_CAPTURE"));
        this.mSupportsVideoCapture = this.mWindowAndroid.canResolveActivity(new Intent("android.media.action.VIDEO_CAPTURE"));
        this.mSupportsAudioCapture = this.mWindowAndroid.canResolveActivity(new Intent("android.provider.MediaStore.RECORD_SOUND"));
        ArrayList<String> missingPermissions = new ArrayList<String>();
        if ((this.mSupportsImageCapture && this.shouldShowImageTypes() || this.mSupportsVideoCapture && this.shouldShowVideoTypes()) && !window.hasPermission("android.permission.CAMERA")) {
            missingPermissions.add("android.permission.CAMERA");
        }
        if (this.mSupportsAudioCapture && this.shouldShowAudioTypes() && !window.hasPermission("android.permission.RECORD_AUDIO")) {
            missingPermissions.add("android.permission.RECORD_AUDIO");
        }
        if (missingPermissions.isEmpty()) {
            this.launchSelectFileIntent();
        } else {
            window.requestPermissions(missingPermissions.toArray(new String[missingPermissions.size()]), this);
        }
    }

    private void launchSelectFileIntent() {
        boolean hasCameraPermission = this.mWindowAndroid.hasPermission("android.permission.CAMERA");
        if (this.mSupportsImageCapture && hasCameraPermission) {
            new GetCameraIntentTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            this.launchSelectFileWithCameraIntent(hasCameraPermission, null);
        }
    }

    private void launchSelectFileWithCameraIntent(boolean hasCameraPermission, Intent camera) {
        Intent camcorder = null;
        if (this.mSupportsVideoCapture && hasCameraPermission) {
            camcorder = new Intent("android.media.action.VIDEO_CAPTURE");
        }
        boolean hasAudioPermission = this.mWindowAndroid.hasPermission("android.permission.RECORD_AUDIO");
        Intent soundRecorder = null;
        if (this.mSupportsAudioCapture && hasAudioPermission) {
            soundRecorder = new Intent("android.provider.MediaStore.RECORD_SOUND");
        }
        if (this.captureCamera() && camera != null ? this.mWindowAndroid.showIntent(camera, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error) : (this.captureCamcorder() && camcorder != null ? this.mWindowAndroid.showIntent(camcorder, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error) : this.captureMicrophone() && soundRecorder != null && this.mWindowAndroid.showIntent(soundRecorder, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error))) {
            return;
        }
        Intent getContentIntent = new Intent("android.intent.action.GET_CONTENT");
        getContentIntent.addCategory("android.intent.category.OPENABLE");
        if (Build.VERSION.SDK_INT >= 18 && this.mAllowMultiple) {
            getContentIntent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        ArrayList<Intent> extraIntents = new ArrayList<Intent>();
        if (!this.noSpecificType()) {
            if (this.shouldShowImageTypes()) {
                if (camera != null) {
                    extraIntents.add(camera);
                }
                getContentIntent.setType(ALL_IMAGE_TYPES);
            } else if (this.shouldShowVideoTypes()) {
                if (camcorder != null) {
                    extraIntents.add(camcorder);
                }
                getContentIntent.setType(ALL_VIDEO_TYPES);
            } else if (this.shouldShowAudioTypes()) {
                if (soundRecorder != null) {
                    extraIntents.add(soundRecorder);
                }
                getContentIntent.setType(ALL_AUDIO_TYPES);
            }
        }
        if (extraIntents.isEmpty()) {
            getContentIntent.setType(ANY_TYPES);
            if (camera != null) {
                extraIntents.add(camera);
            }
            if (camcorder != null) {
                extraIntents.add(camcorder);
            }
            if (soundRecorder != null) {
                extraIntents.add(soundRecorder);
            }
        }
        Intent chooser = new Intent("android.intent.action.CHOOSER");
        if (!extraIntents.isEmpty()) {
            chooser.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])extraIntents.toArray(new Intent[0]));
        }
        chooser.putExtra("android.intent.extra.INTENT", (Parcelable)getContentIntent);
        if (!this.mWindowAndroid.showIntent(chooser, (WindowAndroid.IntentCallback)this, (Integer)R.string.low_memory_error)) {
            this.onFileNotSelected();
        }
    }

    private File getFileForImageCapture(Context context) throws IOException {
        assert (!ThreadUtils.runningOnUiThread());
        File photoFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".jpg", UiUtils.getDirectoryForImageCapture(context));
        return photoFile;
    }

    @Override
    @TargetApi(value=18)
    public void onIntentCompleted(WindowAndroid window, int resultCode, ContentResolver contentResolver, Intent results) {
        if (resultCode != -1) {
            this.onFileNotSelected();
            return;
        }
        if (results == null || results.getData() == null && (Build.VERSION.SDK_INT < 18 || results.getClipData() == null)) {
            String path = "file".equals(this.mCameraOutputUri.getScheme()) ? this.mCameraOutputUri.getPath() : this.mCameraOutputUri.toString();
            this.nativeOnFileSelected(this.mNativeSelectFileDialog, path, this.mCameraOutputUri.getLastPathSegment());
            window.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", this.mCameraOutputUri));
            return;
        }
        if (Build.VERSION.SDK_INT >= 18 && results.getData() == null && results.getClipData() != null) {
            ClipData clipData = results.getClipData();
            int itemCount = clipData.getItemCount();
            if (itemCount == 0) {
                this.onFileNotSelected();
                return;
            }
            Object[] filePathArray = new Uri[itemCount];
            for (int i = 0; i < itemCount; ++i) {
                filePathArray[i] = clipData.getItemAt(i).getUri();
            }
            GetDisplayNameTask task = new GetDisplayNameTask(contentResolver, true);
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, filePathArray);
            return;
        }
        if ("file".equals(results.getData().getScheme())) {
            this.nativeOnFileSelected(this.mNativeSelectFileDialog, results.getData().getSchemeSpecificPart(), "");
            return;
        }
        if ("content".equals(results.getScheme())) {
            GetDisplayNameTask task = new GetDisplayNameTask(contentResolver, false);
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Uri[]{results.getData()});
            return;
        }
        this.onFileNotSelected();
        window.showError(R.string.opening_file_error);
    }

    @Override
    public void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != -1 || !this.mCapture) continue;
            this.onFileNotSelected();
            return;
        }
        this.launchSelectFileIntent();
    }

    private void onFileNotSelected() {
        this.nativeOnFileNotSelected(this.mNativeSelectFileDialog);
    }

    private boolean noSpecificType() {
        return this.mFileTypes.size() != 1 || this.mFileTypes.contains(ANY_TYPES);
    }

    private boolean shouldShowTypes(String allTypes, String specificType) {
        if (this.noSpecificType() || this.mFileTypes.contains(allTypes)) {
            return true;
        }
        return this.acceptSpecificType(specificType);
    }

    private boolean shouldShowImageTypes() {
        return this.shouldShowTypes(ALL_IMAGE_TYPES, IMAGE_TYPE);
    }

    private boolean shouldShowVideoTypes() {
        return this.shouldShowTypes(ALL_VIDEO_TYPES, VIDEO_TYPE);
    }

    private boolean shouldShowAudioTypes() {
        return this.shouldShowTypes(ALL_AUDIO_TYPES, AUDIO_TYPE);
    }

    private boolean acceptsSpecificType(String type2) {
        return this.mFileTypes.size() == 1 && TextUtils.equals((CharSequence)this.mFileTypes.get(0), (CharSequence)type2);
    }

    private boolean captureCamera() {
        return this.mCapture && this.acceptsSpecificType(ALL_IMAGE_TYPES);
    }

    private boolean captureCamcorder() {
        return this.mCapture && this.acceptsSpecificType(ALL_VIDEO_TYPES);
    }

    private boolean captureMicrophone() {
        return this.mCapture && this.acceptsSpecificType(ALL_AUDIO_TYPES);
    }

    private boolean acceptSpecificType(String accept) {
        for (String type2 : this.mFileTypes) {
            if (!type2.startsWith(accept)) continue;
            return true;
        }
        return false;
    }

    @CalledByNative
    private static SelectFileDialog create(long nativeSelectFileDialog) {
        return new SelectFileDialog(nativeSelectFileDialog);
    }

    private native void nativeOnFileSelected(long var1, String var3, String var4);

    private native void nativeOnMultipleFilesSelected(long var1, String[] var3, String[] var4);

    private native void nativeOnFileNotSelected(long var1);

    private class GetDisplayNameTask
    extends AsyncTask<Uri, Void, String[]> {
        String[] mFilePaths;
        final ContentResolver mContentResolver;
        final boolean mIsMultiple;

        public GetDisplayNameTask(ContentResolver contentResolver, boolean isMultiple) {
            this.mContentResolver = contentResolver;
            this.mIsMultiple = isMultiple;
        }

        protected String[] doInBackground(Uri ... uris) {
            this.mFilePaths = new String[uris.length];
            String[] displayNames = new String[uris.length];
            try {
                for (int i = 0; i < uris.length; ++i) {
                    this.mFilePaths[i] = uris[i].toString();
                    displayNames[i] = ContentUriUtils.getDisplayName(uris[i], this.mContentResolver, "_display_name");
                }
            }
            catch (SecurityException e) {
                Log.w((String)SelectFileDialog.TAG, (String)"Unable to extract results from the content provider");
                return null;
            }
            return displayNames;
        }

        protected void onPostExecute(String[] result) {
            if (result == null) {
                SelectFileDialog.this.onFileNotSelected();
                return;
            }
            if (this.mIsMultiple) {
                SelectFileDialog.this.nativeOnMultipleFilesSelected(SelectFileDialog.this.mNativeSelectFileDialog, this.mFilePaths, result);
            } else {
                SelectFileDialog.this.nativeOnFileSelected(SelectFileDialog.this.mNativeSelectFileDialog, this.mFilePaths[0], result[0]);
            }
        }
    }

    private class GetCameraIntentTask
    extends AsyncTask<Void, Void, Uri> {
        private GetCameraIntentTask() {
        }

        public Uri doInBackground(Void ... voids) {
            try {
                Context context = SelectFileDialog.this.mWindowAndroid.getApplicationContext();
                return UiUtils.getUriForImageCaptureFile(context, SelectFileDialog.this.getFileForImageCapture(context));
            }
            catch (IOException e) {
                Log.e((String)SelectFileDialog.TAG, (String)"Cannot retrieve content uri from file", (Throwable)e);
                return null;
            }
        }

        protected void onPostExecute(Uri result) {
            SelectFileDialog.this.mCameraOutputUri = result;
            if (SelectFileDialog.this.mCameraOutputUri == null && SelectFileDialog.this.captureCamera()) {
                SelectFileDialog.this.onFileNotSelected();
                return;
            }
            Intent camera = new Intent("android.media.action.IMAGE_CAPTURE");
            camera.setFlags(3);
            camera.putExtra("output", (Parcelable)SelectFileDialog.this.mCameraOutputUri);
            if (Build.VERSION.SDK_INT >= 18) {
                camera.setClipData(ClipData.newUri((ContentResolver)SelectFileDialog.this.mWindowAndroid.getApplicationContext().getContentResolver(), (CharSequence)"images", (Uri)SelectFileDialog.this.mCameraOutputUri));
            }
            SelectFileDialog.this.launchSelectFileWithCameraIntent(true, camera);
        }
    }
}

