/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.picker;

import android.content.Context;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.chromium.ui.R;
import org.chromium.ui.picker.TwoFieldDatePicker;

public class MonthPicker
extends TwoFieldDatePicker {
    private static final int MONTHS_NUMBER = 12;
    private final String[] mShortMonths;

    public MonthPicker(Context context, double minValue, double maxValue) {
        super(context, minValue, maxValue);
        this.getPositionInYearSpinner().setContentDescription((CharSequence)this.getResources().getString(R.string.accessibility_date_picker_month));
        this.mShortMonths = DateFormatSymbols.getInstance(Locale.getDefault()).getShortMonths();
        if (this.usingNumericMonths()) {
            for (int i = 0; i < this.mShortMonths.length; ++i) {
                this.mShortMonths[i] = String.format("%d", i + 1);
            }
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.init(cal.get(1), cal.get(2), null);
    }

    protected boolean usingNumericMonths() {
        return Character.isDigit(this.mShortMonths[0].charAt(0));
    }

    public static Calendar createDateFromValue(double value) {
        int year = (int)Math.min(value / 12.0 + 1970.0, 2.147483647E9);
        int month = (int)(value % 12.0);
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(year, month, 1);
        return cal;
    }

    @Override
    protected Calendar getDateForValue(double value) {
        return MonthPicker.createDateFromValue(value);
    }

    @Override
    protected void setCurrentDate(int year, int month) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.set(year, month, 1);
        if (date.before(this.getMinDate())) {
            this.setCurrentDate(this.getMinDate());
        } else if (date.after(this.getMaxDate())) {
            this.setCurrentDate(this.getMaxDate());
        } else {
            this.setCurrentDate(date);
        }
    }

    @Override
    protected void updateSpinners() {
        super.updateSpinners();
        String[] displayedValues = Arrays.copyOfRange(this.mShortMonths, this.getPositionInYearSpinner().getMinValue(), this.getPositionInYearSpinner().getMaxValue() + 1);
        this.getPositionInYearSpinner().setDisplayedValues(displayedValues);
    }

    public int getMonth() {
        return this.getCurrentDate().get(2);
    }

    @Override
    public int getPositionInYear() {
        return this.getMonth();
    }

    @Override
    protected int getMaxYear() {
        return this.getMaxDate().get(1);
    }

    @Override
    protected int getMinYear() {
        return this.getMinDate().get(1);
    }

    @Override
    protected int getMaxPositionInYear(int year) {
        if (year == this.getMaxDate().get(1)) {
            return this.getMaxDate().get(2);
        }
        return 11;
    }

    @Override
    protected int getMinPositionInYear(int year) {
        if (year == this.getMinDate().get(1)) {
            return this.getMinDate().get(2);
        }
        return 0;
    }
}

