/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.Window;
import org.xwalk.core.XWalkDialogManager;
import org.xwalk.core.XWalkEnvironment;
import org.xwalk.core.XWalkLibraryLoader;
import org.xwalk.core.XWalkUpdater;

public class XWalkActivityDelegate
implements XWalkLibraryLoader.DecompressListener,
XWalkLibraryLoader.ActivateListener {
    private static final String TAG = "XWalkLib";
    private Activity mActivity;
    private XWalkDialogManager mDialogManager;
    private XWalkUpdater mXWalkUpdater;
    private Runnable mCancelCommand;
    private Runnable mCompleteCommand;
    private boolean mIsXWalkReady;
    private boolean mBackgroundDecorated;
    private boolean mWillDecompress;

    public XWalkActivityDelegate(Activity activity, Runnable cancelCommand, Runnable completeCommand) {
        this.mActivity = activity;
        this.mCancelCommand = cancelCommand;
        this.mCompleteCommand = completeCommand;
        this.mDialogManager = new XWalkDialogManager((Context)this.mActivity);
        XWalkLibraryLoader.prepareToInit((Context)this.mActivity);
    }

    public boolean isXWalkReady() {
        return this.mIsXWalkReady;
    }

    public boolean isSharedMode() {
        return this.mIsXWalkReady && XWalkLibraryLoader.isSharedLibrary();
    }

    public boolean isDownloadMode() {
        return this.mIsXWalkReady && XWalkEnvironment.isDownloadMode();
    }

    public void setXWalkApkUrl(String url) {
        XWalkEnvironment.setXWalkApkUrl(url);
    }

    public XWalkDialogManager getDialogManager() {
        return this.mDialogManager;
    }

    public void onResume() {
        if (this.mIsXWalkReady) {
            return;
        }
        if (XWalkLibraryLoader.isInitializing() || XWalkLibraryLoader.isDownloading()) {
            Log.d((String)TAG, (String)"Other initialization or download is proceeding");
            return;
        }
        Log.d((String)TAG, (String)"Initialize by XWalkActivity");
        XWalkLibraryLoader.startDecompress(this);
    }

    @Override
    public void onDecompressStarted() {
        this.mDialogManager.showDecompressProgress(new Runnable(){

            @Override
            public void run() {
                Log.d((String)XWalkActivityDelegate.TAG, (String)"Cancel by XWalkActivity");
                XWalkLibraryLoader.cancelDecompress();
            }
        });
        this.mWillDecompress = true;
    }

    @Override
    public void onDecompressCancelled() {
        this.mWillDecompress = false;
        this.mCancelCommand.run();
    }

    @Override
    public void onDecompressCompleted() {
        if (this.mWillDecompress) {
            this.mDialogManager.dismissDialog();
            this.mWillDecompress = false;
        }
        XWalkLibraryLoader.startActivate(this);
    }

    @Override
    public void onActivateStarted() {
    }

    @Override
    public void onActivateFailed() {
        Window window;
        if (this.mXWalkUpdater == null) {
            this.mXWalkUpdater = XWalkEnvironment.isDownloadMode() ? new XWalkUpdater(new XWalkUpdater.XWalkBackgroundUpdateListener(){

                @Override
                public void onXWalkUpdateStarted() {
                }

                @Override
                public void onXWalkUpdateProgress(int percentage) {
                }

                @Override
                public void onXWalkUpdateCancelled() {
                    XWalkActivityDelegate.this.mCancelCommand.run();
                }

                @Override
                public void onXWalkUpdateFailed() {
                    XWalkActivityDelegate.this.mCancelCommand.run();
                }

                @Override
                public void onXWalkUpdateCompleted() {
                    XWalkLibraryLoader.startActivate(XWalkActivityDelegate.this);
                }
            }, (Context)this.mActivity) : new XWalkUpdater(new XWalkUpdater.XWalkUpdateListener(){

                @Override
                public void onXWalkUpdateCancelled() {
                    XWalkActivityDelegate.this.mCancelCommand.run();
                }
            }, (Context)this.mActivity, this.mDialogManager);
        }
        if (this.mXWalkUpdater.updateXWalkRuntime() && !XWalkEnvironment.isDownloadMode() && (window = this.mActivity.getWindow()) != null && window.getDecorView().getBackground() == null) {
            Log.d((String)TAG, (String)"Set the background to screen_background_dark");
            window.setBackgroundDrawableResource(17301656);
            this.mBackgroundDecorated = true;
        }
    }

    @Override
    public void onActivateCompleted() {
        if (this.mDialogManager.isShowingDialog()) {
            this.mDialogManager.dismissDialog();
        }
        if (this.mBackgroundDecorated) {
            Log.d((String)TAG, (String)"Recover the background");
            this.mActivity.getWindow().setBackgroundDrawable(null);
            this.mBackgroundDecorated = false;
        }
        this.mIsXWalkReady = true;
        XWalkLibraryLoader.finishInit((Context)this.mActivity);
        this.mCompleteCommand.run();
    }
}

