/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import junit.framework.Assert;
import org.xwalk.core.ReflectField;
import org.xwalk.core.ReflectMethod;
import org.xwalk.core.XWalkEnvironment;

class XWalkCoreWrapper {
    private static final String WRAPPER_PACKAGE = "org.xwalk.core";
    private static final String BRIDGE_PACKAGE = "org.xwalk.core.internal";
    private static final String TAG = "XWalkLib";
    private static final String XWALK_CORE_CLASSES_DEX = "classes.dex";
    private static XWalkCoreWrapper sProvisionalInstance;
    private static XWalkCoreWrapper sInstance;
    private static LinkedList<String> sReservedActivities;
    private static HashMap<String, LinkedList<ReservedAction>> sReservedActions;
    private int mApiVersion = 8;
    private int mMinApiVersion;
    private int mCoreStatus;
    private Context mWrapperContext;
    private Context mBridgeContext;
    private ClassLoader mBridgeLoader;

    public static XWalkCoreWrapper getInstance() {
        return sInstance;
    }

    public static int getCoreStatus() {
        if (sInstance != null) {
            return XWalkCoreWrapper.sInstance.mCoreStatus;
        }
        if (sProvisionalInstance == null) {
            return 0;
        }
        return XWalkCoreWrapper.sProvisionalInstance.mCoreStatus;
    }

    public static void handlePreInit(String tag) {
        if (sInstance != null) {
            return;
        }
        Log.d((String)TAG, (String)("Pre init xwalk core in " + tag));
        if (sReservedActions.containsKey(tag)) {
            sReservedActions.remove(tag);
        } else {
            sReservedActivities.add(tag);
        }
        sReservedActions.put(tag, new LinkedList());
    }

    public static void reserveReflectObject(Object object) {
        String tag = sReservedActivities.getLast();
        Log.d((String)TAG, (String)("Reserve object " + object.getClass() + " to " + tag));
        sReservedActions.get(tag).add(new ReservedAction(object));
    }

    public static void reserveReflectClass(Class<?> clazz) {
        String tag = sReservedActivities.getLast();
        Log.d((String)TAG, (String)("Reserve class " + clazz.toString() + " to " + tag));
        sReservedActions.get(tag).add(new ReservedAction(clazz));
    }

    public static void reserveReflectMethod(ReflectMethod method) {
        String tag = sReservedActivities.getLast();
        Log.d((String)TAG, (String)("Reserve method " + method.toString() + " to " + tag));
        sReservedActions.get(tag).add(new ReservedAction(method));
    }

    public static void handlePostInit(String tag) {
        Log.d((String)TAG, (String)("Post init xwalk core in " + tag));
        if (!sReservedActions.containsKey(tag)) {
            return;
        }
        LinkedList<ReservedAction> reservedActions = sReservedActions.get(tag);
        for (ReservedAction action : reservedActions) {
            if (action.mObject != null) {
                Log.d((String)TAG, (String)("Init reserved object: " + action.mObject.getClass()));
                new ReflectMethod(action.mObject, "reflectionInit", new Class[0]).invoke(new Object[0]);
                continue;
            }
            if (action.mClass != null) {
                Log.d((String)TAG, (String)("Init reserved class: " + action.mClass.toString()));
                new ReflectMethod(action.mClass, "reflectionInit", new Class[0]).invoke(new Object[0]);
                continue;
            }
            Log.d((String)TAG, (String)("Call reserved method: " + action.mMethod.toString()));
            Object[] args = action.mArguments;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof ReflectMethod)) continue;
                    args[i] = ((ReflectMethod)args[i]).invokeWithArguments();
                }
            }
            action.mMethod.invoke(args);
        }
        sReservedActions.remove(tag);
        sReservedActivities.remove(tag);
    }

    public static void handleRuntimeError(RuntimeException e) {
        Log.e((String)TAG, (String)"This API is incompatible with the Crosswalk runtime library");
        e.printStackTrace();
    }

    public static int attachXWalkCore() {
        Assert.assertFalse((boolean)sReservedActivities.isEmpty());
        Assert.assertNull((Object)sInstance);
        Log.d((String)TAG, (String)"Attach xwalk core");
        sProvisionalInstance = new XWalkCoreWrapper(XWalkEnvironment.getApplicationContext(), 1);
        if (sProvisionalInstance.findEmbeddedCore()) {
            return XWalkCoreWrapper.sProvisionalInstance.mCoreStatus;
        }
        if (XWalkEnvironment.isDownloadMode()) {
            sProvisionalInstance.findDownloadedCore();
            return XWalkCoreWrapper.sProvisionalInstance.mCoreStatus;
        }
        if (XWalkEnvironment.is64bitDevice()) {
            if (!sProvisionalInstance.findSharedCore(WRAPPER_PACKAGE) && !sProvisionalInstance.findSharedCore("org.xwalk.core64") && XWalkEnvironment.isIaDevice()) {
                sProvisionalInstance.findSharedCore("org.xwalk.core64.ia");
            }
        } else if (!sProvisionalInstance.findSharedCore(WRAPPER_PACKAGE) && XWalkEnvironment.isIaDevice()) {
            sProvisionalInstance.findSharedCore("org.xwalk.core.ia");
        }
        return XWalkCoreWrapper.sProvisionalInstance.mCoreStatus;
    }

    public static void dockXWalkCore() {
        Assert.assertNotNull((Object)sProvisionalInstance);
        Assert.assertNull((Object)sInstance);
        Log.d((String)TAG, (String)"Dock xwalk core");
        sInstance = sProvisionalInstance;
        sProvisionalInstance = null;
        sInstance.initCoreBridge();
        sInstance.initXWalkView();
    }

    public static void initEmbeddedMode() {
        if (sInstance != null || !sReservedActivities.isEmpty()) {
            return;
        }
        Log.d((String)TAG, (String)"Init embedded mode");
        XWalkCoreWrapper provisionalInstance = new XWalkCoreWrapper(null, -1);
        if (!provisionalInstance.findEmbeddedCore()) {
            throw new RuntimeException("Please have your activity extend XWalkActivity for shared mode");
        }
        sInstance = provisionalInstance;
        sInstance.initCoreBridge();
    }

    private XWalkCoreWrapper(Context context, int minApiVersion) {
        this.mMinApiVersion = minApiVersion > 0 && minApiVersion <= this.mApiVersion ? minApiVersion : this.mApiVersion;
        this.mCoreStatus = 0;
        this.mWrapperContext = context;
    }

    private void initCoreBridge() {
        Log.d((String)TAG, (String)"Init core bridge");
        Class<?> clazz = this.getBridgeClass("XWalkCoreBridge");
        ReflectMethod method = new ReflectMethod(clazz, "init", Context.class, Object.class);
        method.invoke(this.mBridgeContext, this);
    }

    private void initXWalkView() {
        Log.d((String)TAG, (String)"Init xwalk view");
        Class<?> clazz = this.getBridgeClass("XWalkViewDelegate");
        ReflectMethod method = new ReflectMethod(clazz, "init", Context.class, Context.class);
        method.invoke(this.mBridgeContext, this.mWrapperContext);
    }

    private boolean findEmbeddedCore() {
        this.mBridgeContext = null;
        this.mBridgeLoader = XWalkCoreWrapper.class.getClassLoader();
        if (!this.checkCoreVersion() || !this.checkCoreArchitecture()) {
            this.mBridgeLoader = null;
            return false;
        }
        Log.d((String)TAG, (String)"Running in embedded mode");
        this.mCoreStatus = 1;
        return true;
    }

    private boolean findSharedCore(String packageName) {
        if (!this.checkCorePackage(packageName)) {
            return false;
        }
        this.mBridgeLoader = this.mBridgeContext.getClassLoader();
        if (!this.checkCoreVersion() || !this.checkCoreArchitecture()) {
            this.mBridgeContext = null;
            this.mBridgeLoader = null;
            return false;
        }
        Log.d((String)TAG, (String)"Running in shared mode");
        this.mCoreStatus = 1;
        return true;
    }

    private boolean findDownloadedCore() {
        String libDir = XWalkEnvironment.getExtractedCoreDir();
        String dexPath = libDir + File.separator + XWALK_CORE_CLASSES_DEX;
        String dexOutputPath = XWalkEnvironment.getOptimizedDexDir();
        ClassLoader localClassLoader = ClassLoader.getSystemClassLoader();
        this.mBridgeLoader = new DexClassLoader(dexPath, dexOutputPath, libDir, localClassLoader);
        if (!this.checkCoreVersion() || !this.checkCoreArchitecture()) {
            this.mBridgeLoader = null;
            return false;
        }
        Log.d((String)TAG, (String)"Running in downloaded mode");
        this.mCoreStatus = 1;
        return true;
    }

    private boolean checkCoreVersion() {
        Log.d((String)TAG, (String)("[Environment] SDK:" + Build.VERSION.SDK_INT));
        Log.d((String)TAG, (String)("[App Version] build:23.53.589.4, api:" + this.mApiVersion + ", min_api:" + this.mMinApiVersion));
        try {
            Class<?> clazz = this.getBridgeClass("XWalkCoreVersion");
            String buildVersion = "";
            try {
                buildVersion = (String)new ReflectField(clazz, "XWALK_BUILD_VERSION").get();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            int libVersion = (Integer)new ReflectField(clazz, "API_VERSION").get();
            int minLibVersion = (Integer)new ReflectField(clazz, "MIN_API_VERSION").get();
            Log.d((String)TAG, (String)("[Lib Version] build:" + buildVersion + ", api:" + libVersion + ", min_api:" + minLibVersion));
            if (XWalkEnvironment.isDownloadMode() && XWalkEnvironment.isDownloadModeUpdate() && !buildVersion.isEmpty() && !buildVersion.equals("23.53.589.4")) {
                this.mCoreStatus = 8;
                return false;
            }
            if (this.mMinApiVersion > libVersion) {
                this.mCoreStatus = 3;
                return false;
            }
            if (this.mApiVersion < minLibVersion) {
                this.mCoreStatus = 4;
                return false;
            }
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)"XWalk core not found");
            this.mCoreStatus = 2;
            return false;
        }
        Log.d((String)TAG, (String)"XWalk core version matched");
        return true;
    }

    private boolean checkCoreArchitecture() {
        try {
            Class<?> clazz = this.getBridgeClass("XWalkViewDelegate");
            ReflectMethod method = new ReflectMethod(clazz, "loadXWalkLibrary", Context.class, String.class);
            boolean architectureMatched = false;
            String libDir = null;
            if (this.mBridgeContext != null) {
                if (Build.VERSION.SDK_INT < 17) {
                    libDir = "/data/data/" + this.mBridgeContext.getPackageName() + "/lib";
                }
                architectureMatched = (Boolean)method.invoke(this.mBridgeContext, libDir);
            } else {
                try {
                    architectureMatched = (Boolean)method.invoke(this.mBridgeContext, libDir);
                }
                catch (RuntimeException ex) {
                    Log.d((String)TAG, (String)ex.getLocalizedMessage());
                }
                if (!architectureMatched && this.mWrapperContext != null) {
                    libDir = XWalkEnvironment.getPrivateDataDir();
                    architectureMatched = (Boolean)method.invoke(this.mBridgeContext, libDir);
                }
            }
            if (!architectureMatched) {
                Log.d((String)TAG, (String)"Mismatch of CPU architecture");
                this.mCoreStatus = 6;
                return false;
            }
        }
        catch (RuntimeException e) {
            Log.d((String)TAG, (String)e.getLocalizedMessage());
            if (e.getCause() instanceof UnsatisfiedLinkError) {
                this.mCoreStatus = 6;
                return false;
            }
            this.mCoreStatus = 5;
            return false;
        }
        Log.d((String)TAG, (String)"XWalk core architecture matched");
        return true;
    }

    private boolean checkCorePackage(String packageName) {
        try {
            PackageInfo packageInfo = this.mWrapperContext.getPackageManager().getPackageInfo(packageName, 64);
            if (!this.verifyPackageInfo(packageInfo, "SHA-256", "6fd3002c5ca9a1f55ed51e92233ed4626120c266efea9d9746058c995ece68c4")) {
                Log.d((String)TAG, (String)(packageName + " signature verification failed"));
                this.mCoreStatus = 7;
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)(packageName + " not found"));
            return false;
        }
        try {
            this.mBridgeContext = this.mWrapperContext.createPackageContext(packageName, 3);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)(packageName + " not found"));
            return false;
        }
        Log.d((String)TAG, (String)("Created package context for " + packageName));
        return true;
    }

    private boolean verifyPackageInfo(PackageInfo packageInfo, String hashAlgorithm, String hashCode) {
        if (packageInfo.signatures == null) {
            Log.e((String)TAG, (String)"No signature in package info");
            return false;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(hashAlgorithm);
        }
        catch (NullPointerException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid hash algorithm");
        }
        byte[] hashArray = this.hexStringToByteArray(hashCode);
        if (hashArray == null) {
            throw new IllegalArgumentException("Invalid hash code");
        }
        for (int i = 0; i < packageInfo.signatures.length; ++i) {
            Log.d((String)TAG, (String)("Checking signature " + i));
            byte[] binaryCert = packageInfo.signatures[i].toByteArray();
            byte[] digest = md.digest(binaryCert);
            if (MessageDigest.isEqual(digest, hashArray)) {
                Log.d((String)TAG, (String)"Signature passed verification");
                return true;
            }
            Log.e((String)TAG, (String)"Hash code does not match");
        }
        return false;
    }

    private byte[] hexStringToByteArray(String str) {
        if (str == null || str.isEmpty() || str.length() % 2 != 0) {
            return null;
        }
        byte[] result = new byte[str.length() / 2];
        for (int i = 0; i < str.length(); i += 2) {
            int digit = Character.digit(str.charAt(i), 16);
            digit <<= 4;
            result[i / 2] = (byte)(digit += Character.digit(str.charAt(i + 1), 16));
        }
        return result;
    }

    public boolean isSharedMode() {
        return this.mBridgeContext != null;
    }

    public Object getBridgeObject(Object object) {
        try {
            return new ReflectMethod(object, "getBridge", new Class[0]).invoke(new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public Object getWrapperObject(Object object) {
        try {
            return new ReflectMethod(object, "getWrapper", new Class[0]).invoke(new Object[0]);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public Class<?> getBridgeClass(String name) {
        try {
            return this.mBridgeLoader.loadClass("org.xwalk.core.internal." + name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static {
        sReservedActivities = new LinkedList();
        sReservedActions = new HashMap();
    }

    private static class ReservedAction {
        Object mObject;
        Class<?> mClass;
        ReflectMethod mMethod;
        Object[] mArguments;

        ReservedAction(Object object) {
            this.mObject = object;
        }

        ReservedAction(Class<?> clazz) {
            this.mClass = clazz;
        }

        ReservedAction(ReflectMethod method) {
            this.mMethod = method;
            if (method.getArguments() != null) {
                this.mArguments = Arrays.copyOf(method.getArguments(), method.getArguments().length);
            }
        }
    }
}

