/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import java.util.ArrayList;
import org.xwalk.core.ReflectConstructor;
import org.xwalk.core.ReflectMethod;
import org.xwalk.core.XWalkCoreWrapper;

public class XWalkNativeExtensionLoader {
    private ArrayList<Object> constructorTypes;
    private ArrayList<Object> constructorParams;
    private ReflectMethod postWrapperMethod;
    private XWalkCoreWrapper coreWrapper;
    private Object bridge;
    private ReflectMethod registerNativeExtensionsInPathStringMethod = new ReflectMethod(null, "registerNativeExtensionsInPath", new Class[0]);

    protected Object getBridge() {
        return this.bridge;
    }

    public XWalkNativeExtensionLoader() {
        this.constructorTypes = new ArrayList();
        this.constructorParams = new ArrayList();
        this.reflectionInit();
    }

    public void registerNativeExtensionsInPath(String path) {
        try {
            this.registerNativeExtensionsInPathStringMethod.invoke(path);
        }
        catch (UnsupportedOperationException e) {
            if (this.coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    void reflectionInit() {
        XWalkCoreWrapper.initEmbeddedMode();
        this.coreWrapper = XWalkCoreWrapper.getInstance();
        if (this.coreWrapper == null) {
            XWalkCoreWrapper.reserveReflectObject(this);
            return;
        }
        int length = this.constructorTypes.size();
        Class[] paramTypes = new Class[length + 1];
        for (int i = 0; i < length; ++i) {
            Object type2 = this.constructorTypes.get(i);
            if (type2 instanceof String) {
                paramTypes[i] = this.coreWrapper.getBridgeClass((String)type2);
                this.constructorParams.set(i, this.coreWrapper.getBridgeObject(this.constructorParams.get(i)));
                continue;
            }
            if (type2 instanceof Class) {
                paramTypes[i] = (Class)type2;
                continue;
            }
            assert (false);
        }
        paramTypes[length] = Object.class;
        this.constructorParams.add(this);
        ReflectConstructor constructor = new ReflectConstructor(this.coreWrapper.getBridgeClass("XWalkNativeExtensionLoaderBridge"), paramTypes);
        try {
            this.bridge = constructor.newInstance(this.constructorParams.toArray());
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        if (this.postWrapperMethod != null) {
            this.postWrapperMethod.invoke(new Object[0]);
        }
        this.registerNativeExtensionsInPathStringMethod.init(this.bridge, null, "registerNativeExtensionsInPathSuper", String.class);
    }
}

