/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core;

import org.xwalk.core.ReflectMethod;
import org.xwalk.core.XWalkCoreWrapper;

public class XWalkPreferences {
    public static final String REMOTE_DEBUGGING = "remote-debugging";
    public static final String ANIMATABLE_XWALK_VIEW = "animatable-xwalk-view";
    public static final String JAVASCRIPT_CAN_OPEN_WINDOW = "javascript-can-open-window";
    public static final String ALLOW_UNIVERSAL_ACCESS_FROM_FILE = "allow-universal-access-from-file";
    public static final String SUPPORT_MULTIPLE_WINDOWS = "support-multiple-windows";
    public static final String PROFILE_NAME = "profile-name";
    public static final String SPATIAL_NAVIGATION = "enable-spatial-navigation";
    public static final String ENABLE_THEME_COLOR = "enable-theme-color";
    public static final String ENABLE_JAVASCRIPT = "enable-javascript";
    public static final String ENABLE_EXTENSIONS = "enable-extensions";
    private static XWalkCoreWrapper coreWrapper;
    private static ReflectMethod setValueStringbooleanMethod;
    private static ReflectMethod setValueStringintMethod;
    private static ReflectMethod setValueStringStringMethod;
    private static ReflectMethod getValueStringMethod;
    private static ReflectMethod getBooleanValueStringMethod;
    private static ReflectMethod getIntegerValueStringMethod;
    private static ReflectMethod getStringValueStringMethod;

    public static void setValue(String key, boolean enabled) {
        XWalkPreferences.reflectionInit();
        try {
            setValueStringbooleanMethod.invoke(key, enabled);
        }
        catch (UnsupportedOperationException e) {
            if (coreWrapper == null) {
                setValueStringbooleanMethod.setArguments(key, enabled);
                XWalkCoreWrapper.reserveReflectMethod(setValueStringbooleanMethod);
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public static void setValue(String key, int value) {
        XWalkPreferences.reflectionInit();
        try {
            setValueStringintMethod.invoke(key, value);
        }
        catch (UnsupportedOperationException e) {
            if (coreWrapper == null) {
                setValueStringintMethod.setArguments(key, value);
                XWalkCoreWrapper.reserveReflectMethod(setValueStringintMethod);
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public static void setValue(String key, String value) {
        XWalkPreferences.reflectionInit();
        try {
            setValueStringStringMethod.invoke(key, value);
        }
        catch (UnsupportedOperationException e) {
            if (coreWrapper == null) {
                setValueStringStringMethod.setArguments(key, value);
                XWalkCoreWrapper.reserveReflectMethod(setValueStringStringMethod);
            }
            XWalkCoreWrapper.handleRuntimeError(e);
        }
    }

    public static boolean getValue(String key) {
        XWalkPreferences.reflectionInit();
        try {
            return (Boolean)getValueStringMethod.invoke(key);
        }
        catch (UnsupportedOperationException e) {
            if (coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return false;
        }
    }

    public static boolean getBooleanValue(String key) {
        XWalkPreferences.reflectionInit();
        try {
            return (Boolean)getBooleanValueStringMethod.invoke(key);
        }
        catch (UnsupportedOperationException e) {
            if (coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return false;
        }
    }

    public static int getIntegerValue(String key) {
        XWalkPreferences.reflectionInit();
        try {
            return (Integer)getIntegerValueStringMethod.invoke(key);
        }
        catch (UnsupportedOperationException e) {
            if (coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return 0;
        }
    }

    public static String getStringValue(String key) {
        XWalkPreferences.reflectionInit();
        try {
            return (String)getStringValueStringMethod.invoke(key);
        }
        catch (UnsupportedOperationException e) {
            if (coreWrapper == null) {
                throw new RuntimeException("Crosswalk's APIs are not ready yet");
            }
            XWalkCoreWrapper.handleRuntimeError(e);
            return null;
        }
    }

    static void reflectionInit() {
        if (coreWrapper != null) {
            return;
        }
        XWalkCoreWrapper.initEmbeddedMode();
        coreWrapper = XWalkCoreWrapper.getInstance();
        if (coreWrapper == null) {
            XWalkCoreWrapper.reserveReflectClass(XWalkPreferences.class);
            return;
        }
        Class<?> bridgeClass = coreWrapper.getBridgeClass("XWalkPreferencesBridge");
        setValueStringbooleanMethod.init(null, bridgeClass, "setValue", String.class, Boolean.TYPE);
        setValueStringintMethod.init(null, bridgeClass, "setValue", String.class, Integer.TYPE);
        setValueStringStringMethod.init(null, bridgeClass, "setValue", String.class, String.class);
        getValueStringMethod.init(null, bridgeClass, "getValue", String.class);
        getBooleanValueStringMethod.init(null, bridgeClass, "getBooleanValue", String.class);
        getIntegerValueStringMethod.init(null, bridgeClass, "getIntegerValue", String.class);
        getStringValueStringMethod.init(null, bridgeClass, "getStringValue", String.class);
    }

    static {
        setValueStringbooleanMethod = new ReflectMethod(null, "setValue", new Class[0]);
        setValueStringintMethod = new ReflectMethod(null, "setValue", new Class[0]);
        setValueStringStringMethod = new ReflectMethod(null, "setValue", new Class[0]);
        getValueStringMethod = new ReflectMethod(null, "getValue", new Class[0]);
        getBooleanValueStringMethod = new ReflectMethod(null, "getBooleanValue", new Class[0]);
        getIntegerValueStringMethod = new ReflectMethod(null, "getIntegerValue", new Class[0]);
        getStringValueStringMethod = new ReflectMethod(null, "getStringValue", new Class[0]);
    }
}

