/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.extension;

import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.xwalk.core.extension.BindingObject;
import org.xwalk.core.extension.ExtensionInstanceHelper;
import org.xwalk.core.extension.MessageHandler;
import org.xwalk.core.extension.MessageInfo;
import org.xwalk.core.extension.ReflectionHelper;

public class BindingObjectStore {
    private String TAG = "BindingObjectStore";
    private Map<String, BindingObject> mBindingObjects = new HashMap<String, BindingObject>();
    private ExtensionInstanceHelper mInstance;

    public BindingObjectStore(MessageHandler handler, ExtensionInstanceHelper instance) {
        this.mInstance = instance;
        handler.register("JSObjectCollected", "onJSObjectCollected", this);
        handler.register("postMessageToObject", "onPostMessageToObject", this);
        handler.register("postMessageToClass", "onPostMessageToClass", this);
    }

    public boolean addBindingObject(String objectId, BindingObject obj) {
        if (this.mBindingObjects.containsKey(objectId)) {
            Log.w((String)this.TAG, (String)("Existing binding object:\n" + objectId));
            return false;
        }
        obj.initBindingInfo(objectId, this.mInstance);
        this.mBindingObjects.put(objectId, obj);
        obj.onJsBound();
        return true;
    }

    public BindingObject getBindingObject(String objectId) {
        return this.mBindingObjects.get(objectId);
    }

    public BindingObject removeBindingObject(String objectId) {
        BindingObject obj = this.mBindingObjects.remove(objectId);
        if (obj != null) {
            obj.onJsDestroyed();
        }
        return obj;
    }

    public void onJSObjectCollected(MessageInfo info) {
        this.removeBindingObject(info.getObjectId());
    }

    public Object onPostMessageToClass(MessageInfo info) {
        Object result = null;
        JSONArray args = info.getArgs();
        try {
            MessageInfo newInfo = new MessageInfo(info);
            String memberName = args.getString(0);
            JSONArray originArgs = args.getJSONArray(1);
            String ctorName = originArgs.getString(0);
            JSONArray memberArgs = originArgs.getJSONArray(1);
            newInfo.setJsName(memberName);
            newInfo.setArgs(memberArgs);
            ReflectionHelper reflection = info.getExtension().getTargetReflect(ctorName);
            result = reflection.handleMessage(newInfo, null);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
        return result;
    }

    public Object onPostMessageToObject(MessageInfo info) {
        Object result = null;
        try {
            BindingObject obj = this.getBindingObject(info.getObjectId());
            MessageInfo newInfo = new MessageInfo(info);
            if (info.getArgs() != null) {
                JSONArray args = info.getArgs();
                String objectMethodName = args.getString(0);
                JSONArray objectMethodArgs = args.getJSONArray(1);
                newInfo.setJsName(objectMethodName);
                newInfo.setArgs(objectMethodArgs);
            } else {
                ByteBuffer args = info.getBinaryArgs();
                args.order(ByteOrder.LITTLE_ENDIAN);
                int byteOffset = args.position();
                int methodNameLen = args.getInt(byteOffset);
                int alignedMethodNameLen = methodNameLen + (4 - methodNameLen % 4);
                String objectMethodName = new String(args.array(), byteOffset += 4, methodNameLen);
                int len = args.array().length - (byteOffset += alignedMethodNameLen);
                ByteBuffer objectMethodArgs = ByteBuffer.wrap(args.array(), byteOffset, len);
                newInfo.setJsName(objectMethodName);
                newInfo.setBinaryArgs(objectMethodArgs);
            }
            if (obj != null) {
                result = obj.handleMessage(newInfo);
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException | JSONException e) {
            Log.e((String)this.TAG, (String)e.toString());
        }
        return result;
    }

    public void onStart() {
        for (Map.Entry<String, BindingObject> entry : this.mBindingObjects.entrySet()) {
            BindingObject obj = entry.getValue();
            obj.onStart();
        }
    }

    public void onResume() {
        for (Map.Entry<String, BindingObject> entry : this.mBindingObjects.entrySet()) {
            BindingObject obj = entry.getValue();
            obj.onResume();
        }
    }

    public void onPause() {
        for (Map.Entry<String, BindingObject> entry : this.mBindingObjects.entrySet()) {
            BindingObject obj = entry.getValue();
            obj.onPause();
        }
    }

    public void onStop() {
        for (Map.Entry<String, BindingObject> entry : this.mBindingObjects.entrySet()) {
            BindingObject obj = entry.getValue();
            obj.onStop();
        }
    }

    public void onDestroy() {
        for (Map.Entry<String, BindingObject> entry : this.mBindingObjects.entrySet()) {
            BindingObject obj = entry.getValue();
            obj.onDestroy();
        }
    }
}

