/*
 * Decompiled with CFR 0.152.
 */
package org.xwalk.core.internal;

import android.annotation.TargetApi;
import android.app.Presentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Display;
import android.view.View;
import java.util.HashMap;
import org.chromium.base.annotations.CalledByNative;
import org.chromium.base.annotations.JNINamespace;
import org.xwalk.core.internal.XWalkUIClientInternal;
import org.xwalk.core.internal.XWalkViewInternal;
import org.xwalk.core.internal.extension.api.XWalkDisplayManager;

@JNINamespace(value="xwalk")
class XWalkPresentationHost
implements XWalkDisplayManager.DisplayListener {
    private static String TAG = "XWalkPresentationHost";
    private static XWalkPresentationHost sInstance;
    private Context mApplicationContext;
    private HashMap<RenderFrameHostId, PresentationSession> mExistingSessions;
    private long mNativePresentationHost;
    private XWalkDisplayManager mDisplayManager;

    public static XWalkPresentationHost createInstanceOnce(Context context) {
        if (sInstance == null) {
            sInstance = new XWalkPresentationHost(context);
        }
        return sInstance;
    }

    public static XWalkPresentationHost getInstance() {
        return sInstance;
    }

    private PresentationSession createNewSession(RenderFrameHostId id2) {
        PresentationSession session = new PresentationSession(this.mApplicationContext, id2.renderProcessID, id2.renderFrameID);
        assert (this.mExistingSessions.get(id2) == null);
        this.mExistingSessions.put(id2, session);
        return session;
    }

    private void removeContextActivity(int renderProcessID, int renderFrameID) {
        RenderFrameHostId id2 = new RenderFrameHostId(renderProcessID, renderFrameID);
        this.mExistingSessions.remove(id2);
    }

    private boolean startNewSession(PresentationSession session, int displayId, String url) {
        if (session != null) {
            Display[] presentationDisplays = new Display[]{};
            if (Build.VERSION.SDK_INT >= 17) {
                presentationDisplays = this.mDisplayManager.getDisplays("android.hardware.display.category.PRESENTATION");
            }
            if (presentationDisplays.length > 0) {
                Display display = null;
                for (Display query : presentationDisplays) {
                    if (query.getDisplayId() != displayId) continue;
                    display = query;
                }
                if (display != null && Build.VERSION.SDK_INT >= 17) {
                    session.presentationScreen = new PresentationScreen(session, display);
                    session.presentationScreen.show();
                    session.presentationScreen.loadUrl(url);
                    return true;
                }
                Log.e((String)TAG, (String)("Can't find specified display with id " + displayId));
            }
        }
        Log.e((String)TAG, (String)"startNewSession falied!");
        return false;
    }

    private void closeSession(int renderProcessID, int renderFrameID) {
        RenderFrameHostId id2 = new RenderFrameHostId(renderProcessID, renderFrameID);
        PresentationSession session = this.mExistingSessions.get(id2);
        if (session != null && Build.VERSION.SDK_INT >= 17) {
            if (session.presentationScreen != null) {
                session.presentationScreen.dismiss();
                session.presentationScreen = null;
                this.nativeOnPresentationClosed(this.mNativePresentationHost, renderProcessID, renderFrameID);
            }
            this.removeContextActivity(renderProcessID, renderFrameID);
        }
    }

    private XWalkPresentationHost(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.mExistingSessions = new HashMap();
        this.mDisplayManager = XWalkDisplayManager.getInstance(this.mApplicationContext);
        this.setNativeObject(this.nativeInit());
        this.listenToSystemDisplayChange();
    }

    public void listenToSystemDisplayChange() {
        this.mDisplayManager.registerDisplayListener(this);
    }

    public void stopListenToSystemDisplayChange() {
        this.mDisplayManager.unregisterDisplayListener(this);
    }

    @CalledByNative
    public Display[] getAndroidDisplayInfo() {
        Display[] emptyDisplay = new Display[]{};
        if (Build.VERSION.SDK_INT >= 17) {
            return this.mDisplayManager.getDisplays();
        }
        return emptyDisplay;
    }

    @CalledByNative
    public boolean showPresentation(int renderProcessID, int renderFrameID, int displayId, String url) {
        RenderFrameHostId id2 = new RenderFrameHostId(renderProcessID, renderFrameID);
        PresentationSession session = this.mExistingSessions.get(id2);
        if (session == null) {
            session = this.createNewSession(id2);
        }
        return this.startNewSession(session, displayId, url);
    }

    @CalledByNative
    public void closePresentation(int renderProcessID, int renderFrameID) {
        this.closeSession(renderProcessID, renderFrameID);
    }

    public static void onPresentationScreenClose(PresentationSession attachedSession) {
        RenderFrameHostId id2 = new RenderFrameHostId(attachedSession.renderProcessID, attachedSession.renderFrameID);
        PresentationSession querySession = XWalkPresentationHost.getInstance().mExistingSessions.get(id2);
        if (querySession != null && Build.VERSION.SDK_INT >= 17) {
            if (querySession.presentationScreen != null) {
                querySession.presentationScreen = null;
            }
            int renderProcessID = querySession.renderProcessID;
            int renderFrameID = querySession.renderFrameID;
            XWalkPresentationHost.getInstance().nativeOnPresentationClosed(XWalkPresentationHost.getInstance().mNativePresentationHost, renderProcessID, renderFrameID);
            XWalkPresentationHost.getInstance().removeContextActivity(renderProcessID, renderFrameID);
        }
    }

    private void setNativeObject(long newNativePresentationAPI) {
        assert (this.mNativePresentationHost == 0L);
        this.mNativePresentationHost = newNativePresentationAPI;
        this.nativeSetupJavaPeer(this.mNativePresentationHost);
    }

    private native long nativeInit();

    private static native void nativeDestroy(long var0);

    private native void nativeSetupJavaPeer(long var1);

    private native void nativeOnPresentationClosed(long var1, int var3, int var4);

    private native void nativeOnDisplayAdded(long var1, int var3);

    private native void nativeOnDisplayChanged(long var1, int var3);

    private native void nativeOnDisplayRemoved(long var1, int var3);

    @Override
    public void onDisplayAdded(int displayId) {
        this.nativeOnDisplayAdded(this.mNativePresentationHost, displayId);
    }

    @Override
    public void onDisplayChanged(int displayId) {
        this.nativeOnDisplayChanged(this.mNativePresentationHost, displayId);
    }

    @Override
    public void onDisplayRemoved(int displayId) {
        this.nativeOnDisplayRemoved(this.mNativePresentationHost, displayId);
    }

    @TargetApi(value=17)
    private final class PresentationScreen
    extends Presentation {
        private XWalkViewInternal mContentView;
        private PresentationSession mSession;
        private Display mDisplay;

        public PresentationScreen(PresentationSession session, Display display) {
            super(session.context, display);
            this.mSession = session;
            this.mDisplay = display;
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            if (this.mContentView == null) {
                this.mContentView = new XWalkViewInternal(this.getContext());
                this.mContentView.setUIClient(new XWalkUIClientInternal(this.mContentView));
            }
            this.setContentView((View)this.mContentView);
        }

        protected void onStop() {
            super.onStop();
            XWalkPresentationHost.onPresentationScreenClose(this.mSession);
        }

        public void loadUrl(String url) {
            this.mContentView.loadUrl(url);
        }
    }

    private final class PresentationSession {
        public PresentationScreen presentationScreen;
        public Context context;
        public int renderProcessID;
        public int renderFrameID;

        public PresentationSession(Context context, int renderProcessID, int renderFrameID) {
            this.context = context;
            this.renderProcessID = renderProcessID;
            this.renderFrameID = renderFrameID;
            this.presentationScreen = null;
        }
    }

    public static class RenderFrameHostId {
        public int renderProcessID;
        public int renderFrameID;

        public RenderFrameHostId(int renderProcessID, int renderFrameID) {
            this.renderProcessID = renderProcessID;
            this.renderFrameID = renderFrameID;
        }

        public int hashCode() {
            int hash = 17 + this.renderProcessID;
            hash *= 31;
            return hash += this.renderFrameID;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RenderFrameHostId) {
                if (obj == this) {
                    return true;
                }
                RenderFrameHostId that = (RenderFrameHostId)obj;
                return this.renderProcessID == that.renderProcessID && this.renderFrameID == that.renderFrameID;
            }
            return false;
        }
    }
}

