package jp.agentec.abook.abv.bl.acms.client.json;

import jp.agentec.abook.abv.bl.acms.client.json.AcmsCommonJSON;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.JSONValidationException;

import org.json.adf.JSONException;
import org.json.adf.JSONObject;

public class CmsUrlJSON extends AcmsCommonJSON {
	public String url;
	public String syncHttpUrl;
	public String syncWsUrl;
	
	public String errorMessage;
	
	public CmsUrlJSON(String jsonString) throws AcmsException {
		super(jsonString);
	}
	
	@Override
	protected void parse(JSONObject json) throws JSONException, JSONValidationException {
		super.parse(json);
		url = getString(json, "url");

		if (json.has("syncHttpUrl")) {
			syncHttpUrl = getString(json, "syncHttpUrl");
		}

		if (json.has("syncWsUrl")) {
			syncWsUrl = getString(json, "syncWsUrl");
		}

		if (json.has("errorMessage")) {
			errorMessage = json.getString("errorMessage");
		}
	}
}
