package jp.agentec.abook.abv.bl.acms.client.parameters;

import jp.agentec.adf.net.http.HttpParameterObject;
import jp.agentec.adf.util.StringUtil;

/**
 * デバイストークン更新用のパラメータです。
 * @author tauchi
 * @version plus 1.3.0
 */
public class UpdateDeviceTokenParameters extends HttpParameterObject {
	private String sid;
	private String ma;
	private String uid;
	private String deviceToken;
	private int appId;
	private String appVersion;

	public UpdateDeviceTokenParameters(String sid, String uid, String ma, String deviceToken, int appId, String appVersion) {
		if (StringUtil.isNullOrWhiteSpace(sid)) {
			throw new IllegalArgumentException("argument udid not allowed null or white space.");
		}

		if (StringUtil.isNullOrWhiteSpace(deviceToken)) {
			throw new IllegalArgumentException("argument deviceToken not allowed null or white space.");
		}

		if (StringUtil.isNullOrWhiteSpace(appVersion)) {
			throw new IllegalArgumentException("argument appVersion not allowed null or white space.");
		}

		this.sid = sid;
		this.uid = uid;
		this.ma = ma;
		this.deviceToken = deviceToken;
		this.appId = appId;
		this.appVersion = appVersion;
	}

	public String getSid() {
		return sid;
	}

	public String getUid() {
		return uid;
	}

	public String getMa() {
		return ma;
	}

	public String getDeviceToken() {
		return deviceToken;
	}

	public int getAppId() {
		return appId;
	}

	public String getAppVersion() {
		return appVersion;
	}
}
