package jp.agentec.abook.abv.bl.data.tables;

import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.db.SQLiteDatabase;
import jp.agentec.abook.abv.bl.data.DatabaseVersions;

/**
 * Created by leej on 2018/08/17.
 */

public class TOperation extends SQLiteTableScript {

    public TOperation() {
        super();
    }

    @Override
    public List<String> getCreateScript(int version) {
        List<String> ddl = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();

        sql.append(" CREATE TABLE t_operation ( ");
        sql.append("        operation_id BIGINT NOT NULL ");
        sql.append("      , operation_name VARCHAR(128) ");
        sql.append("      , operation_type INTEGER NOT NULL ");
        sql.append("      , operation_descriptions TEXT ");
        sql.append("      , operation_start_date DATE NOT NULL ");
        sql.append("      , operation_end_date DATE NOT NULL ");
        sql.append("      , last_edit_date DATE NOT NULL ");
        sql.append("      , content_creating_flg INTEGER NOT NULL ");
        sql.append("      , edit_lock_flg BOOLEAN NOT NULL DEFAULT 0 ");
        sql.append("      , need_sync_flg BOOLEAN NOT NULL DEFAULT 0 ");
        sql.append("      , report_type INTEGER NOT NULL DEFAULT 0 ");
        sql.append("      , report_cycle INTEGER NOT NULL DEFAULT 0 ");
        sql.append("      , enable_report_update INTEGER NOT NULL DEFAULT 0 ");
        sql.append("      , enable_report_history SMALLINT NOT NULL DEFAULT 0 ");
        sql.append("      , enable_report_edit SMALLINT NOT NULL DEFAULT 0 ");
        sql.append("      , enable_add_report SMALLINT NOT NULL DEFAULT 0 ");
        sql.append("      , operation_open_date DATETIME ");
        sql.append("      , PRIMARY KEY (operation_id) ");
        sql.append(" ) ");
        ddl.add(sql.toString());

        return ddl;
    }


    @Override
    public List<String> getUpgradeScript(int oldVersion, int newVersion) {
        List<String> ddl = new ArrayList<String>();

        if (oldVersion < DatabaseVersions.Ver1_2_0) { // カラムの追加
            ddl.add("ALTER TABLE t_operation ADD COLUMN operation_open_date DATETIME");
        }
        return ddl;
    }

    @Override
    public List<String> getMigrationScript(SQLiteDatabase databaseConnection, int oldVersion, int newVersion, Object[] params) {
        return null;
    }

}
