package jp.agentec.abook.abv.bl.dto;


/**
 * グループ情報を格納します。m_groupのPKであるgroup_relation_idはこのdtoの扱いません。内部的なキーはgetKyeValuesメソッドで定義してあります。
 * @author Taejin Hong
 * @version　1.1.0
 */
public class GroupDto extends AbstractDto {
	public int groupRelationId;
	public int groupId;
	public int parentGroupId;
	public int groupLevel;
	public String groupName;
	public int contentCount = 0;
	public String displayCount;
	public String groupPath;
	public boolean userGroupFlg;
	
	public GroupDto() {
	}

	public GroupDto(int groupId, String groupName, int groupLevel, int parentGroupId, boolean userGroupFlg) {
		this.groupId = groupId;
		this.groupName = groupName;
		this.groupLevel = groupLevel;
		this.parentGroupId = parentGroupId;
		this.userGroupFlg = userGroupFlg;
	}

	@Override
	public Object[] getInsertValues() {
		return new Object[]{groupRelationId, groupId, parentGroupId, groupLevel, groupName, contentCount, displayCount};
	}

	@Override
	public String[] getKeyValues() {
		return new String[]{""+ groupId, ""+ parentGroupId, ""+ groupLevel};
	}
}
