package jp.agentec.abook.abv.ui.common.activity;

import jp.agentec.abook.abv.bl.acms.type.DownloadStatusType;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.exception.ABVExceptionCode;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.data.dao.AbstractDao;
import jp.agentec.abook.abv.bl.data.dao.OperationDao;
import jp.agentec.abook.abv.bl.download.ContentDownloader;
import jp.agentec.abook.abv.bl.download.ContentFileExtractor;
import jp.agentec.abook.abv.bl.download.ContentZipDownloadNotification;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.FixPushMessageDto;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.dto.PushMessageDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.PushMessageLogic;
import jp.agentec.abook.abv.cl.helper.ContentMarkingFileHelper;
import jp.agentec.abook.abv.cl.util.AndroidStringUtil;
import jp.agentec.abook.abv.launcher.android.ABVApplication;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.helper.ProgressDialogHelper;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.KeyboardUtils;
import jp.agentec.abook.abv.ui.common.util.LogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.activity.ABookSettingActivity;
import jp.agentec.abook.abv.ui.home.adapter.FixPushMessageAdapter;
import jp.agentec.abook.abv.ui.home.adapter.OperationSelectAdapter;
import jp.agentec.abook.abv.ui.home.adapter.PushMessageListAdapter;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.adf.util.DateTimeFormat;
import jp.agentec.adf.util.DateTimeUtil;

import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import com.handmark.pulltorefresh.library.PullToRefreshBase;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public abstract class ABVUIActivity extends ABVAuthenticatedActivity {
	private final static String TAG = "ABVUIActivity";

	private boolean startRefresh; //自動リフレッシュはネットワークエラー表示しないように    
	protected ImageView mRefreshImage; // add by jang
	protected TextView mUpdatedDate; // add by jang
	protected TextView mLoadingText; // add by jang;

	protected ImageButton communicationButton;                    // コミュニケーションボタン
	private Dialog mCommunicationMenuDialog;
	private Dialog mOperationSelectDialog;
	private ListView mOperationSelectListView;
	private Dialog mPushMessageListDialog;
	private ListView mPushMessageListView;
	private OperationSelectAdapter mOperationSelectAdapter;
	private PushMessageListAdapter mPushMessageListAdapter;
	private ListView mFixPushMessageListView;
	private Dialog mPushMessageSendDialog;
	private int mSelectedFixPuchMessagePosition;
	private int mSendType;

	protected PushMessageLogic pushMessageLogic = AbstractLogic.getLogic(PushMessageLogic.class);


	// 新着更新処理の終了後、プルダウンを完了させるためのビュー
	protected PullToRefreshBase refreshBaseView;

	//Gettisの場合：プッシュ―メッセージを経由してコンテンツダウンロード場合対応
	private String mPushMessage = ""; //コンテンツ追加の機能をの引数が増えないようにこの変数を追加

    private boolean isCheckTransferMaster = false; // マスター転送が同時実行されることを防ぐためのチェック
	
	@Override
    protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// OS 8.0で起きるバグ（ダイアログActivity表示後(windowIsTranslucent: true)、画面を固定するとCrashされる問題対策）
		// showPushMessageActivityが存在する場合は、以下のメソッドを実行しない
		if (!ActivityHandlingHelper.getInstance().hasShowPushMessageActivity()) {
			setPortraitIfNormal();
		}

		startRefresh = true;
        ABVEnvironment.getInstance().enableToastMessage = true;
//		dateFormat ="yyyy'" + getResources().getString(R.string.date_format_year) + "'MM'" + getResources().getString(R.string.date_format_month) + "'dd'" + getResources().getString(R.string.date_format_day) + "'HH:mm:ss";

		mSelectedFixPuchMessagePosition = 0;
		mSendType = 0;
	}
	
	//更新する場合中止させる。
	public boolean refreshStop() {
		try {
			contentRefresher.stopRefresh();

		} catch (Exception e) {
			Logger.w("stopRefresh failed at refreshStop.", e);

			//	停止ができなかった場合はfalseを返す。
			return false;
		}
		return true;
 	}

	@Override
	protected void onResume() {
		super.onResume();
	}
	
	@Override
	protected void onPause() {
		super.onPause();
	}

	@Override
	protected void onStop() {
		super.onStop();
	}
	
	@Override
	protected void onDestroy() {
		super.onDestroy();
		//キャッシュを使用しない場合、ディレクトリが残っていれば削除
		if (!getRBoolean(R.bool.use_cache)) {
			ContentFileExtractor.getInstance().removeAllContentCash();
		}
	}

	@Override
    protected void startActivity(Intent intend, NaviConsts ABVNavi) {
		super.startActivity(intend, ABVNavi) ;   
		closeProgressPopup();
    }
	 
	
	@Override
    protected void startActivityForResult(Intent intend, int requestCode, NaviConsts ABVNavi) {
		super.startActivityForResult(intend,requestCode, ABVNavi);
		closeProgressPopup();
    }
	
	@Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
		closeProgressPopup();
		return super.onKeyUp(keyCode, event);
		
	}
	
	public boolean refreshContent(boolean isAutoRefresh) throws NetworkDisconnectedException {
		boolean result = true;
		try {
			result = contentRefresher.isRefreshing();
			
			Logger.d(TAG, "contentDownloader.isRefreshing() %s", result);
			getABVUIDataCache().preIsCatalogEdition = ABVDataCache.getInstance().serviceOption.isCatalogEdition();

			if (!result) {
				startUpdateAnimation();
				// contentDownloadObserverがnullだと更新マークのアニメーションが完了しない TODO 2014/11/12 Jang
				// onCreateでrefresh処理をcallしたときに起きる

				contentRefresher.refreshContentList(this);
                // ログ送信可否を確認
                LogUtil.checkSendLogFlag();
			}
		} catch (NetworkDisconnectedException e) {
			stopUpdateAnimation();
			if (startRefresh) {
				startRefresh = false;
			}
			throw e;
		} catch (ABVException e) {
			stopUpdateAnimation();
			//noinspection EnumSwitchStatementWhichMissesCases
			switch (e.getCode()) {
			case C_I_CONTENT_0001:
				handleErrorMessageToast(ABVExceptionCode.C_I_CONTENT_0001);
				break;
			case S_E_ACMS_1403:
				// 再ログイン
				onAuthenticationFailed();
				break;
			case C_I_CONTENT_0002:
				//	コンテンツダウンロード中は自動更新を行わない。
				if (!isAutoRefresh) {
					handleErrorMessageToast(ABVExceptionCode.C_I_CONTENT_0002);
				}
				break;
			case S_E_ACMS_0500:
				handleErrorMessageToast(ABVExceptionCode.S_E_ACMS_0500);
				break;
			case S_E_ACMS_INVALID_RESPONSE:
				// サーバー通信エラー時、エラーメッセージ表示
				handleErrorMessageToast(ABVExceptionCode.S_E_ACMS_INVALID_RESPONSE);
				break;
			default:
				Logger.e(TAG, "Exception DataRefresh", e);
				handleErrorMessageToast(ErrorCode.E107);
				break;
			}
		} catch (Exception e) {
			stopUpdateAnimation();
			Logger.e(TAG, "Exception DataRefresh", e);
			handleErrorMessageToast(ErrorCode.E107);
		}
		
		return result;
	}

	/**　
	 *　グリッド初期化
	 * onCreateでは呼ばないないこと！！
	 * @param isAutoRefresh 自動リフレッシュフラグ
	 * @throws Exception 
	 * @throws ABVException 
	 * @throws NetworkDisconnectedException 
	 * @since 1.0.0
	 */
	protected boolean dataRefresh(boolean isAutoRefresh) {
		try {
			return refreshContent(isAutoRefresh);
		} catch (NetworkDisconnectedException e) {
			Logger.e(TAG, "NetworkDisconnectedException" + e);
			
			//自動リフレッシュでない場合メッセージ表示
			if (!isAutoRefresh) {
				handleErrorMessageToast(ErrorCode.NETWORK);
			}
		}
		return false;
	}

	
//	// @{ABVAuthenticatedActivity.contentLinkCheckDeliverable}と同じ
//	//非公開と期間終了のコンテンツがある場合削除
//	protected boolean contentCheckDeliverable(long contentId) throws AcmsException, NetworkDisconnectedException  {
//		boolean result = true;
//			// サーバ側でコンテンツがダウンロード出来ない状態(非公開、削除など)の時はメッセージを表示
//			ContractLogic contractLogic = AbstractLogic.getLogic(ContractLogic.class);
//    		if (!contentLogic.getContentCheckDeliverable(contentId)) {
//    			if (contractLogic.getNoAuthDelete()) {
//    				ContentDto contentDto = contentDao.getContent(contentId);
//    				
//    				if (contentDto != null) {
//    					contentLogic.deleteContent(contentDao.getContent(contentId), true);
//					}
//    			}
//    			result = false;
//    		}
//		return result;
//	}
	
	/**
	 * コンテンツの有効性チェックとダウンロードを行う
	 * @param contentId 対象コンテンツID
	 * @return boolean チェックの成功可否
	 */
	public boolean contentValidCheckAndDownload(long contentId) {
		boolean checkResult = false;
		int status = contentValidCheckAndShowMessage(contentId, MessageType.TYPE_SHOW_TOAST);
		if (status == ContentCheckResultType.SUCCESS) {
			checkResult = contentDownload(contentId);
		}
		
		if (status == ContentCheckResultType.NO_AUTH_DELETE) {
			// コンテンツのチェック結果が権限喪失の場合はリフレッシュ
			handler.post(new Runnable() {
				@Override
				public void run() {
					dataRefresh(true);
				}
			});
		}
		return checkResult;
	}
	

	// コンテンツダウンロード一時停止
	public void contentDownloadPause(long contentId) {
		contentDownloader.pause(contentId, false);
	}

	// コンテンツダウンロード再開
	public boolean contentDownloadResume(ContentDto contentDto) {
		long contentId = contentDto.contentId;
		boolean result = true;
		try {
			int status = contentValidCheckAndShowMessage(contentId, MessageType.TYPE_SHOW_TOAST);
			if (status == ContentCheckResultType.SUCCESS) {
				contentDownloader.resume(contentId);
			} else if (status == ContentCheckResultType.NETWORK_ERROR) {
				result = false;
			} else {
				contentDownloadCancel(contentDto);
				result = false;
			}

			if (status == ContentCheckResultType.NO_AUTH_DELETE) {
				// コンテンツのチェック結果が権限喪失の場合はリフレッシュ
				handler.post(new Runnable() {
					@Override
					public void run() {
						dataRefresh(true);
					}
				});
			}
		} catch (NetworkDisconnectedException e) {
			Logger.e(TAG, "NetworkDisconnectedException" + e);
			handleErrorMessageToast(ErrorCode.NETWORK);
			result = false;
		} catch (AcmsException e) {
			Logger.e(TAG, "AcmsException", e);
			handleErrorMessageToast(e);
			result = false;
		}
		return result;
	}

	// コンテンツダウンロードキャンセル
	public void contentDownloadCancel(final ContentDto contentDto) {
		CommonExecutor.execute(new Runnable() {
			@Override
			public void run() {
				contentDownloader.cancel(contentDto.contentId);
			}
		});
	}

	// ダウンロード済みコンテンツ削除
	public boolean contentDelete(ContentDto contentDto) {
		boolean result = true;
		try {
			deleteContent(contentDto, false);
		} catch (Exception e) {
			result = false;
			Logger.e("Exception ", e);
			handleErrorMessageToast(ErrorCode.E107);
		}
		if(result) {
			// クリップボードのコンテンツが削除されたらクリア
			if (getABVUIDataCache().srcContentId == contentDto.contentId) {
				getABVUIDataCache().srcContentId = -1;
			}
		}
		return result;
	}

    /**
     * setTheme不具合によりタブレットデザインではDialogThemeを使う場合のAcitivity名をルールとして語尾にDialogをつける
     * @param className
     * @return
     */
    protected String convertClassName(String className) {
    	if (!isNormalSize()) {
    		className += "Dialog";
    	}
    	return className;
    }
    
	protected void startUpdateAnimation() {
		Logger.d(TAG, "startUpdateAnimation");
		RotateAnimation mRefreshAnimation = new RotateAnimation(0, 720, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
		mRefreshAnimation.setInterpolator(new LinearInterpolator());
		mRefreshAnimation.setDuration(1200);
		mRefreshAnimation.setRepeatCount(Animation.INFINITE);
		mRefreshAnimation.setRepeatMode(Animation.RESTART);

		if (mRefreshImage != null) {
			mRefreshImage.startAnimation(mRefreshAnimation);
		} else {
			Logger.w(TAG, "you need to set mRefreshImage.");
		}
	}
    
	protected void stopUpdateAnimation() {
		Logger.d(TAG, "stopUpdateAnimation");
		if (mRefreshImage != null) {
			mRefreshImage.clearAnimation();
		} else {
			Logger.w(TAG, "you need to set mRefreshImage.");
		}

		// ヘッダーの新着更新処理を完了にさせる
		if (refreshBaseView != null) {
			handler.post(new Runnable() {
				@Override
				public void run() {
					refreshBaseView.onRefreshComplete();
				}
			});
		}
		//ログアウト時にも呼ばれるのでチェック
		if (ABVDataCache.getInstance().getMemberInfo() != null) {
			// 自動ダウンロード対象がある場合、新着更新が完了したあとに開始するように修正(jang)
			ContentDownloader.getInstance().autoDownload();
		}
	}

	/**
	 * メモ・マーキング・しおりをコピーします
	 * 
	 * @param srcContentId コピー元コンテンツID
	 * @param dstContentId コピー先コンテンツID
	 */
	protected void copyUserInfoCheckOrientation(final long srcContentId, final long dstContentId) {
		ContentDto srcContentDto = contentDao.getContent(srcContentId);
		ContentDto dstContentDto = contentDao.getContent(dstContentId);

		// コンテンツの向きが違う場合、アラートを表示
        if (srcContentDto.orientation == dstContentDto.orientation) {
            copyUserInfo(srcContentId, dstContentId);
        } else {
            ABookAlertDialog dialog = AlertDialogUtil.createAlertDialog(this, R.string.user_info_copy);
            dialog.setMessage(R.string.user_info_copy_alert);
            dialog.setNegativeButton(R.string.no, null);
            dialog.setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    copyUserInfo(srcContentId, dstContentId);
                }
            });
            showAlertDialog(dialog);
        }
	}

	private void copyUserInfo(long srcContentId, long dstContentId) {
		StringBuffer sbErrorMessage = new StringBuffer();

		// メモのコピー
		memoLogic.copyContentMemo(srcContentId, dstContentId);

		try {
			// マーキングのコピー
			ContentMarkingFileHelper markingFileHelper = new ContentMarkingFileHelper();
			markingFileHelper.copyMarkingFile(srcContentId, dstContentId);
		} catch (Exception e) {
			if (sbErrorMessage.length() > 0) {
				sbErrorMessage.append(",");
			}
			sbErrorMessage.append(getString(R.string.marking));
			Logger.e(TAG, e.toString());
		}

		try {
			// しおりのコピー
			bookmarkLogic.copyContentBookmark(srcContentId, dstContentId);
		} catch (Exception e) {
			if (sbErrorMessage.length() > 0) {
				sbErrorMessage.append(",");
			}
			sbErrorMessage.append(getString(R.string.bookmark));
			Logger.e(TAG, e.toString());
		}

		// エラーが起きている場合メッセージを表示する
		if (sbErrorMessage.length() > 0) {
			sbErrorMessage.append(getString(R.string.paste_memo));
			ABVToastUtil.showMakeText(this, AndroidStringUtil.format(this, R.string.failed_state, sbErrorMessage.toString()), Toast.LENGTH_SHORT);
		} else {
			ABVToastUtil.showMakeText(this, AndroidStringUtil.format(this, R.string.complete_state, R.string.paste_memo), Toast.LENGTH_SHORT);
		}
	}

	@Override
	public void onDownloadingContentZip(final ContentZipDownloadNotification notification) {
		super.onDownloadingContentZip(notification);
		if (notification.downloadStatus == DownloadStatusType.Paused || notification.downloadStatus == DownloadStatusType.AutoPaused || notification.downloadStatus == DownloadStatusType.Failed) {
			//プッシュ―メッセージでコンテンツダウンロードの場合：ダウンロード中に何か問題が起きたら自動的にコンテンツ開かない
			((ABVApplication)getApplication()).setAutoOpenAfterDownloadContent(false);
		}
	}

	// 設定画面表示
	public void showSetting() {
		Intent intent = new Intent();
		intent.setClassName(getApplicationContext().getPackageName(), ABookSettingActivity.class.getName());
		intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		// 設定画面の前のActivityを保存する（設定画面から戻る用）
		ActivityHandlingHelper.getInstance().setPreviousOfSettingActivity(this);
		startActivity(intent);
		// ※ 設定画面からログアウトした場合、このActivityも残らないようにfinishして遷移する
		finish();
	}


	/**
	 * コミュニケーションメニューダイアログ
	 */
	public void showCommunicationMenuDialog() {
		mCommunicationMenuDialog = new Dialog(this);
		mCommunicationMenuDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
		mCommunicationMenuDialog.setCanceledOnTouchOutside(false);
		mCommunicationMenuDialog.setContentView(R.layout.communication_menu_dialog);

		List<PushMessageDto> pushMessageDtoList = pushMessageLogic.getAllPushMessageList();

		boolean existUnreadFlg = false;
		for (PushMessageDto pushMessageDto : pushMessageDtoList) {
			if (!pushMessageDto.readingFlg) {
				existUnreadFlg = true;
				break;
			}
		}

		ImageView ivIcon = (ImageView)mCommunicationMenuDialog.findViewById(R.id.btn_push_message_list);

		if (existUnreadFlg) {
			ivIcon.setBackgroundResource(R.drawable.ic_communication_push_message_list_with_badge);
		} else {
			ivIcon.setBackgroundResource(R.drawable.ic_communication_push_message_list);
		}

		LinearLayout ll_menuItem_meeting = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_meeting);
		ll_menuItem_meeting.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				ActivityHandlingHelper.getInstance().startMeetingActivity();
				mCommunicationMenuDialog.dismiss();
			}
		});

		LinearLayout ll_menuItem_push_message = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_push_message);
		ll_menuItem_push_message.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				showOperationSelectDialog();
				mCommunicationMenuDialog.dismiss();
			}
		});

		LinearLayout ll_menuItem_push_message_list = (LinearLayout)mCommunicationMenuDialog.findViewById(R.id.ll_item_push_message_list);
		ll_menuItem_push_message_list.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				showPushMessageListDialog();
				mCommunicationMenuDialog.dismiss();
			}
		});

		mCommunicationMenuDialog.findViewById(R.id.close_btn).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				mCommunicationMenuDialog.dismiss();
			}
		});

		mCommunicationMenuDialog.show();
	}

	private void showOperationSelectDialog() {
		OperationDao operationDao = AbstractDao.getDao(OperationDao.class);
		mOperationSelectDialog = new Dialog(this);
		mOperationSelectDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
		mOperationSelectDialog.setCanceledOnTouchOutside(false);
		mOperationSelectDialog.setContentView(R.layout.operation_select_dialog);
		mOperationSelectListView = (ListView) mOperationSelectDialog.findViewById(R.id.lv_operation_select);
		List<OperationDto> operationDtoList = operationDao.getAllOperation();
		mOperationSelectAdapter = new OperationSelectAdapter(this, operationDtoList);
		mOperationSelectListView.setAdapter(mOperationSelectAdapter);

		mOperationSelectListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
				OperationDto operationDto = mOperationSelectAdapter.getItem(position);
				showPushMessageSendDialog(operationDto);
				mOperationSelectDialog.dismiss();
			}
		});

		// リソースパターンを適用
		TextView operationSelect = (TextView) mOperationSelectDialog.findViewById(R.id.tv_toolbar_title);
		operationSelect.setText(PatternStringUtil.patternToInt(getApplicationContext(),
				R.string.operation_select,
				getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));

		mOperationSelectDialog.findViewById(R.id.close_btn).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				mOperationSelectDialog.dismiss();
			}
		});

		mOperationSelectDialog.show();
	}

	/**
	 * プッシュメッセージダイアログ表示
	 */
	private void showPushMessageListDialog() {
		mPushMessageListDialog = new Dialog(this);
		mPushMessageListDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
		mPushMessageListDialog.setCanceledOnTouchOutside(false);
		mPushMessageListDialog.setContentView(R.layout.push_message_list_dialog);
		mPushMessageListView = (ListView) mPushMessageListDialog.findViewById(R.id.lv_push_message);

		final List<PushMessageDto> pushMessageDtoList = pushMessageLogic.getAllPushMessageList();
		mPushMessageListAdapter = new PushMessageListAdapter(this, pushMessageDtoList);
		mPushMessageListView.setAdapter(mPushMessageListAdapter);

		mPushMessageListAdapter.setAdapterListener(new PushMessageListAdapter.PushMessageListAdapterListener() {
			@Override
			public void onDetailView(final PushMessageDto dto) {
				showPushMessageDetailView(dto);

				// プッシュメッセージで未読がなければ、下辺ツールバーのコミュニケーションボタンのバッジを外す
				List<PushMessageDto> checkPushMessageList = mPushMessageListAdapter.getItems();
				if (!checkUnReadCommunication(checkPushMessageList)) {
					communicationButton.setImageResource(R.drawable.ic_communication_menu);
				}
			}
		});
		mPushMessageListView.invalidate();
		mPushMessageListView.setClickable(false);

		mPushMessageListDialog.findViewById(R.id.back_btn).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				List<PushMessageDto> pushMessageDtoList = pushMessageLogic.getAllPushMessageList();
				mPushMessageListAdapter.setItem(pushMessageDtoList);
				showPushMessgeListView(true);
			}
		});

		mPushMessageListDialog.findViewById(R.id.close_btn).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				mPushMessageListDialog.dismiss();
			}
		});

		showPushMessgeListView(true);
		mPushMessageListDialog.show();
	}

	// プッシュメッセージの詳細表示
	private void showPushMessageDetailView(final PushMessageDto dto) {
		dto.readingFlg = true;

		TextView messageTextView = (TextView)mPushMessageListDialog.findViewById(R.id.tv_message);
		TextView sendDateTextView = (TextView)mPushMessageListDialog.findViewById(R.id.tv_send_date);
		TextView sendOperationNameTextView = (TextView)mPushMessageListDialog.findViewById(R.id.tv_operation_name);
		TextView sendUserTextView = (TextView)mPushMessageListDialog.findViewById(R.id.tv_send_user);
		messageTextView.setText(dto.pushMessage);
		sendDateTextView.setText(DateTimeUtil.toString(dto.pushSendDate, DateTimeFormat.yyyyMMddHHmm_slash));
		sendOperationNameTextView.setText(dto.operationName);
		sendUserTextView.setText(dto.pushSendLoginId);

		pushMessageLogic.updateReadingFlg(dto.pushMessageId);
		showPushMessgeListView(false);
	}

	// プッシュメッセージの一覧表示
	private void showPushMessgeListView(boolean pushMessageListViewFlg) {
		TextView titleTextView = (TextView)mPushMessageListDialog.findViewById(R.id.tv_toolbar_title);
		if (pushMessageListViewFlg) {
			mPushMessageListView.setVisibility(View.VISIBLE);
			mPushMessageListDialog.findViewById(R.id.close_btn).setVisibility(View.VISIBLE);
			mPushMessageListDialog.findViewById(R.id.back_btn).setVisibility(View.GONE);
			mPushMessageListDialog.findViewById(R.id.ll_detail).setVisibility(View.GONE);
			// リソースパターンの適用
			titleTextView.setText(PatternStringUtil.patternToString(getApplicationContext(),
					R.string.push_message_list,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
		} else {
			mPushMessageListView.setVisibility(View.GONE);
			mPushMessageListDialog.findViewById(R.id.close_btn).setVisibility(View.VISIBLE);
			mPushMessageListDialog.findViewById(R.id.back_btn).setVisibility(View.VISIBLE);
			mPushMessageListDialog.findViewById(R.id.ll_detail).setVisibility(View.VISIBLE);
			// リソースパターンの適用
			titleTextView.setText(PatternStringUtil.patternToString(getApplicationContext(),
					R.string.title_message_detail,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
		}
	}

	/**
	 * プッシュメッセージ送信ダイヤログ表示
	 */
	private void showPushMessageSendDialog(final OperationDto operationDto) {
		mPushMessageSendDialog = new Dialog(this);
		mPushMessageSendDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
		mPushMessageSendDialog.setCanceledOnTouchOutside(false);
		mPushMessageSendDialog.setContentView(R.layout.push_message_send_dialog);
		mFixPushMessageListView = (ListView) mPushMessageSendDialog.findViewById(R.id.listView);


		mPushMessageSendDialog.findViewById(R.id.back_btn).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				showOperationSelectDialog();
				mPushMessageSendDialog.dismiss();
			}
		});

		mPushMessageSendDialog.findViewById(R.id.close_btn).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				mPushMessageSendDialog.dismiss();
			}
		});

		mPushMessageSendDialog.findViewById(R.id.send_btn).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				sendPushMessageRequest(operationDto.operationId);
			}
		});

		RadioGroup searchTarget = (RadioGroup) mPushMessageSendDialog.findViewById(R.id.send_target_group);
		searchTarget.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(RadioGroup group, int checkedId) {
				if (checkedId == R.id.in_gourp) {
					mSendType = Constant.PushMessageSendType.InGroup;
				} else {
					mSendType = Constant.PushMessageSendType.AllOperation;
				}
			}
		});

		mPushMessageSendDialog.findViewById(R.id.fix_push_message_layout).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				showFixPushMessageView();
			}
		});

		TextView messageTitleTextView = (TextView) mPushMessageSendDialog.findViewById(R.id.message_title);
		// リソースパターンの適用
		messageTitleTextView.setText(PatternStringUtil.patternToString(getApplicationContext(),
				R.string.free_input,
				getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)) + " > ");

		TextView tvOperationName = (TextView) mPushMessageSendDialog.findViewById(R.id.operation_name);
		tvOperationName.setText(operationDto.operationName);

		mPushMessageSendDialog.show();
	}

	/**
	 * プッシュメッセージ送信画面、定型文一覧画面切り替え
	 * @param sendPushMessageViewFlg (true : プッシュメッセージ送信画面、false : 定型文一覧画面)
	 */
	private void showSendPushMessgeView(boolean sendPushMessageViewFlg) {
		if (sendPushMessageViewFlg) {
			mFixPushMessageListView.setVisibility(View.GONE);
			mPushMessageSendDialog.findViewById(R.id.back_btn).setVisibility(View.GONE);

			mPushMessageSendDialog.findViewById(R.id.push_send_layout).setVisibility(View.VISIBLE);
			mPushMessageSendDialog.findViewById(R.id.close_btn).setVisibility(View.VISIBLE);
			EditText messageEditText = (EditText) mPushMessageSendDialog.findViewById(R.id.message);
			KeyboardUtils.show(this, messageEditText);
		} else {
			mFixPushMessageListView.setVisibility(View.VISIBLE);
			mPushMessageSendDialog.findViewById(R.id.back_btn).setVisibility(View.VISIBLE);

			mPushMessageSendDialog.findViewById(R.id.push_send_layout).setVisibility(View.GONE);
			mPushMessageSendDialog.findViewById(R.id.close_btn).setVisibility(View.GONE);
		}
	}

	/**
	 * プッシュメッセージ送信依頼
	 */
	private void sendPushMessageRequest(long operationId) {
		if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
			ABVToastUtil.showMakeText(this, R.string.request_network_connection, Toast.LENGTH_SHORT);
			return;
		}
		//文字列チェック
		EditText messageEditText = (EditText) mPushMessageSendDialog.findViewById(R.id.message);
		String message = messageEditText.getText().toString();

		String checkMessage = message.replace(" ", "");
		if (checkMessage.length() == 0) {
			// リソースパターンの適用
			ABVToastUtil.showMakeText(this, PatternStringUtil.patternToString(getApplicationContext(),
					R.string.push_message_input_null,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
			return;
		}
		byte[] messageByte = message.getBytes(StandardCharsets.UTF_8);
		if (messageByte.length >= 207) {
			// リソースパターンの適用
			ABVToastUtil.showMakeText(this, PatternStringUtil.patternToString(getApplicationContext(),
					R.string.push_message_input_over,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
			return;
		}

		// リソースパターンの適用
		ProgressDialogHelper.showProgressPopup(this, true, PatternStringUtil.patternToString(getApplicationContext(),
				R.string.file_initialization,
				getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
		try {
			boolean result = pushMessageLogic.sendPushMessageRequest(mSendType, message, operationId);
			if (result) {
				mPushMessageSendDialog.dismiss();
				// リソースパターンの適用
				ABVToastUtil.showMakeText(this, PatternStringUtil.patternToString(getApplicationContext(),
						R.string.push_message_send_success,
						getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
			} else {
				// リソースパターンの適用
				ABVToastUtil.showMakeText(this, PatternStringUtil.patternToString(getApplicationContext(),
						R.string.push_message_send_fail,
						getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
			}
		} catch (Exception e) {
			Logger.e(TAG, e);
			// リソースパターンの適用
			ABVToastUtil.showMakeText(this, PatternStringUtil.patternToString(getApplicationContext(),
					R.string.push_message_send_fail,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
		} finally {
			ProgressDialogHelper.closeProgressPopup();
		}
	}

	private void showFixPushMessageView() {
		if (!ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
			ABVToastUtil.showMakeText(this, R.string.request_network_connection, Toast.LENGTH_SHORT);
			return;
		}
		EditText messageEditText = (EditText) mPushMessageSendDialog.findViewById(R.id.message);
		KeyboardUtils.hide(this, messageEditText);

		// リソースパターンの適用
		ProgressDialogHelper.showProgressPopup(this, true, PatternStringUtil.patternToString(getApplicationContext(),
				R.string.file_initialization,
				getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
		try {
			List<FixPushMessageDto> fixPushMessageList = pushMessageLogic.getFixPushMessage();
			FixPushMessageDto dto = new FixPushMessageDto();
			// リソースパターンの適用
			dto.name = PatternStringUtil.patternToString(getApplicationContext(),
					R.string.free_input,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
			fixPushMessageList.add(0, dto);
			mFixPushMessageListView.setAdapter(new FixPushMessageAdapter(this, fixPushMessageList, mSelectedFixPuchMessagePosition));
			mFixPushMessageListView.invalidate();
			mFixPushMessageListView.setClickable(true);
			mFixPushMessageListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
				@Override
				public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
					mSelectedFixPuchMessagePosition = position;
					FixPushMessageDto item = (FixPushMessageDto)parent.getItemAtPosition(position);

					TextView messageTitleTextView = (TextView) mPushMessageSendDialog.findViewById(R.id.message_title);
					messageTitleTextView.setText(item.name + " > ");

					EditText messageEditText = (EditText) mPushMessageSendDialog.findViewById(R.id.message);
					messageEditText.setText(item.value);
					messageEditText.setSelection(messageEditText.getText().length());

					showSendPushMessgeView(true);
				}
			});
			showSendPushMessgeView(false);
		} catch (Exception e) {
			Logger.e(TAG, e);
			// リソースパターンの適用
			ABVToastUtil.showMakeText(this, PatternStringUtil.patternToString(getApplicationContext(),
					R.string.respons_fix_push_message_fail,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
		} finally {
			ProgressDialogHelper.closeProgressPopup();
		}
	}

	// コミュニケーションのアイコン設定（未既読があれば、バッチ付きアイコンでセット）
	protected void setCommunicationImageButton() {
		List<PushMessageDto> pushMessageDtoList = pushMessageLogic.getAllPushMessageList();
		boolean existUnreadFlg = checkUnReadCommunication(pushMessageDtoList);
		communicationButton.setImageResource(existUnreadFlg ? R.drawable.ic_communication_menu_with_badge : R.drawable.ic_communication_menu);
	}

	/**
	 * 未読のプッシュメッセージが存在するかチェック
	 * @param pushMessageDtoList チェックするリスト
	 * @return
	 */
	private boolean checkUnReadCommunication(List<PushMessageDto> pushMessageDtoList) {
		boolean existUnreadFlg = false;
		for (PushMessageDto pushMessageDto : pushMessageDtoList) {
			if (!pushMessageDto.readingFlg) {
				existUnreadFlg = true;
				break;
			}
		}
		return existUnreadFlg;
	}
}
