package jp.agentec.abook.abv.ui.common.appinfo;

public interface AppDefType {
	String APP_PACKAGE = "jp.agentec.abook.abv.launcher.android";

	interface PrefName {
		String USER_PREFERENCE = "user_info";
	}

	interface ViewMode{
		int PANEL = 0;
		int LIST = 1;
	}

	// 作業種別モードフラグ
	interface OperationLocationType {
		int ALL = 0;
		int CATEGORY = 1;
	}
	
	interface DefPrefKey {
		String REPEATABLE_PLAY = "repeatablePlay";
		String WIFI_ALERT_ENABLE = "wifiAlertEnable";
		String PERMISSION_ACCESS_LOCATION = "permissionAccessLocation";
		String CURSOR_ENABLE = "cursorEnable";
		String DISPLAY_MARKING = "displayMarking";
        String APP_VERSIONUP_PROCESSING = "appVersionProcessingFlag";
	}

	interface UserPrefKey {
		String GUEST_LOGIN = "gl";
		String CHECK_NEW_VERSION_DATE = "checkNewVersionDate";
		String LEAVE_APP = "leaveApp";
		String LAST_UPDATE_TIME = "lastUpdateTime";
		String DEVICE_UUID = "deviceUuid";
		
		String AGREE_MACINFO = "agreeMacInfo";
		String SHOWED_PERMISSION_ACCESS_LOCATION_ALERT = "showedPermissionAccessLocationAlert";

		String MEETING_ENTERED_TIME = "meetingEnteredTime";
		String MEETING_ENTERED_FLG = "meetingEnteredFlg";
		String MEETING_PASSWORD = "meetingPassword";
		String MEETING_ID = "meetingId";
		String SKEY = "skey";

		String PDF_IMAGE_SIZE = "pdfImageSize";
        String SIGNAGE_HEIGHT = "sh";
        String SIGNAGE_WIDTH = "sw";

		String NEED_SEND_TOKEN = "needSendToken";

		String MONITOR_TOUCH_MODE = "monitorTouchMode";

		String CHAIRMAN_MARKING_SHARE = "chairmanMarkingShareFlag";
		String MEETING_MARKING_AUTO_SAVE = "meetingMarkingAutoSaveFlag";

		String ALL_PERMISSION_CHECK = "appPermissionCheck";
		String SYNC_TARGET_OPERATION_ID = "syncTargetOperationId";
        String SYNCED_OPERATION_ID = "syncedOperationId_%d";//一日一回情報更新が出来るように

		String VIEW_MODE = "viewMode";

		String RESOURCE_PATTERN_TYPE = "resourcePatternType"; // 文言リソースパターン

		String OPERATION_GROUP_MASERT_MODE = "operation_group_master"; // 通常・作業種別モード（画面）
		String OPERATION_GROUP_MASERT_ID = "operation_group_master_id"; // 作業種別のID

		String OPERATION_SORT_CONDITION = "operation_sort_condition"; // 作業のソート

		String APERTURE_MASTER_DATA_FETCH_DATE = "apertureMasterDataFetchDate";  // 絞り検索マスタデータのFetchDate
		String MASTER_DATA_FETCH_DATE = "masterDataFetchDate";  // マスタデータのFetchDate
	}

	interface SubMenuType {
		int CONTENT_DETAIL_OPEN = 0;		// コンテンツ詳細画面
		int CONTENT_OPEN = 1;				// コンテンツ閲覧
		int CONTENT_STREAMING = 2;		// コンテンツストリーミング（Webで開く）
		int CONTENT_DOWNLOAD = 3;			// コンテンツダウンロード
		int CONTENT_DOWNLOAD_CANCEL = 4;	// コンテンツダウンロードキャンセル
		int CONTENT_UPDATE = 5;			// コンテンツアップデート
		int CONTENT_DELETE = 6;			// コンテンツ削除
		int USER_INFO_COPY = 7;			// ユーザ情報コピー
		int USER_INFO_PASTE = 8;			// ユーザ情報貼り付け
		int MYFOLDER_ADD = 9;				// マイフォルダ追加
		int FAVORITE_ADD = 10;				// お気に入り追加
		int FAVORITE_DELETE = 11;			// お気に入り削除
		int SHARE_CONTENT = 12;			// 共有
	}

	interface SideMenuType {
		int MENU_CONTENT = 0;
		int MENU_GROUP = 1;
		int MENU_CATEGORY = 2;
		int MENU_MYFOLDER = 3;
		int MENU_MYDATA = 4;
		int MENU_DASHBOARD = 5;
		int MENU_MEETING = 6;
		int MENU_SETTING = 7;
		int MENU_PUBLISHER = 8;
		int MENU_CONTENT_DEVICE = 9;
		int MENU_FAVORITE = 10;

		interface SideMenuMyDataSubType {
			String SUB_MENU_BOOKMARK = "bookmark";
			String SUB_MENU_MEMO = "memo";
			String SUB_MENU_READINGDATE = "readingdate";
		}
	}

	interface ContentTypeId {
		int PDF_TYPE_ID = 0;
		int MOVIE_TYPE_ID = 1;
		int IMAGE_TYPE_ID = 2;
		int MUSIC_TYPE_ID = 3;
		int HTML_TYPE_ID = 4;
		int LINK_TYPE_ID = 5;
		int NONE_TYPE_ID = 6;
		int OTHER_TYPE_ID = 7;
		int ENQUETE_TYPE_ID = 8;
		int EXAM_TYPE_ID = 9;
		int PANO_MOVIE_TYPE_ID = 12;
		int PANO_IMAGE_TYPE_ID = 13;
		int OBJECTVR_TYPE_ID = 14;
	}

	interface PushMessageKey {
		String message = "message";
		String data = "data";
        String operationId = "operationId";
	}

	interface UrlPattern {
		String smart360 = "smart360";
	}
}
