package jp.agentec.abook.abv.ui.viewer.activity;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import java.io.File;
import java.util.Date;

import jp.agentec.abook.abv.bl.acms.client.json.DownloadedContentInfoJSON;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.home.helper.OzdFileHelper;
import jp.agentec.abook.abv.launcher.android.PDFFileProvider;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVContentViewActivity;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.helper.ProgressDialogHelper;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;
import oz.api.OZReportAPI;
import oz.api.OZReportCommandListener;
import oz.api.OZReportViewer;

import static jp.agentec.abook.abv.cl.util.PreferenceUtil.getUserPref;
import static org.chromium.base.ContextUtils.getApplicationContext;

/**
 * ABook Report(仮)ビュアー
 * ① 原本ozdファイル (暗号化されてない)
 * ・コンテンツを保存したことがない
 * cache/{contentsID}/{Filename}.ozd

 * ② 変更本ozdファイル (暗号化されてない)
 * ・コンテンツを一回でも保存したことがある
 * files/ABook/contents/ozd/{contentID}}/{Filename}.ozd
 *
 * ③　保存PDFファイル
 * cache/{contentsID}/{Filename}.pdf
 */
public class CheckOZDViewActivity extends ABVContentViewActivity {
    private static final String TAG = "CheckOZDViewActivity";
    private static final long MAX_PDF_SIZE = 20 * 1024 * 1024; // 20M

    private final Context mContext = CheckOZDViewActivity.this;
    private OZReportViewer mOzReportViewer;
    private String mOzdFileName;

    private static boolean mIsSkiaLoad;
    private static boolean mIsViewerLoad;
    private int mTaskReportId;
    private String mReportStartDate;
    private String mReportFileName;
    private boolean mReadOnlyFlg;
    private String mOzFilePath;
    private String mOzFileName;
    private String mSaveOzdTempFileName;
    private String mSaveOzdFileName;

    // #32926 作業報告画面改善 start
    private int mTaskReportLevel;  // 作業報告レベル
    boolean mIsOzFilePath;  // 削除処理のフラグ
    boolean mLocalSave;  // 一時保存フラグ
    // #32926 作業報告画面改善 end

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG, "onCreate");

        super.onCreate(savedInstanceState);
        setContentView(R.layout.ac_ozd_webview);
        super.readingLogFlg = false;

        Intent intent = getIntent();
        super.contentId = intent.getLongExtra(ABookKeys.CONTENT_ID, -1);
        mOperationId = intent.getLongExtra(ABookKeys.OPERATION_ID, -1);
        mTaskKey = intent.getStringExtra(ABookKeys.TASK_KEY);
        mReadOnlyFlg = intent.getBooleanExtra(ABookKeys.READ_ONLY_FLG, false);
        mTaskReportId = intent.getIntExtra(ABookKeys.TASK_REPORT_ID, 0);
        mReportStartDate = intent.getStringExtra(ABookKeys.REPORT_START_DATE);
        mReportFileName = intent.getStringExtra(ABookKeys.REPORT_FILE_NAME);

        // #32926 作業報告画面改善 start
        mTaskReportLevel = intent.getIntExtra(ABookKeys.TASK_REPORT_LEVEL, 0);  // 作業報告レベル
        // #32926 作業報告画面改善 end

        String frontTitle = "";
        String rearTitle = "";

        // TODO リソース変更
            // リソースパターンの適用

        TextView tvTitle = (TextView) findViewById(R.id.tv_title);

        // OZ閲覧画面に表示するボタン表示の可否設定
        // 一時保存情報についてボタン表示：「0:false、一時保存ボタン非表示」「1:ture、一時保存ボタン表示」
        mLocalSave = intent.getBooleanExtra(ABookKeys.LOCAL_SAVE, false);
        // 作業追加区分についてボタンを表示：「0:false、作業追加区分なし、作業一覧へボタン」「1:ture、作業追加区分あり、閉じるボタン」
        mAddReport = intent.getBooleanExtra(ABookKeys.ADD_REPORT, true);

        final Button homeButton = (Button) findViewById(R.id.btn_operation_home);
        final Button closeButton = (Button) findViewById(R.id.btn_close);
        final Button tempSaveButton = (Button) findViewById(R.id.btn_temp_save);
        final Button saveButton = (Button) findViewById(R.id.btn_save);
        final Button deleteButton = (Button) findViewById(R.id.btn_delete);

        frontTitle = PatternStringUtil.patternToString(getApplicationContext(),
                R.string.work_report,
                getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));

        if (mReadOnlyFlg) {
            // プレビューの場合

            // リソースパターンの適用
            rearTitle = PatternStringUtil.patternToString(getApplicationContext(),
                    R.string.title_preview,
                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));
            // クローズボタン以外非表示
            closeButton.setVisibility(View.VISIBLE);
            homeButton.setVisibility(View.GONE);
            tempSaveButton.setVisibility(View.GONE);
            deleteButton.setVisibility(View.GONE);
            saveButton.setVisibility(View.GONE);
        } else {
            // プレビューではない場合

            rearTitle = PatternStringUtil.patternToString(getApplicationContext(),
                    R.string.title_input,
                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0));

            // 一時ボタン表示可否判断
            homeButton.setVisibility(mAddReport ?  View.GONE : View.VISIBLE);
            closeButton.setVisibility(mAddReport ? View.VISIBLE : View.GONE);
            tempSaveButton.setVisibility(mLocalSave ? View.VISIBLE : View.GONE);

            // 削除ボタン表示可否判断
            mIsOzFilePath = OzdFileHelper.checkOzFilePath(mOperationId, mTaskKey, mTaskReportId, mReportStartDate, mReportFileName, mTaskReportLevel);
            deleteButton.setVisibility(mIsOzFilePath ? View.VISIBLE : View.GONE);
        }
        // タイトルセット
        tvTitle.setText(frontTitle + rearTitle);

        // 作業一覧へ戻るボタン
        homeButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                goToMain();  // 作業一覧画面に遷移
            }
        });

        // 閉じるボタン
        closeButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mButtonStatus = R.id.btn_close;  // HTML側の分岐処理を行うため変数に値を渡す
                doProcess();  // HTML側の処理を行う
            }
        });

        // 一時保存ボタン
        tempSaveButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mButtonStatus = R.id.btn_temp_save;  // HTML側の分岐処理を行うため変数に値を渡す
                // リソースパターンの適用
                showSaveConfirmAlert(PatternStringUtil.patternToInt(getApplicationContext(),
                                        R.string.temp_save,
                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                                    PatternStringUtil.patternToInt(getApplicationContext(),
                                        R.string.temp_save_info,
                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
            }
        });

        // 保存ボタン
        saveButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mButtonStatus = R.id.btn_save;  // HTML側の分岐処理を行うため変数に値を渡す
                // リソースパターンの適用
                showSaveConfirmAlert(PatternStringUtil.patternToInt(getApplicationContext(),
                                        R.string.save,
                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                                    PatternStringUtil.patternToInt(getApplicationContext(),
                                        R.string.save_info,
                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
            }
        });

        // 削除ボタン
        deleteButton.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                mButtonStatus = R.id.btn_delete;  // HTML側の分岐処理を行うため変数に値を渡す
                // リソースパターンの適用
                showSaveConfirmAlert(PatternStringUtil.patternToInt(getApplicationContext(),
                                        R.string.delete,
                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)),
                                    PatternStringUtil.patternToInt(getApplicationContext(),
                                        R.string.delete_info,
                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
            }
        });

        mOzFilePath = OzdFileHelper.getOzFilePath(mOperationId, contentId, mTaskKey, mTaskReportId, mReportStartDate, mReportFileName, mTaskReportLevel);

        Logger.i(TAG,"********mOzFilePath = %s" + mOzFilePath);
        if (mOzFilePath == null) {
            ABVToastUtil.showMakeText(this, "ozFilePath null", Toast.LENGTH_LONG);
            return;
        }

        File file = new File(mOzFilePath);
        mOzFileName =  file.getName();
        mSaveOzdFileName = OzdFileHelper.getSaveOzFileName(mReportFileName);
        mSaveOzdTempFileName = FileUtil.getFilenameWithoutExt(mSaveOzdFileName) + "_tmp.ozd";
        if (!loadOzdDocument(file)) {
            ABVToastUtil.showMakeText(this, "OZD Load Fail", Toast.LENGTH_LONG);
            return;
        }
    }

    private boolean loadOzdDocument(File file) {
        if (mOzReportViewer != null) {
            mOzReportViewer.dispose();
            mOzReportViewer = null;
        }
        return openViewer(getParameter(file));
    }

    private String getParameter(File file) {
        String strParam = null;
        if (file.getPath().indexOf("ozd") > 0) {
            strParam = "connection.openfile=" + file.getPath() + "#";
        } else {
            strParam = "connection.formfromserver=false#";
            strParam += "connection.reportname=" + mOzFileName + "#";
            strParam += "repository_agent.local.root_path=" + file.getParent() + "#";
        }

        strParam += "viewer.exportcommand=true#";
        strParam += "toolbar.etc=false#";
        strParam += "eform.inputeventcommand=true#";
        strParam += "eform.imagepicker_camera_show_choose_button=true#";

        return strParam;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(mOzReportViewer != null) {
            //requestCode: 呼び出されたActivityに対する識別コード
            //resultCode: ユーザーの操作の結果コード
            //data: ギャラリーで選択したイメージ情報のIntent
            mOzReportViewer.onActivityResult(this, requestCode, resultCode, data);
        }
    }

    private boolean openViewer(String param) {
        if (!(mIsSkiaLoad && mIsViewerLoad)) {
            if (!loadLibrary()) {
                // load失敗
                return false;
            }
        }
        if (mIsSkiaLoad && mIsViewerLoad) {
            ViewGroup viewGroup = (ViewGroup) findViewById(R.id.ozd_layout);
            mOzReportViewer = OZReportAPI.createViewer(viewGroup, new OZReportCommandListenrEx(), param, "#");
            if (mOzReportViewer == null || mOzReportViewer.Document() == null) {
                return false;
            }
        } else {
            Logger.w(TAG, "failed to get library for OZD");
            return false;
        }
        return true;
    }

    private boolean loadLibrary() {
        if (!mIsSkiaLoad) {
            try {
                System.loadLibrary("skia_android");
                mIsSkiaLoad = true;
            } catch (Throwable e) {
                Logger.e(TAG, "[loadLibrary]:skia_android:", e);
                return false;
            }
        }
        if (!mIsViewerLoad) {
            try {
                System.loadLibrary("ozrv");
                mIsViewerLoad = true;
            } catch (Throwable e) {
                Logger.e(TAG, "[loadLibrary]:ozrv:", e);
                return false;
            }
        }
        return true;
    }

    private class OZReportCommandListenrEx extends OZReportCommandListener {
        @Override
        public void OZExportCommand(String s, String s1, String s2, String s3, String s4) {
            Logger.i("OZExportCommand", String.format("%s %s %s %s", s1, s2, s3, s4));
        }
    }

    private String getSaveParam(String format) {
        StringBuilder builder = new StringBuilder();
        builder.append("export.mode=silent#");
        builder.append("export.filename=" + FileUtil.getFilenameWithoutExt(mOzdFileName));
        builder.append("#");
        if (format.equals("ozd")) {
            String ozdPath = ABVEnvironment.getInstance().getSavedOzdDirectoryPath(contentId, true);
            builder.append("export.path=" + ozdPath);      //ozd
        } else {
            String cachePath = ABVEnvironment.getInstance().getContentCacheDirectoryPath(contentId);
            builder.append("export.path=" + cachePath);    //pdf
        }
        builder.append("#export.confirmsave=false#export.format=");
        builder.append(format);
        builder.append("#");
        return builder.toString();
    }

    private boolean exportViewer(String param) {
        if (mOzReportViewer != null) {
            mOzReportViewer.ScriptEx("save", param, "#");
            return true;
        } else {
            Logger.w(TAG, "mOzReportViewer doesn't exist");
            // リソースパターンの適用
            ABVToastUtil.showMakeText(mContext, PatternStringUtil.patternToInt(getApplicationContext(),
                                                    R.string.no_ozd_viewer,
                                                    getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_SHORT);
            return false;
        }
    }

    @Override
    protected void onDestroy() {
        Logger.d(TAG, "onDestroy");
        super.onDestroy();
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            if (mAddReport) {
                ozdCancelProcess(); // Ozd作業画面を閉じる
            } else {
                // 作業追加区分がなしの場合
                showBackConfirmDialog(true);
            }
        } else {
            return super.onKeyUp(keyCode, event);
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void finishActivity() {
        finish();
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    private void sendPDF(DownloadedContentInfoJSON json) {        // PDFファイルメールで送信
        PDFFileProvider.expired = DateTimeUtil.add(new Date(), DateTimeUtil.DateUnit.Minute, 60);

        String filePath = getOriginFilePath(getPdfFileName());

        File pdfFile = new File(filePath);

        final Uri fileUri = Uri.parse("content://" + getPackageName() + ".pdffileprovider/" + contentId + "/" + getPdfFileName());
        long pdfFileSize = pdfFile.length();

        if (pdfFileSize > MAX_PDF_SIZE) {
            ABVToastUtil.showMakeText(mContext, R.string.mail_size_over, Toast.LENGTH_SHORT);
        } else {
            Intent intent = new Intent(Intent.ACTION_SEND);
            intent.setType("plain/text");
            intent.putExtra(Intent.EXTRA_SUBJECT, json.contentName);
            intent.putExtra(Intent.EXTRA_TEXT, json.contentName + getResources().getString(R.string.send_to));
            intent.putExtra(Intent.EXTRA_STREAM, fileUri);
            intent.addFlags(Intent.FLAG_GRANT_PERSISTABLE_URI_PERMISSION);
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            startActivity(intent);
        }
    }

    private void functionWithServerPopup(View v) {
//        mShowedPopupWindow = new ABVPopupListWindow(mContext);
//        int width = isNormalSize() ? getRDimensionSize(R.dimen.popup_size_normal) : getRDimensionSize(R.dimen.popup_size_large);
//        mShowedPopupWindow.setWidth(width);
//
//        ArrayList<String> menuNameList = new ArrayList<>(Arrays.asList(getRStringArray(R.array.ozd_upload)));
//
//        mShowedPopupWindow.setRepresentNames(menuNameList);
//        mShowedPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener() {
//            @Override
//            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
//                switch (position) {
//                    case 0:
//                        showDataSendToServerDialog();
//                        break;
//                    default:
//                        checkSyncFile();
//                        break;
//                }
//                mShowedPopupWindow.dismiss();
//            }
//        });
//
//        mShowedPopupWindow.showAsDropDown(v);
    }

    private void showDataSendToServerDialog() {
//        ABookAlertDialog alert = AlertDialogUtil.createAlertDialog(this, getString(R.string.send_data), getString(R.string.data_submit));
//        alert.setNegativeButton(R.string.no, null);
//        alert.setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
//            @Override
//            public void onClick(DialogInterface dialog, int which) {
//                dialog.dismiss();
//                if (exportViewer(getSaveParam("pdf"))) {   //pdf取得
//                    ProgressDialogHelper.showProgressPopup(CheckOZDViewActivity.this, true);    // Progressダイアログ表示
//                    String pdfPath = getOriginFilePath(getPdfFileName());
//                    String jsonData = mOzReportViewer.GetInformation("INPUT_JSON_ALL");    //データ取得
//                    String sendTime = DateTimeUtil.getCurrentUTCString(DateTimeFormat.yyyyMMddHHmmss_hyphen);    // okボタンをタップした時間取得
//                    int fileType = 1; // pdfType
//                    sendOzdDataToServer(contentId, objectId, pdfPath, jsonData, sendTime, fileType);
//                }
//            }
//        });
//        alert.show();
    }

    /**
     * 同期処理を行う。
     */
    private void checkSyncFile() {
        ProgressDialogHelper.showProgressPopup(CheckOZDViewActivity.this, false);    // Progressダイアログ表示
        CommonExecutor.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String fileDate = OzdFileHelper.getOzdFileDate(contentId, objectId);
                    ProgressDialogHelper.closeProgressPopup();
                    boolean isUpload = false;
                    if (StringUtil.isNullOrEmpty(fileDate)) {
                        isUpload = true;
                    }

                    if (isUpload) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                sendOzdFileToServerDialog();
                            }
                        });
                    } else {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                sendOzdFileToServerDialog();
                            }
                        });
                    }
                } catch (NetworkDisconnectedException e) {
                    e.printStackTrace();
                } catch (AcmsException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void downloadOzdFileFromServerDialog() {
//        ABookAlertDialog alert = AlertDialogUtil.createAlertDialog(this, getString(R.string.confirm), getString(R.string.download_ozd_file));
//        alert.setNegativeButton(R.string.no, null);
//        alert.setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
//            @Override
//            public void onClick(DialogInterface dialog, int which) {
//                dialog.dismiss();
//                try {
//                    String savedPath = getSavedFilePath(mOzdFileName);
//                    String tempPath = savedPath + ".temp";
//                    OzdFileHelper.downloadOzdFile(contentId, objectId, tempPath);
//                    Logger.d(TAG, "[downloadOzdFileFromServerDialog]");
//                    FileUtil.move(tempPath, savedPath, true);
//                } catch (NetworkDisconnectedException e) {
//                } catch (AcmsException e) {
//                }
//            }
//        });
//        alert.show();
    }

    private void sendOzdFileToServerDialog() {
//        ABookAlertDialog alert = AlertDialogUtil.createAlertDialog(this, getString(R.string.confirm), getString(R.string.upload_ozd_file));
//        alert.setNegativeButton(R.string.no, null);
//        alert.setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
//            @Override
//            public void onClick(DialogInterface dialog, int which) {
//                dialog.dismiss();
//                if (exportViewer(getSaveParam("ozd"))) {   //pdf取得
//                    ProgressDialogHelper.showProgressPopup(CheckOZDViewActivity.this, true);    // Progressダイアログ表示
//                    String ozdFile = getSavedFilePath(mOzdFileName);
//                    String sendTime = DateTimeUtil.getCurrentUTCString(DateTimeFormat.yyyyMMddHHmmss_hyphen);    // okボタンをタップした時間取得
//                    int fileType = 0; // ozdType
//                    sendOzdDataToServer(contentId, objectId, ozdFile, null, sendTime, fileType);
//                }
//            }
//        });
//        alert.show();
    }

    private void sendOzdDataToServer(final long contentId, final long objectId, final String filePath, final String jsonData, final String sendTime, final int fileType) {
//        CommonExecutor.execute(new Runnable() {
//            @Override
//            public void run() {
//                try {
//                    OzdFileHelper.sendOzdToAcms(new File(filePath), jsonData, contentId, objectId, sendTime, fileType);
//                } catch (NetworkDisconnectedException e) {
//                    handler.post(new Runnable() {
//                        @Override
//                        public void run() {
//                            ABVToastUtil.showMakeText(mContext, R.string.NETWORK, Toast.LENGTH_SHORT);
//                        }
//                    });
//                } catch (Exception e) {
//                    Logger.e(TAG, "sendToAcms error", e);
//                    handler.post(new Runnable() {
//                        @Override
//                        public void run() {
//                            ABVToastUtil.showMakeText(mContext, R.string.E107, Toast.LENGTH_SHORT);
//                        }
//                    });
//                }
//                ProgressDialogHelper.closeProgressPopup();     // Progressダイアログ非表示
//            }
//        });
    }

    private void deletePdfinCache() {
        String filePath = getOriginFilePath(getPdfFileName());
        if (FileUtil.exists(filePath)) {
            FileUtil.delete(filePath);
        }
    }

    private String getSavedFilePath(String fileName) {
        return ABVEnvironment.getInstance().getSavedOzdDirectoryPath(contentId, false) + "/" + fileName;
    }

    private String getOriginFilePath(String fileName) {
        return ABVEnvironment.getInstance().getContentCacheDirectoryPath(contentId) + "/" + fileName;
    }

    private String getPdfFileName() {
        return FileUtil.getFilenameWithoutExt(mOzdFileName) + ".pdf";
    }

    private boolean saveTempOzdFile() {
        StringBuilder param = new StringBuilder();
        param.append("export.mode=silent#");
        param.append("export.filename=" + FileUtil.getFilenameWithoutExt(mSaveOzdTempFileName) + "#");
        // #32926 作業報告画面改善 start
        param.append("export.path=" + OzdFileHelper.getTempTaskDirPath(contentId, mTaskKey) + "#");
        // #32926 作業報告画面改善 end
        param.append("export.confirmsave=false#");
        param.append("export.format=ozd");
        int result = mOzReportViewer.ScriptEx("save", param.toString(), "#");
        if (result == -1) {
            Logger.e("temp ozd save fail");
            return false;
        }

        boolean moveSusseccFlg = OzdFileHelper.moveTempOzdFileToOzdFile(contentId, mTaskKey, mSaveOzdTempFileName, mSaveOzdFileName);
        if (!moveSusseccFlg) {
            Logger.e("temp ozd move fail");
            return false;
        }
        return true;
    }

    // アラート表示処理
    private void showSaveConfirmAlert(final int dialogTitle, int dialogMessage) {
        ABookAlertDialog logoutAkert = AlertDialogUtil.createAlertDialog(this, dialogTitle);
        logoutAkert.setMessage(dialogMessage);
        logoutAkert.setButton(DialogInterface.BUTTON_POSITIVE, getResources().getString(R.string.confirm), new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                // 削除ボタン以外には臨時保存処理を行う
                if (mButtonStatus != R.id.btn_delete) {
                    tempSaved();  // 臨時保存処理
                }
                doProcess();  // HTML側の処理を行う
            }
        });
        logoutAkert.setButton(DialogInterface.BUTTON_NEGATIVE, getResources().getString(R.string.cancel), (DialogInterface.OnClickListener) null);
        showAlertDialog(logoutAkert);
    }

    // 臨時保存の処理
    private void tempSaved() {
        if (!mReadOnlyFlg) {
            //OZD臨時保存処理
            if (!saveTempOzdFile()) {
                // リソースパターンの適用
                ABVToastUtil.showMakeText(mContext, PatternStringUtil.patternToString(getApplicationContext(),
                                                        R.string.msg_ozd_save_fail,
                                                        getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), Toast.LENGTH_LONG);
                return;
            }
        }
    }
}