package jp.agentec.abook.abv.ui.viewer.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import android.webkit.WebView;

import jp.agentec.abook.abv.ui.Interface.KeyActionCallback;

/**
 * Created by ogawa-y on 2020/01/21.
 */
public class CheckFormWebview extends WebView {

    private KeyActionCallback enterCallback;

    public CheckFormWebview(Context context, AttributeSet attrs, int defStyle) {   super(context, attrs, defStyle);   }
    public CheckFormWebview(Context context, AttributeSet attrs) {   super(context, attrs);   }
    public CheckFormWebview(Context context) {  super(context);  }
    public void setEnterCallback(KeyActionCallback function){ this.enterCallback = function;   }

    @Override public InputConnection onCreateInputConnection(EditorInfo ei) {
        InputConnection input = super.onCreateInputConnection(ei);
        if(input == null){
            return null;
        }
        return new MyConnection(input);
    }

    private class MyConnection extends InputConnectionWrapper
    {
        public MyConnection(InputConnection wrapped) {
            super(wrapped, false);
        }

        // WebView上でIMEキーボードのアクションがあった場合のハンドリングを行う
        // NOTE バーコード読取は{@link ParentWebviewActivity#dispatchKeyEvent(KeyEvent event) dispatchKeyEvent}でキャッチする
        @Override public boolean performEditorAction(int action) {
            if(action == EditorInfo.IME_ACTION_GO || action == EditorInfo.IME_ACTION_NEXT) {
                if(enterCallback != null) {
                    enterCallback.keyActionCallback();
                }
            }
            return true;
        }
    }
}
