/*
 * Decompiled with CFR 0.152.
 */
package oz.client.shape.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.view.View;
import oz.main.OZStorage;

public class OZMemoLabelView
extends View {
    public float m_left;
    public float m_top;
    public float m_right;
    public float m_bottom;
    public float m_scale;
    public float m_scrollX = 0.0f;
    public float m_scrollY = 0.0f;
    public float m_posX = 0.0f;
    public float m_posY = 0.0f;
    public boolean _isMovable = false;
    public boolean _isEditable = false;
    public boolean _isChangeable = false;
    public boolean _isMemoLabel = false;
    public Drawable _btnSize = OZStorage.getDrawable(this.getContext().getResources().getAssets().open(OZStorage.getImagePath("resource/memo_icon_size@2x.png")));
    public Drawable _btnDelete = OZStorage.getDrawable(this.getContext().getResources().getAssets().open(OZStorage.getImagePath("resource/memo_icon_delete@2x.png")));
    public Drawable _btnSetting = OZStorage.getDrawable(this.getContext().getResources().getAssets().open(OZStorage.getImagePath("resource/memo_icon_setting@2x.png")));
    public static int BUTTON_TYPE_SIZE = 0;
    public static int BUTTON_TYPE_DELETE = 1;
    public static int BUTTON_TYPE_SETTING = 2;
    public static int BUTTON_TYPE_MEMO = 3;

    public OZMemoLabelView(Context context) {
        super(context);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Paint paint = new Paint();
        canvas.save();
        paint.reset();
        paint.setAntiAlias(false);
        float f2 = OZStorage.getDensityDPI();
        float f3 = (float)(6.0 * (double)f2);
        paint.reset();
        paint.setAntiAlias(true);
        paint.setColor(-16776961);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(f3);
        float f4 = (float)(3.0 * (double)f2);
        canvas.drawLine(this.m_left - f4, this.m_top, this.m_right + f4, this.m_top, paint);
        canvas.drawLine(this.m_left, this.m_top, this.m_left, this.m_bottom, paint);
        canvas.drawLine(this.m_right, this.m_top, this.m_right, this.m_bottom, paint);
        canvas.drawLine(this.m_left - f4, this.m_bottom, this.m_right + f4, this.m_bottom, paint);
        int n = (int)(40.0 * (double)f2);
        if (this._isMemoLabel) {
            this._btnDelete.setBounds((int)this.m_left - n, (int)this.m_top - n, (int)this.m_left, (int)this.m_top);
            this._btnDelete.draw(canvas);
        }
        if (this._isEditable || this._isChangeable) {
            this._btnSetting.setBounds((int)this.m_left - n, (int)this.m_bottom, (int)this.m_left, (int)this.m_bottom + n);
            this._btnSetting.draw(canvas);
        }
        if (this._isMovable) {
            this._btnSize.setBounds((int)this.m_right, (int)this.m_bottom, (int)this.m_right + n, (int)this.m_bottom + n);
            this._btnSize.draw(canvas);
        }
        canvas.restore();
    }

    public void setMemoLabelOpt(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._isMovable = bl;
        this._isEditable = bl2;
        this._isChangeable = bl3;
        this._isMemoLabel = bl4;
    }

    public int getHitInButtonType(int n, int n2) {
        int n3 = -1;
        if (this._btnDelete.getBounds().contains(n, n2)) {
            n3 = BUTTON_TYPE_DELETE;
        } else if (this._btnSize.getBounds().contains(n, n2)) {
            n3 = BUTTON_TYPE_SIZE;
        } else if (this._btnSetting.getBounds().contains(n, n2)) {
            n3 = BUTTON_TYPE_SETTING;
        }
        return n3;
    }

    void setScrollPos(float f2, float f3) {
        this.m_scrollX = f2;
        this.m_scrollY = f3;
    }

    void setDrawPosition(float f2, float f3, float f4, float f5, float f6) {
        this.m_left = f2;
        this.m_top = f3;
        this.m_right = f4;
        this.m_bottom = f5;
        this.m_scale = f6;
    }
}

